package com.payu.india.Model.QuickPay;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Purpose of the class to perform construction of the Response Params for Send OTP and Resend OTP
 */
public class GlobalVaultOTPResponse implements Parcelable {

    private int httpStatusCode;
    private int responseCode;
    private String responseMessage;
    private long uuid;

    public GlobalVaultOTPResponse() {
    }

    protected GlobalVaultOTPResponse(Parcel in) {
        httpStatusCode = in.readInt();
        responseCode = in.readInt();
        responseMessage = in.readString();
        uuid = in.readLong();
    }

    public int getHttpStatusCode() {
        return httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public int getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public long getUuid() {
        return uuid;
    }

    public void setUuid(long uuid) {
        this.uuid = uuid;
    }

    public static final Creator<GlobalVaultOTPResponse> CREATOR = new Creator<GlobalVaultOTPResponse>() {
        @Override
        public GlobalVaultOTPResponse createFromParcel(Parcel in) {
            return new GlobalVaultOTPResponse(in);
        }

        @Override
        public GlobalVaultOTPResponse[] newArray(int size) {
            return new GlobalVaultOTPResponse[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(httpStatusCode);
        parcel.writeInt(responseCode);
        parcel.writeString(responseMessage);
        parcel.writeLong(uuid);
    }
}
