package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

public class NetworkToken implements Parcelable {
    public String tokenValue;
    public String tokenExpMon;
    public String tokenExpYr;
    private boolean isExpired;


    protected NetworkToken(Parcel in) {
        tokenValue = in.readString();
        tokenExpMon = in.readString();
        tokenExpYr = in.readString();
        isExpired = in.readByte() != 0;
    }

    public NetworkToken() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(tokenValue);
        dest.writeString(tokenExpMon);
        dest.writeString(tokenExpYr);
        dest.writeByte((byte) (isExpired ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<NetworkToken> CREATOR = new Creator<NetworkToken>() {
        @Override
        public NetworkToken createFromParcel(Parcel in) {
            return new NetworkToken(in);
        }

        @Override
        public NetworkToken[] newArray(int size) {
            return new NetworkToken[size];
        }
    };

    public String getTokenValue() {
        return tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getTokenExpMon() {
        return tokenExpMon;
    }

    public void setTokenExpMon(String tokenExpMon) {
        this.tokenExpMon = tokenExpMon;
    }

    public String getTokenExpYr() {
        return tokenExpYr;
    }

    public void setTokenExpYr(String tokenExpYr) {
        this.tokenExpYr = tokenExpYr;
    }

    public boolean getExpired() {
        return isExpired;
    }

    public void setExpired(boolean expired) {
        isExpired = expired;
    }
}
