package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

public class MerchantInfo implements Parcelable {

    private String logo;
    private String displayName;
    private int retryCount;
    private List<String> oneClickPayBankCodes;
    private String walletIdentifier;
    private List<IfscMappingDetails> ifscMappingDetails;

    public void setMerchantParamInfo(MerchantParamInfo merchantParamInfo) {
        this.merchantParamInfo = merchantParamInfo;
    }

    public MerchantParamInfo getMerchantParamInfo() {
        return merchantParamInfo;
    }

    private MerchantParamInfo merchantParamInfo;


    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public List<String> getOneClickPayBankCodes() {
        return oneClickPayBankCodes;
    }

    public void setOneClickPayBankCodes(List<String> oneClickPayBankCodes) {
        this.oneClickPayBankCodes = oneClickPayBankCodes;
    }

    public String getWalletIdentifier() {
        return walletIdentifier;
    }

    public void setWalletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
    }

    public List<IfscMappingDetails> getIfscMappingDetails() {
        return ifscMappingDetails;
    }

    public void setIfscMappingDetails(List<IfscMappingDetails> ifscMappingDetails) {
        this.ifscMappingDetails = ifscMappingDetails;
    }

    public MerchantInfo() {

    }

    protected MerchantInfo(Parcel in) {
        logo = in.readString();
        displayName = in.readString();
        retryCount = in.readInt();
        merchantParamInfo = in.readParcelable((MerchantParamInfo.class.getClassLoader()));
        oneClickPayBankCodes = in.readArrayList(String.class.getClassLoader());
        walletIdentifier = in.readString();
        ifscMappingDetails = in.readArrayList(IfscMappingDetails.class.getClassLoader());
    }

    public static final Creator<MerchantInfo> CREATOR = new Creator<MerchantInfo>() {
        @Override
        public MerchantInfo createFromParcel(Parcel in) {
            return new MerchantInfo(in);
        }

        @Override
        public MerchantInfo[] newArray(int size) {
            return new MerchantInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(logo);
        parcel.writeString(displayName);
        parcel.writeInt(retryCount);
        parcel.writeParcelable(merchantParamInfo, i);
        parcel.writeList(oneClickPayBankCodes);
        parcel.writeString(walletIdentifier);
        parcel.writeList(ifscMappingDetails);
    }
}
