package com.payu.india.Model.FetchOffer;

import android.util.Log;

import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class FetchOfferApiRequest extends V2ApiBase {
    private double amount;
    private String userToken;
    private String skuDetails;
    private String loggedInPhoneNumber;
    private Boolean isConsented;
    private List<String> enforcementOfferKeys;

    private FetchOfferApiRequest(Builder builder) {
        this.amount = builder.amount;
        this.userToken = builder.userToken;
        this.skuDetails = builder.skuDetails;
        this.loggedInPhoneNumber = builder.loggedInPhoneNumber;
        this.isConsented = builder.isConsented;
        this.enforcementOfferKeys = builder.enforcementOfferKeys;
    }

    @Override
    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (skuDetails != null) {
                jsonObject = getFetchOfferSkuJson(skuDetails);
            }
            jsonObject.put(PayuConstants.AMOUNT, amount);
            if(userToken != null)
                jsonObject.put(PayuConstants.USER_TOKEN, userToken);
            if(loggedInPhoneNumber!=null && !loggedInPhoneNumber.trim().isEmpty()) {
                JSONObject userDetail = new JSONObject();
                if(isConsented!= null)
                    userDetail.put(PayuConstants.IS_CONSENTED, isConsented);
                else
                    userDetail.put(PayuConstants.IS_CONSENTED, false);
                userDetail.put(PayuConstants.LOGGED_IN_PHONE_NUMBER, loggedInPhoneNumber);
                jsonObject.put(PayuConstants.USER_DETAIL, userDetail);
            }
            if(enforcementOfferKeys!=null && !enforcementOfferKeys.isEmpty()) {
                JSONArray enforceOfferKeysJsonArray = new JSONArray();
                for(int i = 0; i<enforcementOfferKeys.size(); i++){
                    String offerKey  = enforcementOfferKeys.get(i);
                    if(offerKey!=null && !offerKey.trim().isEmpty())
                        enforceOfferKeysJsonArray.put(offerKey);
                }
                if(enforceOfferKeysJsonArray.length() > 0)
                    jsonObject.put(PayuConstants.P_OFFER_KEY, enforceOfferKeysJsonArray);
            }
            return jsonObject.toString();
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return null;
    }

    public static class Builder {
        private final double amount;
        private final String userToken;
        private String skuDetails;
        private String loggedInPhoneNumber;
        private Boolean isConsented;
        private List<String> enforcementOfferKeys;

        public Builder(double amount, String userToken){
            this.amount = amount;
            this.userToken = userToken;
        }

        public Builder setSkuDetails(String skuDetails){
            this.skuDetails = skuDetails;
            return this;
        }

        public Builder setLoggedInPhoneNumber(String loggedInPhoneNumber) {
            this.loggedInPhoneNumber = loggedInPhoneNumber;
            return this;
        }

        public Builder setConsented(Boolean consented) {
            isConsented = consented;
            return this;
        }

        public Builder setEnforcementOfferKeys(List<String> enforcementOfferKeys){
            this.enforcementOfferKeys = enforcementOfferKeys;
            return this;
        }

        public FetchOfferApiRequest build() {
            return new FetchOfferApiRequest(this);
        }
    }

    private JSONObject getFetchOfferSkuJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_ID, PayuConstants.P_SKU_ID);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_AMOUNT, PayuConstants.P_SKU_AMOUNT);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.OFFER_KEY, PayuConstants.P_OFFER_KEY);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_DETAILS, PayuConstants.PAYU_SKUS_DETAILS);
        try {
            return new JSONObject(skuDetails);
        } catch (JSONException jsonException) {
            return new JSONObject();
        }
    }
}
