package com.payu.india.Model;


import com.payu.india.Payu.PayuConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class CheckoutFilter {
    private final String paymentOptionName;
    private final String paymentOptionType;
    private final String paymentOptionValue;

    private CheckoutFilter(Builder builder) {
        this.paymentOptionName = builder.paymentOptionName;
        this.paymentOptionType = builder.paymentOptionType;
        this.paymentOptionValue = builder.paymentOptionValue;
    }

    public JSONObject prepareFilterJson() {
        JSONObject paymentOptions = new JSONObject();
        JSONObject paymentOptionNameObject = new JSONObject();
        try {
            if (paymentOptionValue != null) {
                JSONObject paymentOptionTypeObject = new JSONObject();
                paymentOptionTypeObject.put(paymentOptionType, paymentOptionValue);
                paymentOptionNameObject.put(paymentOptionName, paymentOptionTypeObject);
            } else {
                paymentOptionNameObject.put(paymentOptionName, paymentOptionType);
            }
            paymentOptions.put(PayuConstants.P_PAYMENTOPTIONS, paymentOptionNameObject);

        } catch (JSONException e) {

        }
        return paymentOptions;
    }

    public static class Builder {
        private String paymentOptionName = null;
        private String paymentOptionType = null;
        private String paymentOptionValue = null;

        public Builder setPaymentOptionName(String paymentOptionName) {
            this.paymentOptionName = paymentOptionName;
            return this;
        }

        public Builder setPaymentOptionType(String paymentOptionType) {
            this.paymentOptionType = paymentOptionType;
            return this;
        }

        public Builder setPaymentOptionValue(String paymentOptionValue) {
            this.paymentOptionValue = paymentOptionValue;
            return this;
        }

        public CheckoutFilter build() {
            return new CheckoutFilter(this);
        }
    }

}
