package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;

import org.json.JSONObject;

import java.io.Serializable;

public class ApiResponse<T> implements Parcelable {
    private PostData postData;
    private JSONObject rawResponse;
    private T payuResponse;
    private int status;

    public ApiResponse(){

    }

    protected ApiResponse(Parcel in, Class<T> type) {
        postData = in.readParcelable(PostData.class.getClassLoader());
        payuResponse = in.readParcelable(type.getClassLoader());
        status = in.readInt();
    }

    public static final Creator<ApiResponse> CREATOR = new Creator<ApiResponse>() {


        @Override
        public ApiResponse createFromParcel(Parcel parcel) {
            try {
                Class<?> type = Class.forName(parcel.readString()); // Read the type name
                return new ApiResponse(parcel, type);
            } catch (Exception e) {
                return null;
            }

        }

        @Override
        public ApiResponse[] newArray(int size) {
            return new ApiResponse[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int i) {
        parcel.writeString(payuResponse.getClass().getName());
        parcel.writeParcelable(postData, i);
        parcel.writeParcelable((Parcelable) payuResponse, i);
        parcel.writeInt(status);
    }

    public PostData getPostData() {
        return postData;
    }

    public void setPostData(PostData postData) {
        this.postData = postData;
    }

    public JSONObject getRawResponse() {
        return rawResponse;
    }

    public void setRawResponse(JSONObject rawResponse) {
        this.rawResponse = rawResponse;
    }

    public T getPayuResponse() {
        return payuResponse;
    }

    public void setPayuResponse(T payuResponse) {
        this.payuResponse = payuResponse;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}
