package com.payu.india.Tasks;

import android.util.Log;

import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.PayUUserDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.net.ssl.HttpsURLConnection;

public class ValidateOfferTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private final ValidateOfferApiListener mvalidateOfferApiListener;

    public ValidateOfferTask(ValidateOfferApiListener validateOfferApiListener) {
        mvalidateOfferApiListener = validateOfferApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_APIV2_URL);
                    break;
                default:
                    url = new URL(PayuConstants.APIV2_URL);
                    break;
            }


            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).
                    setURL(url + PayuConstants.VALIDATEOFFER_API_ENDPOINT).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeaderWithSource(PayuConstants.PAYU_VALIDATE_OFFER_DETAILS)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                JSONObject result = response.optJSONObject(PayuConstants.P_RESULT);
                if (result != null) {
                    ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                    new V2ApiResponseParser().parseValidateOfferResponse(result, validateOfferDetails);
                    payuResponse.setValidateOfferDetails(validateOfferDetails);
                }
                PayuUtils.safeClose(responseInputStream);
            }
        } catch (ProtocolException e) {
            Log.d(getClass().getSimpleName(), "ProtocalException " + e.getMessage());
        } catch (IOException e) {
            Log.d(getClass().getSimpleName(), "IOException " + e.getMessage());
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private List<ValidateOfferInfo> prepareOfferInfoList(JSONArray offerDetailJsonArray) {
        List<ValidateOfferInfo> validateOfferInfoList = new ArrayList<>();
        for (int i = 0; i < offerDetailJsonArray.length(); i++) {
            JSONObject offerDetailJson = null;
            try {
                offerDetailJson = offerDetailJsonArray.getJSONObject(i);
                validateOfferInfoList.add(prepareValidateOfferInfo(offerDetailJson));
            } catch (JSONException e) {
                Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
            }
        }
        return validateOfferInfoList;
    }

    private ValidateOfferInfo prepareValidateOfferInfo(JSONObject validateInfoJsonObject) {
        ValidateOfferInfo validateOfferInfo = new ValidateOfferInfo();
        validateOfferInfo.setOfferKey(validateInfoJsonObject.optString(PayuConstants.F_OFFER_KEY));
        String offerType = validateInfoJsonObject.optString(PayuConstants.P_OFFERTYPE);
        validateOfferInfo.setOfferType(offerType);
        validateOfferInfo.setTitle(validateInfoJsonObject.optString(PayuConstants.TITLE));
        validateOfferInfo.setDescription(validateInfoJsonObject.optString(PayuConstants.DESCRIPTION));
        validateOfferInfo.setValidFrom(validateInfoJsonObject.optString(PayuConstants.P_VALIDFROM));
        validateOfferInfo.setValidTo(validateInfoJsonObject.optString(PayuConstants.P_VALIDTO));
        validateOfferInfo.setTnc(validateInfoJsonObject.optString(PayuConstants.P_TNC));
        validateOfferInfo.setTncLink(validateInfoJsonObject.optString(PayuConstants.P_TNCLINK));
        validateOfferInfo.setDiscountType(validateInfoJsonObject.optString(PayuConstants.P_DISCOUNTTYPE));
        validateOfferInfo.setOfferPercentage(validateInfoJsonObject.optString(PayuConstants.P_OFFERPERCENTAGE));
        validateOfferInfo.setMaxDiscountPerTxn(validateInfoJsonObject.optDouble(PayuConstants.P_MAX_DISCOUNT_PTXN));
        validateOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt(PayuConstants.P_MAXTXNAMT)).toString()));
        validateOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt(PayuConstants.P_MINTXNAMT)).toString()));
        validateOfferInfo.setStatus(validateInfoJsonObject.optString(PayuConstants.STATUS));
        validateOfferInfo.setIsNoCostEmi(validateInfoJsonObject.optBoolean(PayuConstants.P_ISNCE));
        validateOfferInfo.setValid(validateInfoJsonObject.optBoolean(PayuConstants.P_ISVALID));
        validateOfferInfo.setOfferCategory(validateInfoJsonObject.optString(PayuConstants.P_OFFER_CATEGORY));
        validateOfferInfo.setSkuOffer(validateInfoJsonObject.optBoolean(PayuConstants.P_IS_SKU_OFFER));
        validateOfferInfo.setAllPaymentMethodsAvailable(validateInfoJsonObject.optBoolean(PayuConstants.P_IS_ALL_P_MODE));
        validateOfferInfo.setDisallowTransactionInvalidOffer(validateInfoJsonObject.optBoolean(PayuConstants.P_DTXNINVALIDOFFER));
        validateOfferInfo.setAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.AMOUNT));
        validateOfferInfo.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.DISCOUNT));
        validateOfferInfo.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.P_DISCOUNTEDAMT));
        validateOfferInfo.setToDisplay(validateInfoJsonObject.optBoolean(PayuConstants.PAYU_PARAM_TO_DISPLAY));
        validateOfferInfo.setUserVerificationRequired(validateInfoJsonObject.optBoolean(PayuConstants.PAYU_PARAM_IS_USER_VERIFICATION_REQUIRED));
        DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
        discountDetailsofOffers.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.DISCOUNT));
        discountDetailsofOffers.setDiscountType(offerType);
        discountDetailsofOffers.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, PayuConstants.P_DISCOUNTEDAMT));
        validateOfferInfo.setDiscountDetails(discountDetailsofOffers);

        PayUUserDetails userDetails = new PayUUserDetails();
        if (validateInfoJsonObject.optJSONObject(PayuConstants.P_USER_DETAILS) != null) {
            JSONObject userDetailJsonObject = validateInfoJsonObject.optJSONObject(PayuConstants.P_USER_DETAILS);
            userDetails.setFirstName(userDetailJsonObject.optString(PayuConstants.PAYU_PARAM_FIRST_NAME));
            userDetails.setPhoneNo(userDetailJsonObject.optString(PayuConstants.P_PHONE_NO));
            userDetails.setEmail(userDetailJsonObject.optString(PayuConstants.EMAIL));
            validateOfferInfo.setUserDetails(userDetails);
        }
        return validateOfferInfo;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mvalidateOfferApiListener.onValiDateOfferResponse(payuResponse);
    }
}
