package com.payu.india.Tasks;

import static com.payu.india.Payu.PayuConstants.TOKENISED_CARD_CRYPTOGRAM;

import com.payu.india.Interfaces.GetTokenisedCardDetailsApiListener;
import com.payu.india.Model.IssuerToken;
import com.payu.india.Model.NetworkToken;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.TokenisedCardDetail;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Async task which takes care of deleting a card
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link GetTokenisedCardDetailsTask } should implement {@link GetTokenisedCardDetailsApiListener}
 */
public class GetTokenisedCardDetailsTask extends PayUAsyncTask<PayuConfig, String, PayuResponse> {

    private GetTokenisedCardDetailsApiListener mGetTokenisedCardDetailsApiListener;

    public GetTokenisedCardDetailsTask(GetTokenisedCardDetailsApiListener getTokenisedCardDetailsApiListener) {
        mGetTokenisedCardDetailsApiListener = getTokenisedCardDetailsApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }

            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);

                if (response.has(PayuConstants.TOKENISED_CARD_DETAILS)) { // yey! we have stored cards..
                    JSONObject cardDetails = response.getJSONObject(PayuConstants.TOKENISED_CARD_DETAILS);
                    TokenisedCardDetail tokenisedCardDetail = new TokenisedCardDetail();
                    tokenisedCardDetail.setCryptogram(cardDetails.getString(TOKENISED_CARD_CRYPTOGRAM));
                    tokenisedCardDetail.setCardPAR(cardDetails.optString(PayuConstants.CARD_PAR));
                    tokenisedCardDetail.setCardNo(cardDetails.getString(PayuConstants.CARD_NO));
                    tokenisedCardDetail.setCardToken(cardDetails.getString(PayuConstants.CARD_TOKEN));
                    tokenisedCardDetail.setCardName(cardDetails.getString(PayuConstants.CARD_NAME));
                    tokenisedCardDetail.setTrid(cardDetails.getString(PayuConstants.TOKENISED_CARD_TRID));
                    tokenisedCardDetail.setTokenRefernceId(cardDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_REFERENCE_ID));
                    tokenisedCardDetail.setCardMode(cardDetails.getString(PayuConstants.CARD_MODE));

                    if (cardDetails.has(PayuConstants.TOKENISED_CARD_ISSUER_TOKEN)) {
                        JSONObject issuerTokenDetails = cardDetails.getJSONObject(PayuConstants.TOKENISED_CARD_ISSUER_TOKEN);
                        IssuerToken issuerToken = new IssuerToken();
                        issuerToken.setTokenExpMon(issuerTokenDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_EXP_MON));
                        issuerToken.setTokenExpYr(issuerTokenDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_EXP_YR));
                        issuerToken.setTokenValue(issuerTokenDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_VALUE));

                        tokenisedCardDetail.setIssuerToken(issuerToken);
                    }
                    if (cardDetails.has(PayuConstants.TOKENISED_CARD_NETWORK_TOKEN)) {
                        JSONObject networkTokenDetails = cardDetails.getJSONObject(PayuConstants.TOKENISED_CARD_NETWORK_TOKEN);
                        NetworkToken networkToken = new NetworkToken();
                        networkToken.setTokenExpMon(networkTokenDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_EXP_MON));
                        networkToken.setTokenExpYr(networkTokenDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_EXP_YR));
                        networkToken.setTokenValue(networkTokenDetails.getString(PayuConstants.TOKENISED_CARD_TOKEN_VALUE));

                        tokenisedCardDetail.setNetworkToken(networkToken);
                    }
                    payuResponse.setTokenisedCardDetail(tokenisedCardDetail);
                }

                if (response.has(PayuConstants.STATUS) && response.getString(PayuConstants.STATUS).contentEquals("0")) { // hash mismatch
                    postData.setCode(PayuErrors.INVALID_HASH);
                    postData.setStatus(PayuConstants.ERROR);
                }
                if (response.has(PayuConstants.STATUS) && response.getString(PayuConstants.STATUS).contentEquals("1")) {
                    postData.setStatus(PayuConstants.SUCCESS);
                    postData.setCode(PayuErrors.NO_ERROR);
                }
                if (response.has(PayuConstants.MSG)) {
                    postData.setResult(response.getString(PayuConstants.MSG));
                }

            }
        } catch (MalformedURLException e) {
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (ProtocolException e) {
            postData.setCode(PayuErrors.PROTOCOL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }

        // gotta return payuResponse

        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mGetTokenisedCardDetailsApiListener.onTokenisedCardDetailsResponse(payuResponse);
    }
}
