package com.payu.india.Tasks;

import static com.payu.paymentparamhelper.PayuConstants.DATA;

import android.util.Log;

import androidx.annotation.NonNull;

import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

import javax.net.ssl.HttpsURLConnection;

public class ApiTask extends PayUAsyncTask<PayuConfig, String, ApiResponse<JSONObject>> {
    private final String TAG = this.getClass().getSimpleName();

    private final V2ApiResponseListener<ApiResponse<JSONObject>> v2ApiResponseListener;
    private final String commandName;
    private final HashMap<String, String> headerMap;

    public ApiTask(V2ApiResponseListener<ApiResponse<JSONObject>> v2ApiResponseListener, HashMap<String, String> headerMap, String commandName) {
        this.v2ApiResponseListener = v2ApiResponseListener;
        this.commandName = commandName;
        this.headerMap = headerMap;
    }

    @Override
    protected ApiResponse<JSONObject> doInBackground(PayuConfig... params) {
        Log.d(TAG, "doInBackground");

        ApiResponse<JSONObject> apiResponse = new ApiResponse<>();
        PostData postData = new PostData();
        InputStream responseInputStream = null;


        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];
            // set the environment
            //Todo: To be changed later
            url = PayuUtils.getApiV2Url(payuConfig);

            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + V2ApiHelper.getInstance().getApiEndPoint(commandName)).setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getOlwAuthHeader(commandName, headerMap)).
                    setRequestType(PayuConstants.REQUEST_APPLICATION_JSON).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
//
            if (null != conn) {
                if (conn.getResponseCode() == 200) responseInputStream = conn.getInputStream();
                else responseInputStream = conn.getErrorStream();
                apiResponse.setStatus(conn.getResponseCode());
                StringBuilder responseStringBuffer = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                apiResponse.setRawResponse(jsonResponse);
                apiResponse.setPayuResponse(jsonResponse);
                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.optInt(PayuConstants.STATUS) == 0) {
                    postData.setCode(PayuErrors.INFO_API_EXCEPTION);
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(jsonResponse.optString(DATA) != null ? jsonResponse.optString(DATA) : PayuConstants.SOMETHING_WENT_WRONG_ERROR);
                } else if (jsonResponse.optInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                }
            }
        } catch (MalformedURLException e) {
            Log.d(TAG, " MalformedURLException" + e.getMessage());
            postData.setCode(PayuErrors.MALFORMED_URL_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, " IOException" + e.getMessage());
            postData.setCode(PayuErrors.IO_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (IllegalArgumentException e) {
            Log.d(TAG, " IllegalArgumentException" + e.getMessage());
            postData.setCode(PayuErrors.ILLEGAL_ARGUMENT_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (JSONException e) {
            Log.d(TAG, " JSONException" + e.getMessage());
            postData.setCode(PayuErrors.JSON_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } catch (ArrayIndexOutOfBoundsException e) {
            Log.d(TAG, " ArrayIndexOutOfBoundsException" + e.getMessage());
            postData.setCode(PayuErrors.ARRAY_OUT_OF_BOUND_EXCEPTION);
            postData.setStatus(PayuConstants.ERROR);
            postData.setResult(e.getMessage());
        } finally {
            if (responseInputStream != null)
                PayuUtils.safeClose(responseInputStream);
        }
        apiResponse.setPostData(postData);
        return apiResponse;
    }



    @Override
    protected void onPostExecute(ApiResponse<JSONObject> jsonObjectApiResponse) {
        super.onPostExecute(jsonObjectApiResponse);
        v2ApiResponseListener.onApiResponse(jsonObjectApiResponse);
    }
}
