package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

public class ValidateOfferInfo extends OfferInformation implements Parcelable {

    private String offerKey;
    private String discountType;
    private String offerPercentage;
    private double maxDiscountPerTxn;
    private String status;
    private boolean disallowTransactionInvalidOffer;
    private boolean isValid;
    private String offerType;
    private String offerCategory;
    private boolean isSkuOffer;
    private boolean isAllPaymentMethodsAvailable;
    private DiscountDetailsofOffers discountDetails;
    public ValidateOfferInfo() {
    }

    protected ValidateOfferInfo(Parcel in) {
        super(in);
        offerKey = in.readString();
        discountType = in.readString();
        offerPercentage = in.readString();
        maxDiscountPerTxn = in.readDouble();
        status = in.readString();
        disallowTransactionInvalidOffer = in.readByte() != 0;
        isValid = in.readByte() != 0;
        offerType = in.readString();
        offerCategory = in.readString();
        isSkuOffer = in.readByte() != 0;
        isAllPaymentMethodsAvailable = in.readByte() != 0;
        discountDetails = in.readParcelable(DiscountDetailsofOffers.class.getClassLoader());
    }

    public static final Creator<ValidateOfferInfo> CREATOR = new Creator<ValidateOfferInfo>() {
        @Override
        public ValidateOfferInfo createFromParcel(Parcel in) {
            return new ValidateOfferInfo(in);
        }

        @Override
        public ValidateOfferInfo[] newArray(int size) {
            return new ValidateOfferInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(offerKey);
        parcel.writeString(discountType);
        parcel.writeString(offerPercentage);
        parcel.writeDouble(maxDiscountPerTxn);
        parcel.writeString(status);
        parcel.writeByte((byte) (disallowTransactionInvalidOffer ? 1 : 0));
        parcel.writeByte((byte) (isValid ? 1 : 0));
        parcel.writeString(offerType);
        parcel.writeString(offerCategory);
        parcel.writeByte((byte) (isSkuOffer ? 1 : 0));
        parcel.writeByte((byte) (isAllPaymentMethodsAvailable ? 1 : 0));
        parcel.writeParcelable(discountDetails, i);
    }

    @Override
    public String getOfferKey() {
        return offerKey;
    }

    @Override
    public void setOfferKey(String offerKey) {
        this.offerKey = offerKey;
    }

    public String getDiscountType() {
        return discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public String getOfferPercentage() {
        return offerPercentage;
    }

    public void setOfferPercentage(String offerPercentage) {
        this.offerPercentage = offerPercentage;
    }

    public Double getMaxDiscountPerTxn() {
        return maxDiscountPerTxn;
    }

    public void setMaxDiscountPerTxn(Double maxDiscountPerTxn) {
        this.maxDiscountPerTxn = maxDiscountPerTxn;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean getDisallowTransactionInvalidOffer() {
        return disallowTransactionInvalidOffer;
    }

    public void setDisallowTransactionInvalidOffer(boolean disallowTransactionInvalidOffer) {
        this.disallowTransactionInvalidOffer = disallowTransactionInvalidOffer;
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean valid) {
        isValid = valid;
    }

    @Override
    public String getOfferType() {
        return offerType;
    }

    @Override
    public void setOfferType(String offerType) {
        this.offerType = offerType;
    }

    public String getOfferCategory() {
        return offerCategory;
    }

    public void setOfferCategory(String offerCategory) {
        this.offerCategory = offerCategory;
    }

    public boolean isSkuOffer() {
        return isSkuOffer;
    }

    public void setSkuOffer(boolean skuOffer) {
        isSkuOffer = skuOffer;
    }

    @Override
    public DiscountDetailsofOffers getDiscountDetails() {
        return discountDetails;
    }

    @Override
    public void setDiscountDetails(DiscountDetailsofOffers discountDetails) {
        this.discountDetails = discountDetails;
    }

    public boolean isAllPaymentMethodsAvailable() {
        return isAllPaymentMethodsAvailable;
    }

    public void setAllPaymentMethodsAvailable(boolean allPayModeOffer) {
        isAllPaymentMethodsAvailable = allPayModeOffer;
    }
}
