package com.payu.india.Model.QuickPay;

import android.os.Parcel;
import android.os.Parcelable;

public class RecommendedOptions implements Parcelable {
    private String paymode;
    private String ibiboCode;
    private String action;
    private String tag;
    private String userInfo;
    private String paymentInfo;
    private boolean eligibilityCheck;
    private String eligibleAmount;
    private String title;
    private String msg;

    public RecommendedOptions() {

    }

    public String getPaymode() {
        return paymode;
    }

    public void setPaymode(String paymode) {
        this.paymode = paymode;
    }

    public String getIbiboCode() {
        return ibiboCode;
    }

    public void setIbiboCode(String ibiboCode) {
        this.ibiboCode = ibiboCode;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getPaymentInfo() {
        return paymentInfo;
    }

    public void setPaymentInfo(String paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    public boolean getEligibilityCheck() {
        return eligibilityCheck;
    }

    public void setEligibilityCheck(boolean eligibilityCheck) {
        this.eligibilityCheck = eligibilityCheck;
    }

    public String getEligibleAmount() {
        return eligibleAmount;
    }

    public void setEligibleAmount(String eligibleAmount) {
        this.eligibleAmount = eligibleAmount;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(paymode);
        out.writeString(ibiboCode);
        out.writeString(action);
        out.writeString(tag);
        out.writeString(userInfo);
        out.writeString(paymentInfo);
        out.writeByte((byte) (eligibilityCheck ? 1 : 0));
        out.writeString(eligibleAmount);
        out.writeString(title);
        out.writeString(msg);
    }

    public static final Parcelable.Creator<RecommendedOptions> CREATOR
            = new Parcelable.Creator<RecommendedOptions>() {
        public RecommendedOptions createFromParcel(Parcel in) {
            return new RecommendedOptions(in);
        }

        public RecommendedOptions[] newArray(int size) {
            return new RecommendedOptions[size];
        }
    };

    private RecommendedOptions(Parcel in) {
        paymode = in.readString();
        ibiboCode = in.readString();
        action = in.readString();
        tag = in.readString();
        userInfo = in.readString();
        paymentInfo = in.readString();
        eligibilityCheck = in.readByte() != 0;
        eligibleAmount = in.readString();
        title = in.readString();
        msg = in.readString();

    }
}


