package com.payu.india.Model.QuickPay;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Purpose of the class to perform construction of the Request Params to Verify Authentication
 */
public class GlobalVaultVerifyOTPRequest extends V2ApiBase {

    /* OTP */
    private final String otp;

    /* UUID */
    private final String uuid;

    /* Mobile Number */
    private final String mobileNumber;

    private GlobalVaultVerifyOTPRequest(Builder builder) {
        this.otp = builder.otp;
        this.uuid = builder.uuid;
        this.mobileNumber = builder.mobileNumber;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.OTP, otp);
            jsonObject.put(PayuConstants.UUID, uuid);
            jsonObject.put(PayuConstants.MOBILE_NUMBER, mobileNumber);
        } catch (JSONException e) {
            Log.d("GVVerifyOTPRequest", "Exception " + e.getMessage());
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String otp;

        private String uuid;

        private String mobileNumber;

        public Builder setOtp(String otp) {
            this.otp = otp;
            return this;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setMobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public GlobalVaultVerifyOTPRequest build() {
            return new GlobalVaultVerifyOTPRequest(this);
        }
    }
}
