package com.payu.india.Model;

import android.util.Log;

import com.payu.india.Payu.PayuConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class PaymentDetailsForOffer {
    private String cardHash;
    private String cardMask;
    private String category;
    private String paymentCode;
    private String vpa;
    private String cardNumber;
    private String cardToken;
    private int cardTokenType;

    private PaymentDetailsForOffer(Builder builder) {
        this.cardHash = builder.cardHash;
        this.cardMask = builder.cardMask;
        this.paymentCode = builder.paymentCode;
        ;
        this.category = builder.category;
        this.vpa = builder.vpa;
        this.cardNumber = builder.cardNumber;
        this.cardToken = builder.cardToken;
        this.cardTokenType = builder.cardTokenType;
    }

    public JSONObject prepareJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.P_CARD_HASH, cardHash);
            jsonObject.put(PayuConstants.P_CARD_MASK, cardMask);
            jsonObject.put(PayuConstants.P_PAYMENTCODE, paymentCode);
            jsonObject.put(PayuConstants.P_CATEGORY, category);
            jsonObject.put(PayuConstants.VPA, vpa);
            jsonObject.put(PayuConstants.P_CARD_NUMBER, cardNumber);
            jsonObject.put(PayuConstants.P_CARD_TOKEN, cardToken);
            if (cardToken != null)
                jsonObject.put(PayuConstants.P_CARD_TOKEN_TYPE, cardTokenType);
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException " + e.getMessage());
        }
        return jsonObject;
    }

    public static class Builder {
        private String cardHash;
        private String cardMask;
        private final String category;
        private final String paymentCode;
        private String vpa;
        private String cardNumber;
        private String cardToken;
        private int cardTokenType;

        public Builder(String category,String paymentCode){
            this.category = category;
            this.paymentCode = paymentCode;
        }

        public Builder setCardHash(String cardHash) {
            this.cardHash = cardHash;
            return this;
        }

        public Builder setCardMask(String cardMask) {
            this.cardMask = cardMask;
            return this;
        }

        public Builder setVpa(String vpa) {
            this.vpa = vpa;
            return this;
        }

        public Builder setCardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public Builder setCardToken(String cardToken) {
            this.cardToken = cardToken;
            return this;
        }

        public Builder setCardTokenType(int cardTokenType) {
            this.cardTokenType = cardTokenType;
            return this;
        }

        public PaymentDetailsForOffer build() {
            return new PaymentDetailsForOffer(this);
        }
    }
}
