package com.payu.india.Model.Olw;

import android.util.Log;
import android.util.Pair;

import com.payu.india.Payu.PayuConstants;
import com.payu.paymentparamhelper.EncryptionUtils;
import com.payu.paymentparamhelper.SetMPinEncryptedInfo;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONObject;


public class VerifyMPinRequest extends V2ApiBase {
    private final String mPin;
    private final String deviceId;
    private final SendOtpRequest sendOtpRequest;

    // Private constructor that takes a Builder
    private VerifyMPinRequest(Builder builder) {
        this.mPin = builder.mPin;
        this.deviceId = builder.deviceId;
        this.sendOtpRequest = builder.sendOtpRequest;
    }

    @Override
    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.PAYU_CLIENT_TXN_ID, sendOtpRequest.getClientTxnId());
            jsonObject.put(PayuConstants.PAYU_REQUEST_DATE_TIME, sendOtpRequest.getRequestDateTime());
            jsonObject.put(PayuConstants.PAYU_CUSTOMER_MOBILE, sendOtpRequest.getCustomerMobile());
            jsonObject.put(PayuConstants.PAYU_DEVICE_ID, deviceId);
            SetMPinEncryptedInfo setMPinEncryptedInfo = EncryptionUtils.encrypt(mPin);
            jsonObject.put(PayuConstants.PAYU_MPIN, setMPinEncryptedInfo.getmPin());
            jsonObject.put(PayuConstants.KEY, setMPinEncryptedInfo.getEncryptedAesKey());
        } catch (Exception e) {
            Log.d("VerifyMPinRequest", "Exception " + e.getMessage());
        }
        return jsonObject.toString();
    }

    // Static Builder class
    public static class Builder {
        private String mPin;
        private String deviceId;
        private String token;
        private SendOtpRequest sendOtpRequest;

        public Builder setMPin(String mPin) {
            this.mPin = mPin;
            return this;
        }

        public Builder setDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setSendOtpRequest(SendOtpRequest sendOtpRequest) {
            this.sendOtpRequest = sendOtpRequest;
            return this;
        }

        public VerifyMPinRequest build() {
            return new VerifyMPinRequest(this);
        }
    }
}

