package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

public class FetchofferDetails implements Parcelable {
    private ArrayList<FetchOfferInfo> payuOfferList;
    private ArrayList<SkuOfferInfo> skuOfferInfoList;
    private Boolean isUserPersonalizedOffersAvailable;
    private Boolean couponsAvailable;

    public FetchofferDetails() {
    }

    protected FetchofferDetails(Parcel in) {
        payuOfferList = in.createTypedArrayList(FetchOfferInfo.CREATOR);
        skuOfferInfoList = in.createTypedArrayList(SkuOfferInfo.CREATOR);
        isUserPersonalizedOffersAvailable = in.readByte() != 0;
        couponsAvailable = in.readByte() != 0;
    }

    public ArrayList<FetchOfferInfo> getPayuOfferList() {
        return payuOfferList;
    }

    public void setPayuOfferList(ArrayList<FetchOfferInfo> payuOfferList) {
        this.payuOfferList = payuOfferList;
    }

    public ArrayList<SkuOfferInfo> getSkuOfferInfoList() {
        return skuOfferInfoList;
    }

    public void setSkuOfferInfoList(ArrayList<SkuOfferInfo> skuOfferInfoList) {
        this.skuOfferInfoList = skuOfferInfoList;
    }

    public Boolean isUserPersonalizedOffersAvailable() {
        return isUserPersonalizedOffersAvailable;
    }

    public void setUserPersonalizedOffersAvailable(Boolean isUserPersonalizedOffersAvailable) {
        this.isUserPersonalizedOffersAvailable = isUserPersonalizedOffersAvailable;
    }

    public Boolean getCouponsAvailable() {
        return couponsAvailable;
    }

    public void setCouponsAvailable(Boolean couponsAvailable) {
        this.couponsAvailable = couponsAvailable;
    }

    public static final Creator<FetchofferDetails> CREATOR = new Creator<FetchofferDetails>() {
        @Override
        public FetchofferDetails createFromParcel(Parcel in) {
            return new FetchofferDetails(in);
        }

        @Override
        public FetchofferDetails[] newArray(int size) {
            return new FetchofferDetails[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeTypedList(payuOfferList);
        parcel.writeTypedList(skuOfferInfoList);
        parcel.writeByte((byte) (isUserPersonalizedOffersAvailable ? 1 : 0));
        parcel.writeByte((byte) (couponsAvailable ? 1 : 0));
    }
}
