package com.payu.india.Model;


import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class CalculateEmiRequest extends V2ApiBase {

    private long txnAmount;
    private long additionalCharges;
    private JSONArray offerKeys;
    private boolean autoApplyOffer;
    private List<String> bankCodes;
    private List<String> emiCodes;
    private String skuDetails;

    private JSONObject validateSku;
    private final String percentageAdditionalCharges;
    private final String additionalCharge;
    private final String txnId;
    private final String cardBin;


    private CalculateEmiRequest(Builder builder) {
        this.txnAmount = builder.txnAmount;
        this.additionalCharges = builder.additionalCharges;
        this.offerKeys = builder.offerKeys;
        this.autoApplyOffer = builder.autoApplyOffer;
        this.bankCodes = builder.bankCodes;
        this.emiCodes = builder.emiCodes;
        this.skuDetails = builder.skuDetails;
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges;
        this.additionalCharge = builder.additionalCharge;
        this.txnId = builder.txnId;
        this.cardBin = builder.cardBin;
    }

    public static class Builder {
        private long txnAmount;
        private long additionalCharges;
        private JSONArray offerKeys;
        private boolean autoApplyOffer;
        private List<String> bankCodes;
        private List<String> emiCodes;
        private String skuDetails;
        private String percentageAdditionalCharges;
        private String additionalCharge;
        private String txnId;
        private String cardBin;


        public long getTxnAmount() {
            return txnAmount;
        }

        public Builder setTxnAmount(long txnAmount) {
            this.txnAmount = txnAmount;
            return this;
        }

        public Builder setAdditionalCharges(long additionalCharges) {
            this.additionalCharges = additionalCharges;
            return this;
        }

        public Builder setOfferKeys(JSONArray offerKeys) {
            this.offerKeys = offerKeys;
            return this;
        }

        public Builder setAutoApplyOffer(boolean autoApplyOffer) {
            this.autoApplyOffer = autoApplyOffer;
            return this;
        }

        public Builder setBankCodes(List<String> bankCodes) {
            this.bankCodes = bankCodes;
            return this;
        }

        public Builder setEmiCodes(List<String> emiCodes) {
            this.emiCodes = emiCodes;
            return this;
        }

        public Builder setSkus(String skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public Builder setPercentageAdditionalCharges(String percentageAdditionalCharges){
            this.percentageAdditionalCharges = percentageAdditionalCharges;
            return this;
        }

        public Builder setAdditionalCharge(String additionalCharge){
            this.additionalCharge = additionalCharge;
            return this;
        }

        public Builder setTxnId(String txnId){
            this.txnId = txnId;
            return this;
        }
        public Builder setCardBin(String cardBin){
            this.cardBin = cardBin;
            return this;
        }

        public CalculateEmiRequest build() {
            return new CalculateEmiRequest(this);
        }

    }

    @Override
    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (skuDetails != null) {
                jsonObject = getSkuJson(skuDetails);
            }
            jsonObject.put(PayuConstants.P_TXN_AMOUNT, txnAmount);
            jsonObject.put(PayuConstants.P_ADDITIONAL_CHARGE, additionalCharges);
            if (offerKeys != null && offerKeys.length() > 0) {
                jsonObject.put(PayuConstants.P_OFFER_KEY, offerKeys);
            }
            jsonObject.put(PayuConstants.P_AUTO_APPLY_OFFER, autoApplyOffer);
            jsonObject.put(PayuConstants.P_BANK_CODES, bankCodes);
            JSONArray emiCodesArray = new JSONArray();
            for (String emiCode : emiCodes) {
                emiCodesArray.put(emiCode);
            }
            jsonObject.put(PayuConstants.P_EMI_CODES, emiCodesArray);
            jsonObject.put(PayuConstants.P_DISABLE_OVERRIDE_NCE_CONFIG, true);
            jsonObject.put(PayuConstants.PAYU_PERCENTAGE_ADDITIONAL_CHARGES, percentageAdditionalCharges);
            jsonObject.put(PayuConstants.MERCHANT_ADDITIONAL_CHARGES, additionalCharge);
            jsonObject.put(PayuConstants.PAYU_TXN_ID, txnId);
            jsonObject.put(PayuConstants.BIN, cardBin);
            return jsonObject.toString();
        } catch (JSONException e) {
            return null;
        }
    }

    public JSONObject getSkuJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_ID, PayuConstants.P_SKU_ID);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_AMOUNT, PayuConstants.P_SKU_AMOUNT);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_M_AMOUNT, PayuConstants.P_SKU_AMOUNT);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.OFFER_KEY, PayuConstants.P_OFFER_KEY);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_AUTO_APPLY_M_OFFER, PayuConstants.P_AUTO_APPLY);
        skuDetails = PayuUtils.replaceString(skuDetails, PayuConstants.P_SKU_DETAILS, PayuConstants.P_SKUS);
        try {
            return new JSONObject(skuDetails);
        } catch (JSONException exception) {
            return new JSONObject();
        }
    }
}
