/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Model.TransactionResponse;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.Payu;
import com.payu.india.Payu.TLSSocketFactory;
import com.payu.india.Tasks.PayuUploadDeviceAnalytics;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayuUtils {
    private static final String TAG = PayuUtils.class.getSimpleName();
    public static String cbVersion;
    public static Set<String> SBI_MAES_BIN;
    private static String keyAnalyticsUtil;

    public Boolean validateCardNumber(String cardNumber) {
        if (cardNumber.length() < 12) {
            return false;
        }
        if (this.getIssuer(cardNumber).contentEquals("RUPAY") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("VISA") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("MAST") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if ((this.getIssuer(cardNumber).contentEquals("MAES") || this.getIssuer(cardNumber).contentEquals("SMAE")) && cardNumber.length() >= 12 && cardNumber.length() <= 19) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("DINR") && cardNumber.length() == 14) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("AMEX") && cardNumber.length() == 15) {
            return this.luhn(cardNumber);
        }
        if (this.getIssuer(cardNumber).contentEquals("JCB") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        return this.luhn(cardNumber);
    }

    public Boolean luhn(String cardNumber) {
        int sum = 0;
        boolean alternate = false;
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(cardNumber.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        if (sum % 10 == 0) {
            return true;
        }
        return false;
    }

    public String getIssuer(String mCardNumber) {
        if (mCardNumber.startsWith("4")) {
            return "VISA";
        }
        if (mCardNumber.matches("^508[5-9][0-9][0-9]|60698[5-9]|60699[0-9]|607[0-8][0-9][0-9]|6079[0-7][0-9]|60798[0-4]|(?!608000)608[0-4][0-9][0-9]|608500|6521[5-9][0-9]|652[2-9][0-9][0-9]|6530[0-9][0-9]|6531[0-4][0-9]")) {
            return "RUPAY";
        }
        if (mCardNumber.matches("^((6304)|(6706)|(6771)|(6709))[\\d]+")) {
            return "LASER";
        }
        if (mCardNumber.matches("6(?:011|5[0-9]{2})[0-9]{12}[\\d]+")) {
            return "LASER";
        }
        if (mCardNumber.matches("(5[06-8]|6\\d)\\d{14}(\\d{2,3})?[\\d]+") || mCardNumber.matches("(5[06-8]|6\\d)[\\d]+") || mCardNumber.matches("((504([435|645|774|775|809|993]))|(60([0206]|[3845]))|(622[018])\\d)[\\d]+")) {
            if (mCardNumber.length() >= 6 && SBI_MAES_BIN.contains(mCardNumber.substring(0, 6))) {
                return "SMAE";
            }
            return "MAES";
        }
        if (mCardNumber.matches("^5[1-5][\\d]+") || mCardNumber.matches("^(222[1-9][0-9]{2}|22[3-9][0-9]{3}|2[3-6][0-9]{4}|27[0-1][0-9]{3}|2720[0-9]{2})[\\d]*$")) {
            return "MAST";
        }
        if (mCardNumber.matches("^3[47][\\d]+")) {
            return "AMEX";
        }
        if (mCardNumber.startsWith("36") || mCardNumber.matches("^30[0-5][\\d]+") || mCardNumber.matches("2(014|149)[\\d]+")) {
            return "DINR";
        }
        if (mCardNumber.matches("^35(2[89]|[3-8][0-9])[\\d]+")) {
            return "JCB";
        }
        return "UNDEFINED";
    }

    public boolean validateCvv(String cardNumber, String cvv) {
        String issuer = this.getIssuer(cardNumber);
        if (issuer.contentEquals("SMAE") || issuer.contentEquals("UNDEFINED")) {
            return true;
        }
        if (issuer.contentEquals("")) {
            return false;
        }
        if (issuer.contentEquals("AMEX") & cvv.length() == 4) {
            return true;
        }
        return !issuer.contentEquals("AMEX") && cvv.length() == 3;
    }

    public boolean validateExpiry(int expiryMonth, int expiryYear) {
        Calendar calendar = Calendar.getInstance();
        if (expiryMonth < 1 || expiryMonth > 12 || String.valueOf(expiryYear).length() != 4) {
            return false;
        }
        return calendar.get(1) <= expiryYear && (calendar.get(1) != expiryYear || calendar.get(2) + 1 <= expiryMonth);
    }

    protected String concatParams(String key, String value) {
        return key + "=" + value + "&";
    }

    protected PostData getReturnData(String result) {
        return this.getReturnData(5001, "ERROR", result);
    }

    protected PostData getReturnData(int code, String result) {
        return this.getReturnData(code, "ERROR", result);
    }

    protected PostData getReturnData(int code, String status, String result) {
        PostData postData = new PostData();
        postData.setCode(code);
        postData.setStatus(status);
        postData.setResult(result);
        return postData;
    }

    protected String trimAmpersand(String data) {
        return data.charAt(data.length() - 1) == '&' ? data.substring(0, data.length() - 1) : data;
    }

    static String getNetworkStatus(Context mContext) {
        try {
            if (null != mContext) {
                ConnectivityManager cm = (ConnectivityManager)mContext.getSystemService("connectivity");
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null || !info.isConnected()) {
                    return "Not connected";
                }
                if (info.getType() == 1) {
                    return "WIFI";
                }
                if (info.getType() == 0) {
                    int networkType = info.getSubtype();
                    switch (networkType) {
                        case 1: {
                            return "GPRS";
                        }
                        case 2: {
                            return "EDGE";
                        }
                        case 4: {
                            return "CDMA";
                        }
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            return "HSPA";
                        }
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                    }
                    return "?";
                }
            }
        }
        catch (Exception e) {
            return "?";
        }
        return "?";
    }

    private String getDeviceDensity(Context mContext) {
        DisplayMetrics metrics = new DisplayMetrics();
        return mContext.getResources().getDisplayMetrics().densityDpi + "";
    }

    private int getNetworkStrength(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo[] netInfo = connectivityManager.getAllNetworkInfo();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            int strength = 0;
            for (NetworkInfo networkInfo : netInfo) {
                if (!networkInfo.getTypeName().equalsIgnoreCase("MOBILE") || !networkInfo.isConnected()) continue;
                for (CellInfo info : telephonyManager.getAllCellInfo()) {
                    if (!info.isRegistered()) continue;
                    if (info instanceof CellInfoGsm) {
                        CellSignalStrengthGsm gsm = ((CellInfoGsm)info).getCellSignalStrength();
                        strength = gsm.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cdma = ((CellInfoCdma)info).getCellSignalStrength();
                        strength = cdma.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoLte) {
                        CellSignalStrengthLte lte = ((CellInfoLte)info).getCellSignalStrength();
                        strength = lte.getDbm();
                        continue;
                    }
                    if (!(info instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma wcdma = ((CellInfoWcdma)info).getCellSignalStrength();
                    strength = wcdma.getDbm();
                }
            }
            return strength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void deviceAnalytics(Context context, String merchantKey, String transactionId) {
        JSONObject deviceDetails = new JSONObject();
        try {
            deviceDetails.put("resolution", (Object)(this.getDeviceDensity(context) + ""));
            deviceDetails.put("device_manufacturer", (Object)Build.MANUFACTURER);
            deviceDetails.put("device_model", (Object)Build.MODEL);
            if (keyAnalyticsUtil != null && !keyAnalyticsUtil.trim().equals("")) {
                deviceDetails.put("merchant_key", (Object)keyAnalyticsUtil);
            } else {
                deviceDetails.put("merchant_key", (Object)merchantKey);
            }
            deviceDetails.put("txnid", (Object)transactionId);
            deviceDetails.put("sdk_version", (Object)"7.0.0");
            deviceDetails.put("cb_version", (Object)cbVersion);
            deviceDetails.put("os_version", (Object)(Build.VERSION.SDK_INT + ""));
            deviceDetails.put("network_info", (Object)(PayuUtils.getNetworkStatus(context) + ""));
            deviceDetails.put("network_strength", (Object)(this.getNetworkStrength(context) + ""));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
        }
        new PayuUploadDeviceAnalytics(context, "sdk_local_cache_device").log(deviceDetails.toString());
    }

    public void storeInSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public String getFromSharedPreferences(Context context, String key) {
        return this.getFromSharedPreferences(context, key, "default");
    }

    public String getFromSharedPreferences(Context context, String key, String defaultValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        return sharedPreferences.getString(key, defaultValue);
    }

    public void removeFromSharedPreferences(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public HashMap<String, ArrayList<StoredCard>> getStoredCard(Context context, ArrayList<StoredCard> cardList) {
        ArrayList<StoredCard> storedCards = new ArrayList<StoredCard>();
        HashMap<String, ArrayList<StoredCard>> cardMap = new HashMap<String, ArrayList<StoredCard>>();
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        if (null != cardList) {
            storedCards.addAll(cardList);
        }
        cardMap.put("store_card", storedCards);
        return cardMap;
    }

    public HashMap<String, ArrayList<StoredCard>> getStoredCard(ArrayList<StoredCard> cardList) {
        ArrayList<StoredCard> storedCards = new ArrayList<StoredCard>();
        HashMap<String, ArrayList<StoredCard>> cardMap = new HashMap<String, ArrayList<StoredCard>>();
        if (null != cardList) {
            storedCards.addAll(cardList);
        }
        cardMap.put("store_card", storedCards);
        return cardMap;
    }

    public static void setAnalyticsKeyCB(PayuConfig payuConfig) {
        String analyticsKey = PayuUtils.getAnalyticsKeyFromConfig(payuConfig);
        PayuUtils.setAnalyticsKeyCB(analyticsKey);
    }

    public static void setAnalyticsKeyCB(String analyticsKey) {
        try {
            if (analyticsKey != null && !analyticsKey.trim().equals("")) {
                keyAnalyticsUtil = analyticsKey;
                Class<?> aClass = Class.forName("com.payu.custombrowser.Bank");
                Field field = aClass.getDeclaredField("keyAnalytics");
                field.setAccessible(true);
                field.set(null, analyticsKey);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
        }
    }

    public static void setVariableCB(String pakageName, HashMap<String, String> cbAnalyticsKeys, String Version) {
        try {
            Class<?> aClass = Class.forName(pakageName);
            for (String key : cbAnalyticsKeys.keySet()) {
                try {
                    Field field = aClass.getDeclaredField(key);
                    field.setAccessible(true);
                    field.set(null, cbAnalyticsKeys.get(key));
                    field.setAccessible(false);
                }
                catch (Exception exception) {}
            }
            Field field = aClass.getDeclaredField(Version);
            field.setAccessible(true);
            cbVersion = (String)field.get(null);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
        }
    }

    private static String getAnalyticsKeyFromConfig(PayuConfig payuConfig) {
        try {
            String[] list;
            for (String item : list = payuConfig.getData().split("&")) {
                String id;
                String[] items = item.split("=");
                if (items.length < 2) continue;
                switch (id = items[0]) {
                    case "key": {
                        return items[1];
                    }
                }
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
        }
        return null;
    }

    private String getVariableReflection(String className, String fieldName) {
        try {
            Class<?> mClass = Class.forName(className);
            Field mField = mClass.getDeclaredField(fieldName);
            return (String)mField.get(null);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)("ClassNotFoundException " + e.getMessage()));
        }
        catch (NoSuchFieldException e) {
            Log.d((String)TAG, (String)("NoSuchFieldException " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            Log.d((String)TAG, (String)("IllegalAccessException " + e.getMessage()));
        }
        return null;
    }

    public TransactionResponse getTransactionResponse(String transactionRespObj) {
        try {
            JSONObject mJSONObject = new JSONObject(transactionRespObj);
            TransactionResponse transactionResponse = new TransactionResponse();
            Iterator keysIterator = mJSONObject.keys();
            while (keysIterator.hasNext()) {
                switch ((String)keysIterator.next()) {
                    case "id": 
                    case "mihpayid": {
                        if (mJSONObject.has("id")) {
                            transactionResponse.setId(mJSONObject.get("id").toString());
                            break;
                        }
                        if (!mJSONObject.has("mihpayid")) break;
                        transactionResponse.setId(mJSONObject.get("mihpayid").toString());
                        break;
                    }
                    case "mode": {
                        if (!mJSONObject.has("mode")) break;
                        transactionResponse.setMode(mJSONObject.get("mode").toString());
                        break;
                    }
                    case "status": {
                        if (!mJSONObject.has("status")) break;
                        transactionResponse.setStatus(mJSONObject.get("status").toString());
                        break;
                    }
                    case "unmappedstatus": {
                        if (!mJSONObject.has("unmappedstatus")) break;
                        transactionResponse.setUnMappedStatus(mJSONObject.get("unmappedstatus").toString());
                        break;
                    }
                    case "key": {
                        if (!mJSONObject.has("key")) break;
                        transactionResponse.setKey(mJSONObject.get("key").toString());
                        break;
                    }
                    case "txnid": {
                        if (!mJSONObject.has("txnid")) break;
                        transactionResponse.setTxnid(mJSONObject.get("txnid").toString());
                        break;
                    }
                    case "transaction_fee": {
                        if (!mJSONObject.has("transaction_fee")) break;
                        transactionResponse.setTransactionFee(mJSONObject.get("transaction_fee").toString());
                        break;
                    }
                    case "cardCategory": {
                        if (!mJSONObject.has("cardCategory")) break;
                        transactionResponse.setCardCategory(mJSONObject.get("cardCategory").toString());
                        break;
                    }
                    case "discount": {
                        if (!mJSONObject.has("discount")) break;
                        transactionResponse.setDiscount(mJSONObject.get("discount").toString());
                        break;
                    }
                    case "additional_charges": {
                        if (!mJSONObject.has("additional_charges")) break;
                        transactionResponse.setAdditionalCharges(mJSONObject.get("additional_charges").toString());
                        break;
                    }
                    case "addedon": {
                        if (!mJSONObject.has("addedon")) break;
                        transactionResponse.setAddedOn(mJSONObject.get("addedon").toString());
                        break;
                    }
                    case "productinfo": {
                        if (!mJSONObject.has("productinfo")) break;
                        transactionResponse.setProductInfo(mJSONObject.get("productinfo").toString());
                        break;
                    }
                    case "firstname": {
                        if (!mJSONObject.has("firstname")) break;
                        transactionResponse.setFirstName(mJSONObject.get("firstname").toString());
                        break;
                    }
                    case "email": {
                        if (!mJSONObject.has("email")) break;
                        transactionResponse.setEmail(mJSONObject.get("email").toString());
                        break;
                    }
                    case "udf1": {
                        if (!mJSONObject.has("udf1")) break;
                        transactionResponse.setUdf1(mJSONObject.get("udf1").toString());
                        break;
                    }
                    case "udf2": {
                        if (!mJSONObject.has("udf2")) break;
                        transactionResponse.setUdf2(mJSONObject.get("udf2").toString());
                        break;
                    }
                    case "udf3": {
                        if (!mJSONObject.has("udf3")) break;
                        transactionResponse.setUdf3(mJSONObject.get("udf3").toString());
                        break;
                    }
                    case "udf4": {
                        if (!mJSONObject.has("udf4")) break;
                        transactionResponse.setUdf4(mJSONObject.get("udf4").toString());
                        break;
                    }
                    case "udf5": {
                        if (!mJSONObject.has("udf5")) break;
                        transactionResponse.setUdf5(mJSONObject.get("udf5").toString());
                        break;
                    }
                    case "hash": {
                        if (!mJSONObject.has("hash")) break;
                        transactionResponse.setHash(mJSONObject.get("hash").toString());
                        break;
                    }
                    case "field1": {
                        if (!mJSONObject.has("field1")) break;
                        transactionResponse.setField1(mJSONObject.get("field1").toString());
                        break;
                    }
                    case "field2": {
                        if (!mJSONObject.has("field2")) break;
                        transactionResponse.setField2(mJSONObject.get("field2").toString());
                        break;
                    }
                    case "field3": {
                        if (!mJSONObject.has("field3")) break;
                        transactionResponse.setField3(mJSONObject.get("field3").toString());
                        break;
                    }
                    case "field4": {
                        if (!mJSONObject.has("field4")) break;
                        transactionResponse.setField4(mJSONObject.get("field4").toString());
                        break;
                    }
                    case "field9": {
                        if (!mJSONObject.has("field9")) break;
                        transactionResponse.setField9(mJSONObject.get("field9").toString());
                        break;
                    }
                    case "payment_source": {
                        if (!mJSONObject.has("payment_source")) break;
                        transactionResponse.setPaymentSource(mJSONObject.get("payment_source").toString());
                        break;
                    }
                    case "PG_TYPE": {
                        if (!mJSONObject.has("PG_TYPE")) break;
                        transactionResponse.setPgType(mJSONObject.get("PG_TYPE").toString());
                        break;
                    }
                    case "bank_ref_num": {
                        if (!mJSONObject.has("bank_ref_num")) break;
                        transactionResponse.setBankRefNo(mJSONObject.get("bank_ref_num").toString());
                        break;
                    }
                    case "ibibo_code": {
                        if (!mJSONObject.has("ibibo_code")) break;
                        transactionResponse.setIbiboCode(mJSONObject.get("ibibo_code").toString());
                        break;
                    }
                    case "error_code": {
                        if (!mJSONObject.has("error_code")) break;
                        transactionResponse.setErrorCode(mJSONObject.get("error_code").toString());
                        break;
                    }
                    case "Error_Message": {
                        if (!mJSONObject.has("Error_Message")) break;
                        transactionResponse.setErrorMessage(mJSONObject.get("Error_Message").toString());
                        break;
                    }
                    case "card_token": {
                        if (!mJSONObject.has("card_token")) break;
                        transactionResponse.setCardToken(mJSONObject.get("card_token").toString());
                        break;
                    }
                    case "name_on_card": {
                        if (!mJSONObject.has("name_on_card")) break;
                        transactionResponse.setNameOnCard(mJSONObject.get("name_on_card").toString());
                        break;
                    }
                    case "card_no": {
                        if (!mJSONObject.has("card_no")) break;
                        transactionResponse.setCardNumber(mJSONObject.get("card_no").toString());
                        break;
                    }
                    case "issuingBank": {
                        if (!mJSONObject.has("issuingBank")) break;
                        transactionResponse.setIssuingBank(mJSONObject.get("issuingBank").toString());
                        break;
                    }
                    case "card_type": {
                        if (!mJSONObject.has("card_type")) break;
                        transactionResponse.setCardType(mJSONObject.get("card_type").toString());
                        break;
                    }
                    case "is_seamless": {
                        if (!mJSONObject.has("is_seamless")) break;
                        transactionResponse.setIsSeamless(mJSONObject.get("is_seamless").toString());
                        break;
                    }
                    case "surl": {
                        if (!mJSONObject.has("surl")) break;
                        transactionResponse.setSurl(mJSONObject.get("surl").toString());
                        break;
                    }
                    case "furl": {
                        if (!mJSONObject.has("furl")) break;
                        transactionResponse.setFurl(mJSONObject.get("furl").toString());
                        break;
                    }
                    case "merchant_hash": {
                        if (!mJSONObject.has("merchant_hash")) break;
                        transactionResponse.setMerchantHash(mJSONObject.get("merchant_hash").toString());
                    }
                }
            }
            return transactionResponse;
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)("JSONException " + e.getMessage()));
            return null;
        }
    }

    public JSONObject getTransactionResponseJson(JSONObject transactionRespObj) {
        try {
            JSONObject transactionResponse = new JSONObject();
            Iterator keysIterator = transactionRespObj.keys();
            while (keysIterator.hasNext()) {
                switch ((String)keysIterator.next()) {
                    case "id": 
                    case "mihpayid": {
                        if (transactionRespObj.has("id")) {
                            transactionResponse.put("id", (Object)transactionRespObj.get("id").toString());
                            break;
                        }
                        if (!transactionRespObj.has("mihpayid")) break;
                        transactionResponse.put("id", (Object)transactionRespObj.get("mihpayid").toString());
                        break;
                    }
                    case "mode": {
                        if (!transactionRespObj.has("mode")) break;
                        transactionResponse.put("mode", (Object)transactionRespObj.get("mode").toString());
                        break;
                    }
                    case "amt": 
                    case "amount": {
                        if (transactionRespObj.has("amt")) {
                            transactionResponse.put("amount", (Object)transactionRespObj.get("amt").toString());
                            break;
                        }
                        if (!transactionRespObj.has("transaction_amount")) break;
                        transactionResponse.put("amount", (Object)transactionRespObj.get("transaction_amount").toString());
                        break;
                    }
                    case "status": {
                        if (!transactionRespObj.has("status")) break;
                        transactionResponse.put("status", (Object)transactionRespObj.get("status").toString());
                        break;
                    }
                    case "unmappedstatus": {
                        if (!transactionRespObj.has("unmappedstatus")) break;
                        transactionResponse.put("unmappedstatus", (Object)transactionRespObj.get("unmappedstatus").toString());
                        break;
                    }
                    case "key": {
                        if (!transactionRespObj.has("key")) break;
                        transactionResponse.put("key", (Object)transactionRespObj.get("key").toString());
                        break;
                    }
                    case "txnid": {
                        if (!transactionRespObj.has("txnid")) break;
                        transactionResponse.put("txnid", (Object)transactionRespObj.get("txnid").toString());
                        break;
                    }
                    case "transaction_fee": {
                        if (!transactionRespObj.has("transaction_fee")) break;
                        transactionResponse.put("transaction_fee", (Object)transactionRespObj.get("transaction_fee").toString());
                        break;
                    }
                    case "cardCategory": {
                        if (!transactionRespObj.has("cardCategory")) break;
                        transactionResponse.put("cardCategory", (Object)transactionRespObj.get("cardCategory").toString());
                        break;
                    }
                    case "discount": {
                        if (!transactionRespObj.has("discount")) break;
                        transactionResponse.put("discount", (Object)transactionRespObj.get("discount").toString());
                        break;
                    }
                    case "additional_charges": {
                        if (!transactionRespObj.has("additional_charges")) break;
                        transactionResponse.put("additional_charges", (Object)transactionRespObj.get("additional_charges").toString());
                        break;
                    }
                    case "addedon": {
                        if (!transactionRespObj.has("addedon")) break;
                        transactionResponse.put("addedon", (Object)transactionRespObj.get("addedon").toString());
                        break;
                    }
                    case "productinfo": {
                        if (!transactionRespObj.has("productinfo")) break;
                        transactionResponse.put("productinfo", (Object)transactionRespObj.get("productinfo").toString());
                        break;
                    }
                    case "firstname": {
                        if (!transactionRespObj.has("firstname")) break;
                        transactionResponse.put("firstname", (Object)transactionRespObj.get("firstname").toString());
                        break;
                    }
                    case "email": {
                        if (!transactionRespObj.has("email")) break;
                        transactionResponse.put("email", (Object)transactionRespObj.get("email").toString());
                        break;
                    }
                    case "udf1": {
                        if (!transactionRespObj.has("udf1")) break;
                        transactionResponse.put("udf1", (Object)transactionRespObj.get("udf1").toString());
                        break;
                    }
                    case "udf2": {
                        if (!transactionRespObj.has("udf2")) break;
                        transactionResponse.put("udf2", (Object)transactionRespObj.get("udf2").toString());
                        break;
                    }
                    case "udf3": {
                        if (!transactionRespObj.has("udf3")) break;
                        transactionResponse.put("udf3", (Object)transactionRespObj.get("udf3").toString());
                        break;
                    }
                    case "udf4": {
                        if (!transactionRespObj.has("udf4")) break;
                        transactionResponse.put("udf4", (Object)transactionRespObj.get("udf4").toString());
                        break;
                    }
                    case "udf5": {
                        if (!transactionRespObj.has("udf5")) break;
                        transactionResponse.put("udf5", (Object)transactionRespObj.get("udf5").toString());
                        break;
                    }
                    case "hash": {
                        if (!transactionRespObj.has("hash")) break;
                        transactionResponse.put("hash", (Object)transactionRespObj.get("hash").toString());
                        break;
                    }
                    case "field1": {
                        if (!transactionRespObj.has("field1")) break;
                        transactionResponse.put("field1", (Object)transactionRespObj.get("field1").toString());
                        break;
                    }
                    case "field2": {
                        if (!transactionRespObj.has("field2")) break;
                        transactionResponse.put("field2", (Object)transactionRespObj.get("field2").toString());
                        break;
                    }
                    case "field3": {
                        if (!transactionRespObj.has("field3")) break;
                        transactionResponse.put("field3", (Object)transactionRespObj.get("field3").toString());
                        break;
                    }
                    case "field4": {
                        if (!transactionRespObj.has("field4")) break;
                        transactionResponse.put("field4", (Object)transactionRespObj.get("field4").toString());
                        break;
                    }
                    case "field9": {
                        if (!transactionRespObj.has("field9")) break;
                        transactionResponse.put("field9", (Object)transactionRespObj.get("field9").toString());
                        break;
                    }
                    case "payment_source": {
                        if (!transactionRespObj.has("payment_source")) break;
                        transactionResponse.put("payment_source", (Object)transactionRespObj.get("payment_source").toString());
                        break;
                    }
                    case "PG_TYPE": {
                        if (!transactionRespObj.has("PG_TYPE")) break;
                        transactionResponse.put("PG_TYPE", (Object)transactionRespObj.get("PG_TYPE").toString());
                        break;
                    }
                    case "bank_ref_num": {
                        if (!transactionRespObj.has("bank_ref_num")) break;
                        transactionResponse.put("bank_ref_num", (Object)transactionRespObj.get("bank_ref_num").toString());
                        break;
                    }
                    case "ibibo_code": {
                        if (!transactionRespObj.has("ibibo_code")) break;
                        transactionResponse.put("ibibo_code", (Object)transactionRespObj.get("ibibo_code").toString());
                        break;
                    }
                    case "error_code": {
                        if (!transactionRespObj.has("error_code")) break;
                        transactionResponse.put("error_code", (Object)transactionRespObj.get("error_code").toString());
                        break;
                    }
                    case "Error_Message": {
                        if (!transactionRespObj.has("Error_Message")) break;
                        transactionResponse.put("Error_Message", (Object)transactionRespObj.get("Error_Message").toString());
                        break;
                    }
                    case "card_token": {
                        if (!transactionRespObj.has("card_token")) break;
                        transactionResponse.put("card_token", (Object)transactionRespObj.get("card_token").toString());
                        break;
                    }
                    case "name_on_card": {
                        if (!transactionRespObj.has("name_on_card")) break;
                        transactionResponse.put("name_on_card", (Object)transactionRespObj.get("name_on_card").toString());
                        break;
                    }
                    case "card_no": {
                        if (!transactionRespObj.has("card_no")) break;
                        transactionResponse.put("card_no", (Object)transactionRespObj.get("card_no").toString());
                        break;
                    }
                    case "issuingBank": {
                        if (!transactionRespObj.has("issuingBank")) break;
                        transactionResponse.put("issuingBank", (Object)transactionRespObj.get("issuingBank").toString());
                        break;
                    }
                    case "card_type": {
                        if (!transactionRespObj.has("card_type")) break;
                        transactionResponse.put("card_type", (Object)transactionRespObj.get("card_type").toString());
                        break;
                    }
                    case "is_seamless": {
                        if (!transactionRespObj.has("is_seamless")) break;
                        transactionResponse.put("is_seamless", (Object)transactionRespObj.get("is_seamless").toString());
                        break;
                    }
                    case "surl": {
                        if (!transactionRespObj.has("surl")) break;
                        transactionResponse.put("surl", (Object)transactionRespObj.get("surl").toString());
                        break;
                    }
                    case "furl": {
                        if (!transactionRespObj.has("furl")) break;
                        transactionResponse.put("furl", (Object)transactionRespObj.get("furl").toString());
                        break;
                    }
                    case "merchant_hash": {
                        if (!transactionRespObj.has("merchant_hash")) break;
                        transactionResponse.put("merchant_hash", (Object)transactionRespObj.get("merchant_hash").toString());
                    }
                }
            }
            return transactionResponse;
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)("Exception: " + e.getMessage()));
            return null;
        }
    }

    protected String getImei() {
        String imei;
        try {
            TelephonyManager mTelephonyMgr = (TelephonyManager)Payu.getInstance().getCallingAppContext().getSystemService("phone");
            imei = mTelephonyMgr.getDeviceId();
        }
        catch (Exception e) {
            imei = "default";
        }
        return imei;
    }

    protected String getUdid() {
        String udid;
        try {
            udid = Settings.Secure.getString((ContentResolver)Payu.getInstance().getCallingAppContext().getContentResolver(), (String)"android_id");
        }
        catch (Exception e) {
            udid = "default";
        }
        return udid;
    }

    public static HttpsURLConnection getHttpsConn(String strURL, String postData) {
        try {
            return PayuUtils.getHttpsConn(strURL, postData, -1);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
            return null;
        }
    }

    public static HttpsURLConnection getHttpsConn(String strURL, String postData, String requestProperty) {
        try {
            return PayuUtils.getHttpsConn(strURL, postData, -1, requestProperty);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
            return null;
        }
    }

    private static HttpsURLConnection getHttpsConn(String strURL, String postData, int timeout, String requestProperty) {
        try {
            URL url = new URL(strURL);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            if (timeout != -1) {
                conn.setConnectTimeout(timeout);
            }
            conn.setRequestProperty("Content-Type", requestProperty);
            if (postData != null) {
                conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
            }
            conn.setSSLSocketFactory(new TLSSocketFactory());
            if (postData != null) {
                byte[] postParamsByte = postData.getBytes();
                conn.getOutputStream().write(postParamsByte);
            }
            return conn;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
            return null;
        }
    }

    public static HttpsURLConnection getHttpsConn(String strURL, String postData, int timeout) {
        return PayuUtils.getHttpsConn(strURL, postData, timeout, "application/x-www-form-urlencoded");
    }

    public static HttpsURLConnection getHttpsConn(String strURL) {
        try {
            URL url = new URL(strURL);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setSSLSocketFactory(new TLSSocketFactory());
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            return conn;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception " + e.getMessage()));
            return null;
        }
    }

    public static String getAnalyticsString(String analyticsData) {
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = analyticsData == null ? new JSONArray() : new JSONArray(analyticsData);
            JSONObject analyticsJsonObject = new JSONObject();
            analyticsJsonObject.put("platform", (Object)"android");
            analyticsJsonObject.put("name", (Object)"coresdk");
            analyticsJsonObject.put("version", (Object)"7.0.0");
            jsonArray.put((Object)analyticsJsonObject);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)("JSONException " + e.getMessage()));
        }
        return jsonArray.toString();
    }

    public Boolean validateCardNumber(String cardNumber, String issuer) {
        if (cardNumber.length() < 12 || issuer == null) {
            return false;
        }
        if (issuer.contentEquals("RUPAY") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if (issuer.contentEquals("VISA") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if (issuer.contentEquals("MAST") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        if ((issuer.contentEquals("MAES") || issuer.contentEquals("SMAE")) && cardNumber.length() >= 12 && cardNumber.length() <= 19) {
            return this.luhn(cardNumber);
        }
        if (issuer.contentEquals("DINR") && cardNumber.length() == 14) {
            return this.luhn(cardNumber);
        }
        if (issuer.contentEquals("AMEX") && cardNumber.length() == 15) {
            return this.luhn(cardNumber);
        }
        if (issuer.contentEquals("JCB") && cardNumber.length() == 16) {
            return this.luhn(cardNumber);
        }
        return this.luhn(cardNumber);
    }

    public static HttpsURLConnection getHttpsConn(HttpRequest request) {
        try {
            URL url = new URL(request.getURL());
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(request.getMethod().name());
            if (request.getHeaders() != null) {
                for (String key : request.getHeaders().keySet()) {
                    conn.setRequestProperty(key, request.getHeaders().get(key));
                }
            }
            if (request.getTimeout() != -1) {
                conn.setConnectTimeout(request.getTimeout());
            }
            conn.setRequestProperty("Content-Type", request.getRequestType());
            if (request.getPostData() != null) {
                conn.setRequestProperty("Content-Length", String.valueOf(request.getPostData().length()));
            }
            conn.setSSLSocketFactory(new TLSSocketFactory());
            if (request.getPostData() != null) {
                byte[] postParamsByte = request.getPostData().getBytes();
                conn.getOutputStream().write(postParamsByte);
            }
            return conn;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception: " + e.getMessage()));
            return null;
        }
    }

    public static StringBuffer getStringBuffer(HttpsURLConnection conn) throws IOException {
        int i;
        int statusCode = conn.getResponseCode();
        InputStream responseInputStream = statusCode >= 200 && statusCode < 400 ? conn.getInputStream() : conn.getErrorStream();
        StringBuffer responseStringBuffer = new StringBuffer();
        byte[] byteContainer = new byte[1024];
        while ((i = responseInputStream.read(byteContainer)) != -1) {
            responseStringBuffer.append(new String(byteContainer, 0, i));
        }
        PayuUtils.safeClose(responseInputStream);
        return responseStringBuffer;
    }

    public static String updateAnalytics(String data) {
        if (!data.contains("coresdk")) {
            String[] spiltData;
            for (String value : spiltData = data.split("&")) {
                if (!value.contains("sdk_platform") || value.contains("coresdk")) continue;
                String analyticsString = PayuUtils.getAnalyticsString(value.split("=")[1]);
                data = data.replace(value, "sdk_platform".concat("=").concat(analyticsString));
                break;
            }
        }
        return data;
    }

    public static String getPaymentTypeValue(String payMode) {
        switch (payMode) {
            case "cashcard": {
                return "wallet";
            }
            case "creditcard": {
                return "card";
            }
            case "debitcard": {
                return "card";
            }
        }
        return payMode;
    }

    public static void safeClose(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Exception: " + e.getMessage()));
        }
    }

    static {
        SBI_MAES_BIN = new HashSet<String>();
        SBI_MAES_BIN.add("504435");
        SBI_MAES_BIN.add("504645");
        SBI_MAES_BIN.add("504775");
        SBI_MAES_BIN.add("504809");
        SBI_MAES_BIN.add("504993");
        SBI_MAES_BIN.add("600206");
        SBI_MAES_BIN.add("603845");
        SBI_MAES_BIN.add("622018");
        SBI_MAES_BIN.add("504774");
    }
}

