/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import com.payu.india.AnalyticsUtils;
import com.payu.india.Model.PayURequest.PayUCards.PayUCardDetail;
import com.payu.india.Model.PayURequest.PayUGetCheckoutDetailsParam;
import com.payu.india.Model.PayURequest.PayUModelPaymentParam;
import com.payu.india.Payu.PayUV2Utils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001c\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0007J\u001a\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0004J\u0018\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0004J\u001e\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0010\u0010!\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0004J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0004J\u0010\u0010%\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0010\u0010&\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0018\u0010'\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\u0004J\u0010\u0010)\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0004J\u0010\u0010+\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0016\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J\u0010\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004\u00a8\u00063"}, d2={"Lcom/payu/india/Payu/PayuUtils;", "", "()V", "concatParams", "", "key", "value", "concatParams$android_sdk_release", "generateResponseJson", "request", "response", "getCheckoutDetailsRequestString", "paymentParam", "Lcom/payu/india/Model/PayURequest/PayUModelPaymentParam;", "getEnvironmentString", "environment", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "getIssuer", "cardNumber", "getPaymentTypeValue", "payMode", "isCardNumberNullOrEmpty", "", "payuParams", "isJsonString", "str", "isNullOrEmpty", "parameter", "type", "luhn", "updateGetCheckoutDetailsParams", "useCaseParam", "validateAmount", "amount", "validateCardNumber", "issuer", "validateCardNumberForCheckIsDomestic", "validateCardNumberString", "validateCvv", "cvv", "validatePhoneNumber", "phoneNumber", "validatePipedTransactionID", "transactionID", "validateRegex", "regex", "string", "validateUserCredentials", "userCredentials", "Companion", "android_sdk_release"})
public final class PayuUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String isNullOrEmpty(@Nullable String parameter, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CharSequence charSequence = parameter;
        return charSequence == null || charSequence.length() == 0 ? Intrinsics.stringPlus((String)type, (Object)" is missing, ") : "";
    }

    @NotNull
    public final String validateCardNumberString(@Nullable String cardNumber) {
        CharSequence charSequence = cardNumber;
        return !(charSequence == null || charSequence.length() == 0) && cardNumber.length() <= 5 ? "Card number or Card Bin is Invalid," : "";
    }

    public final boolean isCardNumberNullOrEmpty(@NotNull PayUModelPaymentParam payuParams) {
        Intrinsics.checkNotNullParameter((Object)payuParams, (String)"payuParams");
        PayUCardDetail payUCardDetail = payuParams.getCardDetail();
        String cardNumber = payUCardDetail == null ? null : payUCardDetail.getCardNumber();
        CharSequence charSequence = cardNumber;
        return charSequence == null || charSequence.length() == 0;
    }

    @NotNull
    public final String generateResponseJson(@Nullable String request, @Nullable String response2) {
        return "request =" + request + "\n response =" + response2;
    }

    public final boolean isJsonString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        try {
            Json.Default.parseToJsonElement(str);
        }
        catch (SerializationException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final String updateGetCheckoutDetailsParams(@NotNull String useCaseParam, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)useCaseParam, (String)"useCaseParam");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String useCase = useCaseParam;
        useCase = Intrinsics.stringPlus((String)useCase, (Object)(((CharSequence)useCase).length() == 0 ? '\"' + key + "\":" + value : ",\"" + key + "\":" + value));
        return useCase;
    }

    @NotNull
    public final String getCheckoutDetailsRequestString(@NotNull PayUModelPaymentParam paymentParam) {
        Intrinsics.checkNotNullParameter((Object)paymentParam, (String)"paymentParam");
        String useCaseParam = "";
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam == null ? false : payUGetCheckoutDetailsParam.getGetExtendedPaymentDetails()) {
            useCaseParam = Intrinsics.stringPlus((String)useCaseParam, (Object)"\"getExtendedPaymentDetails\":true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam2 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam2 == null ? false : payUGetCheckoutDetailsParam2.getCheckTaxSpecification()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getTaxSpecification", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam3 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam3 == null ? false : payUGetCheckoutDetailsParam3.getCheckDownStatus()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "checkDownStatus", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam4 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam4 == null ? false : payUGetCheckoutDetailsParam4.getCheckAdditionalCharges()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getAdditionalCharges", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam5 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam5 == null ? false : payUGetCheckoutDetailsParam5.getCheckOfferDetails()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getOfferDetails", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam6 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam6 == null ? false : payUGetCheckoutDetailsParam6.getGetPgIdForEachOption()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getPgIdForEachOption", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam7 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam7 == null ? false : payUGetCheckoutDetailsParam7.getCheckCustomerEligibility()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "checkCustomerEligibility", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam8 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam8 == null ? false : payUGetCheckoutDetailsParam8.getGetMerchantDetails()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getMerchantDetails", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam9 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam9 == null ? false : payUGetCheckoutDetailsParam9.getGetExtendedPaymentDetails()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getExtendedPaymentDetails", "true");
        }
        PayUGetCheckoutDetailsParam payUGetCheckoutDetailsParam10 = paymentParam.getGetCheckoutDetailsParam();
        if (payUGetCheckoutDetailsParam10 == null ? false : payUGetCheckoutDetailsParam10.getGetSdkDetails()) {
            useCaseParam = this.updateGetCheckoutDetailsParams(useCaseParam, "getSdkDetails", "true");
        }
        String params = "";
        if (((CharSequence)useCaseParam).length() > 0) {
            params = params + "\"useCase\":{" + useCaseParam + '}';
        }
        String requestId = "";
        requestId = paymentParam.getTransactionID() != null ? Intrinsics.stringPlus((String)requestId, (Object)paymentParam.getTransactionID()) : new PayUV2Utils().getCurrentTimeMiliSecond();
        params = this.updateGetCheckoutDetailsParams(params, "requestId", '\"' + requestId + '\"');
        if (paymentParam.getPhoneNumber() != null) {
            String mobileParam = "";
            mobileParam = mobileParam + "\"mobile\":\"" + paymentParam.getPhoneNumber() + '\"';
            params = this.updateGetCheckoutDetailsParams(params, "customerDetails", '{' + mobileParam + '}');
        }
        String amountParam = "";
        amountParam = amountParam + "\"amount\":\"" + paymentParam.getAmount() + '\"';
        params = this.updateGetCheckoutDetailsParams(params, "transactionDetails", '{' + amountParam + '}');
        System.out.print((Object)params);
        return '{' + params + '}';
    }

    @NotNull
    public final String validateUserCredentials(@Nullable String userCredentials) {
        String[] stringArray;
        List colonLocation;
        CharSequence charSequence = userCredentials;
        String string = charSequence == null || charSequence.length() == 0 ? "User credentials is missing, " : (StringsKt.contains$default((CharSequence)userCredentials, (CharSequence)":", (boolean)false, (int)2, null) ? (((Collection)(colonLocation = StringsKt.split$default((CharSequence)userCredentials, (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null))).size() < 2 ? "Invalid User credentials, " : "") : "Invalid User credentials, ");
        return string;
    }

    @NotNull
    public final String validateAmount(@Nullable String amount) {
        double minAmountDouble;
        double amountDouble;
        CharSequence charSequence = amount;
        String string = charSequence == null || charSequence.length() == 0 ? "amountis missing, " : (this.validateRegex("[0-9]*\\.?[0-9]*", amount) ? ((amountDouble = Double.parseDouble(amount)) >= (minAmountDouble = 0.1) ? "" : "amount is less than minimum amount, ") : "amount is non-numeric, ");
        return string;
    }

    @NotNull
    public final String validateCardNumberForCheckIsDomestic(@Nullable String cardNumber) {
        String string = cardNumber;
        if (string != null) {
            StringsKt.replace((String)string, (String)" ", (String)"", (boolean)true);
        }
        String string2 = cardNumber;
        if (string2 != null) {
            StringsKt.replace((String)string2, (String)"\n", (String)"", (boolean)true);
        }
        return Intrinsics.areEqual((Object)this.getIssuer(cardNumber), (Object)"Card number or Card Bin is Invalid,") ? "Card number or Card Bin is Invalid," : "";
    }

    @NotNull
    public final String getIssuer(@Nullable String cardNumber) {
        String first6DigitOfCardNumber;
        String string;
        String passedCardNumber;
        block18: {
            block17: {
                boolean bl;
                String string2 = cardNumber;
                String string3 = passedCardNumber = string2 == null ? null : StringsKt.replace$default((String)string2, (String)" ", (String)"", (boolean)false, (int)4, null);
                Integer n = string3 == null ? null : Integer.valueOf(string3.length());
                Intrinsics.checkNotNull((Object)n);
                if (n <= 5) break block17;
                Long l = StringsKt.toLongOrNull((String)passedCardNumber);
                if (l == null) {
                    bl = false;
                } else {
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    bl = true;
                }
                if (bl) break block18;
            }
            return "Card number or Card Bin is Invalid,";
        }
        if (passedCardNumber.length() >= 7) {
            String string4 = passedCardNumber.substring(0, 6);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string4;
        } else {
            string = first6DigitOfCardNumber = passedCardNumber;
        }
        if (((CharSequence)first6DigitOfCardNumber).length() > 0) {
            Object[] it = new String[]{"504435", "504645", "504775", "504809", "504993", "600206", "603845", "622018", "504774"};
            Object[] SMAEArray = it;
            Object[] objectArray = new String[]{"637513"};
            Object[] SODEXOArray = objectArray;
            if (first6DigitOfCardNumber.charAt(0) == '4') {
                return "VISA";
            }
            if (this.validateRegex("^508[5-9][0-9][0-9]|60698[5-9]|60699[0-9]|607[0-8][0-9][0-9]|6079[0-7][0-9]|60798[0-4]|(?!608000)608[0-4][0-9][0-9]|608500|6521[5-9][0-9]|652[2-9][0-9][0-9]|6530[0-9][0-9]|6531[0-4][0-9]", first6DigitOfCardNumber)) {
                return "RUPAY";
            }
            if (this.validateRegex("^((6304)|(6706)|(6771)|(6709))[\\d]+", first6DigitOfCardNumber) || this.validateRegex("6(?:011|5[0-9]{2})[0-9]{12}[\\d]+", first6DigitOfCardNumber)) {
                return "LASER";
            }
            if (this.validateRegex("(5[06-8]|6\\d)\\d{14}(\\d{2,3})?[\\d]+", first6DigitOfCardNumber) || this.validateRegex("(5[06-8]|6\\d)[\\d]+", first6DigitOfCardNumber) || this.validateRegex("((504([435|645|774|775|809|993]))|(60([0206]|[3845]))|(622[018])\\d)[\\d]+", first6DigitOfCardNumber)) {
                return ArraysKt.contains((Object[])SMAEArray, (Object)((Object)first6DigitOfCardNumber.subSequence(0, 6)).toString()) ? "SMAE" : "MAES";
            }
            if (this.validateRegex("^5[1-5][\\d]+", first6DigitOfCardNumber)) {
                return "MAST";
            }
            if (this.validateRegex("^3[47][\\d]+", first6DigitOfCardNumber)) {
                return "AMEX";
            }
            if (this.validateRegex("^30[0-5][\\d]+", first6DigitOfCardNumber) || this.validateRegex("2(014|149)[\\d]+", first6DigitOfCardNumber) || this.validateRegex("36[\\d]+", first6DigitOfCardNumber)) {
                return "DINR";
            }
            if (this.validateRegex("^35(2[89]|[3-8][0-9])[\\d]+", first6DigitOfCardNumber)) {
                return "JCB";
            }
            if (ArraysKt.contains((Object[])SODEXOArray, (Object)first6DigitOfCardNumber)) {
                return "SODEXO";
            }
        }
        return "";
    }

    public final boolean validateRegex(@NotNull String regex, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (((CharSequence)regex).length() == 0 && ((CharSequence)string).length() == 0) {
            return false;
        }
        Regex pattern = new Regex(regex);
        return pattern.containsMatchIn((CharSequence)string);
    }

    @NotNull
    public final String validatePhoneNumber(@Nullable String phoneNumber) {
        CharSequence charSequence = phoneNumber;
        return charSequence == null || charSequence.length() == 0 ? "Phone number is missing, " : (!this.validateRegex("[7896][0-9]{9}", phoneNumber) ? "Phone number is invalid, " : "");
    }

    @NotNull
    public final String validatePipedTransactionID(@Nullable String transactionID) {
        String errorString = "";
        CharSequence charSequence = transactionID;
        if (charSequence == null || charSequence.length() == 0) {
            errorString = Intrinsics.stringPlus((String)errorString, (Object)"Transaction ID is missing, ");
        } else if (transactionID.length() > 25) {
            errorString = Intrinsics.stringPlus((String)errorString, (Object)"Transaction ID greater than 25 character, ");
        }
        return errorString;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getPaymentTypeValue(@Nullable String payMode) {
        String string = payMode;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 24519875: {
                    if (!string.equals("cashcard")) break;
                    n = 1;
                    break;
                }
                case -563871351: {
                    if (!string.equals("creditcard")) break;
                    n = 2;
                    break;
                }
                case -529352196: {
                    if (!string.equals("debitcard")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return "wallet";
                }
                case 2: {
                    return "card";
                }
                case 3: {
                    return "card";
                }
            }
        }
        String string2 = payMode;
        String string3 = string2;
        if (string2 != null) return string3;
        return "";
    }

    @NotNull
    public final String getEnvironmentString(@Nullable Integer environment) {
        Integer n = environment;
        boolean bl = false;
        return n != null && n == 0 ? "Production" : "Test";
    }

    public final boolean validateCvv(@Nullable String cardNumber, @NotNull String cvv) {
        Intrinsics.checkNotNullParameter((Object)cvv, (String)"cvv");
        String issuer = this.getIssuer(cardNumber);
        if (issuer.contentEquals("")) {
            return false;
        }
        if (issuer.contentEquals("SMAE") || issuer.contentEquals("UNDEFINED")) {
            return true;
        }
        if (issuer.contentEquals("AMEX") && cvv.length() == 4) {
            return true;
        }
        return !issuer.contentEquals("AMEX") && cvv.length() == 3;
    }

    public final boolean validateCardNumber(@NotNull String cardNumber) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        return this.validateCardNumber(cardNumber, this.getIssuer(cardNumber));
    }

    public final boolean luhn(@NotNull String cardNumber) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        int sum = 0;
        boolean alternate = false;
        int n = cardNumber.length() - 1;
        if (0 <= n) {
            do {
                int i = n--;
                String string = cardNumber;
                int n2 = i + 1;
                String string2 = string.substring(i, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int n3 = Integer.parseInt(string2);
                if (alternate && (n3 *= 2) > 9) {
                    n3 = n3 % 10 + 1;
                }
                sum += n3;
                boolean bl = alternate = !alternate;
            } while (0 <= n);
        }
        return sum % 10 == 0;
    }

    @NotNull
    public final String concatParams$android_sdk_release(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return key + '=' + value + '&';
    }

    public final boolean validateCardNumber(@NotNull String cardNumber, @Nullable String issuer) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        return cardNumber.length() < 12 || issuer == null ? false : (issuer.contentEquals("RUPAY") && cardNumber.length() == 16 ? this.luhn(cardNumber) : (issuer.contentEquals("VISA") && cardNumber.length() == 16 ? this.luhn(cardNumber) : (issuer.contentEquals("MAST") && cardNumber.length() == 16 ? this.luhn(cardNumber) : ((issuer.contentEquals("MAES") || issuer.contentEquals("SMAE")) && cardNumber.length() >= 12 && cardNumber.length() <= 19 ? this.luhn(cardNumber) : (issuer.contentEquals("DINR") && cardNumber.length() == 14 ? this.luhn(cardNumber) : (issuer.contentEquals("AMEX") && cardNumber.length() == 15 ? this.luhn(cardNumber) : (issuer.contentEquals("JCB") && cardNumber.length() == 16 ? this.luhn(cardNumber) : this.luhn(cardNumber))))))));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/payu/india/Payu/PayuUtils$Companion;", "", "()V", "getAnalyticsString", "", "analyticsData", "updateAnalytics", "data", "android_sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAnalyticsString(@Nullable String analyticsData) {
            return new AnalyticsUtils().getAnalyticsString(analyticsData);
        }

        @NotNull
        public final String updateAnalytics(@NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new AnalyticsUtils().updateAnalytics(data);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

