/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import com.payu.india.DateTime;
import com.payu.india.Model.PayURequestHeaderParams;
import com.payu.india.Payu.PayuUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0004J\b\u0010\b\u001a\u00020\u0004H\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lcom/payu/india/Payu/PayUV2Utils;", "", "()V", "getAuthorizationTokenWithSignature", "", "signature", "key", "getCurrentTimeMiliSecond", "getGMTFormattedDateString", "getSigningStringWithDate", "postData", "date", "getV2APIHeaderParams", "Lcom/payu/india/Model/PayURequestHeaderParams;", "android_sdk_release"})
public final class PayUV2Utils {
    @NotNull
    public final String getCurrentTimeMiliSecond() {
        return new DateTime().getCurrentTimeInMilliSeconds();
    }

    private final String getGMTFormattedDateString() {
        return new DateTime().getFormattedDate("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    }

    @NotNull
    public final String getSigningStringWithDate(@NotNull String postData, @NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)postData, (String)"postData");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return postData + '|' + date + '|';
    }

    @NotNull
    public final String getAuthorizationTokenWithSignature(@NotNull String signature, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return "hmac username=\"" + key + "\", algorithm=\"sha512\", headers=\"date\", signature=\"" + signature + '\"';
    }

    @NotNull
    public final PayURequestHeaderParams getV2APIHeaderParams(@NotNull String postData) {
        Intrinsics.checkNotNullParameter((Object)postData, (String)"postData");
        PayURequestHeaderParams obj = new PayURequestHeaderParams(null, null, null, null, 15, null);
        String date = this.getGMTFormattedDateString();
        String signingString = this.getSigningStringWithDate(postData, date);
        String error = "";
        error = Intrinsics.stringPlus((String)error, (Object)new PayuUtils().isNullOrEmpty(date, "Date"));
        error = Intrinsics.stringPlus((String)error, (Object)new PayuUtils().isNullOrEmpty(signingString, "Signing String"));
        obj.setDate(date);
        obj.setSigningString(signingString);
        obj.setError(error);
        return obj;
    }
}

