/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.CheckOfferDetailsApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuOfferDetails;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PayuUserOffer;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckOfferDetailsTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    CheckOfferDetailsApiListener mCheckOfferDetailsApiListener;

    public CheckOfferDetailsTask(CheckOfferDetailsApiListener checkOfferDetailsApiListener) {
        this.mCheckOfferDetailsApiListener = checkOfferDetailsApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                PayuOfferDetails payuOfferDetails = new PayuOfferDetails();
                if (response.has("data_key")) {
                    ArrayList<PayuUserOffer> payuUserOfferArrayList = new ArrayList<PayuUserOffer>();
                    if (response.get("data_key").toString().contentEquals("card_tokens")) {
                        JSONObject cardTokensObject = response.getJSONObject("card_tokens");
                        Iterator cardTokenKeys = cardTokensObject.keys();
                        while (cardTokenKeys.hasNext()) {
                            JSONObject cardDataAndOfferObject = cardTokensObject.getJSONObject((String)cardTokenKeys.next());
                            JSONObject cardDataObject = cardDataAndOfferObject.getJSONObject("card_data");
                            JSONObject offerDataObject = cardDataAndOfferObject.getJSONObject("offer_data");
                            Iterator cardDataKeys = cardDataObject.keys();
                            PayuUserOffer payuUserOffer = new PayuUserOffer();
                            StoredCard storedCard = new StoredCard();
                            while (cardDataKeys.hasNext()) {
                                switch ((String)cardDataKeys.next()) {
                                    case "name_on_card": {
                                        storedCard.setNameOnCard(cardDataObject.get("name_on_card").toString());
                                        break;
                                    }
                                    case "card_name": {
                                        storedCard.setCardName(cardDataObject.get("card_name").toString());
                                        break;
                                    }
                                    case "expiry_year": {
                                        storedCard.setExpiryYear(cardDataObject.get("expiry_year").toString());
                                        break;
                                    }
                                    case "expiry_month": {
                                        storedCard.setExpiryMonth(cardDataObject.get("expiry_month").toString());
                                        break;
                                    }
                                    case "card_type": {
                                        storedCard.setCardType(cardDataObject.get("card_type").toString());
                                        break;
                                    }
                                    case "card_token": {
                                        storedCard.setCardToken(cardDataObject.get("card_token").toString());
                                        break;
                                    }
                                    case "is_expired": {
                                        storedCard.setIsExpired(cardDataObject.getInt("is_expired") != 0);
                                        break;
                                    }
                                    case "card_mode": {
                                        storedCard.setCardMode(cardDataObject.get("card_mode").toString());
                                        break;
                                    }
                                    case "card_no": {
                                        storedCard.setMaskedCardNumber(cardDataObject.get("card_no").toString());
                                        break;
                                    }
                                    case "card_brand": {
                                        storedCard.setCardBrand(cardDataObject.get("card_brand").toString());
                                        break;
                                    }
                                    case "card_bin": {
                                        storedCard.setCardBin(cardDataObject.get("card_bin").toString());
                                        break;
                                    }
                                    case "isDomestic": {
                                        storedCard.setIsDomestic(cardDataObject.get("isDomestic").toString());
                                    }
                                }
                            }
                            payuUserOffer.setStoredCard(storedCard);
                            Iterator offerDataKeys = offerDataObject.keys();
                            ArrayList<PayuOffer> payuOffersList = new ArrayList<PayuOffer>();
                            while (offerDataKeys.hasNext()) {
                                JSONObject offerObject = offerDataObject.getJSONObject((String)offerDataKeys.next());
                                Iterator offerKeys = offerObject.keys();
                                PayuOffer payuOffer = new PayuOffer();
                                while (offerKeys.hasNext()) {
                                    switch ((String)offerKeys.next()) {
                                        case "status": {
                                            payuOffer.setStatus(offerObject.get("status").toString());
                                            break;
                                        }
                                        case "msg": {
                                            payuOffer.setMsg(offerObject.get("msg").toString());
                                            break;
                                        }
                                        case "error_code": {
                                            payuOffer.setErrorCode(offerObject.get("error_code").toString());
                                            break;
                                        }
                                        case "offer_key": {
                                            payuOffer.setOfferKey(offerObject.get("offer_key").toString());
                                            break;
                                        }
                                        case "offer_type": {
                                            payuOffer.setOfferType(offerObject.get("offer_type").toString());
                                            break;
                                        }
                                        case "offer_availed_count": {
                                            payuOffer.setOfferAvailedCount(offerObject.get("offer_availed_count").toString());
                                            break;
                                        }
                                        case "offer_remaining_count": {
                                            payuOffer.setOfferRemainingCount(offerObject.get("offer_remaining_count").toString());
                                            break;
                                        }
                                        case "discount": {
                                            payuOffer.setDiscount(offerObject.get("discount").toString());
                                            break;
                                        }
                                        case "category": {
                                            payuOffer.setCategory(offerObject.get("category").toString());
                                            break;
                                        }
                                        case "allowed_on": {
                                            ArrayList<String> allowedOnList = new ArrayList<String>();
                                            for (String token : offerObject.get("allowed_on").toString().split(",")) {
                                                allowedOnList.add(token);
                                            }
                                            payuOffer.setAllowedOn(allowedOnList);
                                        }
                                    }
                                }
                                payuOffersList.add(payuOffer);
                            }
                            payuUserOffer.setAvailableCardOffers(payuOffersList);
                            payuUserOfferArrayList.add(payuUserOffer);
                        }
                        payuOfferDetails.setUserOffersList(payuUserOfferArrayList);
                        payuResponse.setPayuOfferDetails(payuOfferDetails);
                    } else if (response.get("data_key").toString().contentEquals("offer_key")) {
                        JSONObject offerDetailsObject = response.getJSONObject("offer_key");
                        Iterator keys = offerDetailsObject.keys();
                        ArrayList<PayuOffer> offerDetailsList = new ArrayList<PayuOffer>();
                        while (keys.hasNext()) {
                            JSONObject offerObject = offerDetailsObject.getJSONObject((String)keys.next());
                            PayuOffer payuOffer = new PayuOffer();
                            Iterator offerKeys = offerObject.keys();
                            while (offerKeys.hasNext()) {
                                switch ((String)offerKeys.next()) {
                                    case "status": {
                                        payuOffer.setStatus(offerObject.get("status").toString());
                                        break;
                                    }
                                    case "msg": {
                                        payuOffer.setMsg(offerObject.get("msg").toString());
                                        break;
                                    }
                                    case "error_code": {
                                        payuOffer.setErrorCode(offerObject.get("error_code").toString());
                                        break;
                                    }
                                    case "offer_key": {
                                        payuOffer.setOfferKey(offerObject.get("offer_key").toString());
                                        break;
                                    }
                                    case "offer_type": {
                                        payuOffer.setOfferType(offerObject.get("offer_type").toString());
                                        break;
                                    }
                                    case "offer_availed_count": {
                                        payuOffer.setOfferAvailedCount(offerObject.get("offer_availed_count").toString());
                                        break;
                                    }
                                    case "offer_remaining_count": {
                                        payuOffer.setOfferRemainingCount(offerObject.get("offer_remaining_count").toString());
                                        break;
                                    }
                                    case "discount": {
                                        payuOffer.setDiscount(offerObject.get("discount").toString());
                                        break;
                                    }
                                    case "category": {
                                        payuOffer.setCategory(offerObject.get("category").toString());
                                        break;
                                    }
                                    case "allowed_on": {
                                        ArrayList<String> allowedOnList = new ArrayList<String>();
                                        for (String token : offerObject.get("allowed_on").toString().split(",")) {
                                            allowedOnList.add(token);
                                        }
                                        payuOffer.setAllowedOn(allowedOnList);
                                    }
                                }
                            }
                            offerDetailsList.add(payuOffer);
                        }
                        payuOfferDetails.setPayuOfferList(offerDetailsList);
                        payuResponse.setPayuOfferDetails(payuOfferDetails);
                    }
                }
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
                if (response.has("status") && response.getInt("status") == 0) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                payuResponse.setResponseStatus(postData);
            }
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mCheckOfferDetailsApiListener.onCheckOfferDetailsApiResponse(payuResponse);
    }
}

