/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import org.json.JSONException;
import org.json.JSONObject;

public class Usecase {
    private final boolean getAdditionalCharges;
    private final boolean getTaxSpecification;
    private final boolean checkDownStatus;
    private final boolean getOfferDetails;
    private final boolean getExtendedPaymentDetails;
    private final boolean checkCustomerEligibility;
    private final boolean getMerchantDetails;
    private final boolean getPaymentDetailsWithExtraFields;
    private final boolean getSdkDetails;

    private Usecase(Builder builder) {
        this.getAdditionalCharges = builder.getAdditionalCharges;
        this.getTaxSpecification = builder.getTaxSpecification;
        this.checkDownStatus = builder.checkDownStatus;
        this.getOfferDetails = builder.getOfferDetails;
        this.getExtendedPaymentDetails = builder.getExtendedPaymentDetails;
        this.checkCustomerEligibility = builder.checkCustomerEligibility;
        this.getMerchantDetails = builder.getMerchantDetails;
        this.getPaymentDetailsWithExtraFields = builder.getPaymentDetailsWithExtraFields;
        this.getSdkDetails = builder.getSdkDetails;
    }

    public JSONObject prepareUseCaseJson() {
        JSONObject useCase = new JSONObject();
        try {
            if (this.getAdditionalCharges) {
                useCase.put("getAdditionalCharges", this.getAdditionalCharges);
            }
            if (this.getTaxSpecification) {
                useCase.put("getTaxSpecification", this.getTaxSpecification);
            }
            if (this.checkDownStatus) {
                useCase.put("checkDownStatus", this.checkDownStatus);
            }
            if (this.getOfferDetails) {
                useCase.put("getOfferDetails", this.getOfferDetails);
            }
            if (this.getExtendedPaymentDetails) {
                useCase.put("getExtendedPaymentDetails", this.getExtendedPaymentDetails);
            }
            if (this.checkCustomerEligibility) {
                useCase.put("checkCustomerEligibility", this.checkCustomerEligibility);
            }
            if (this.getMerchantDetails) {
                useCase.put("getMerchantDetails", this.getMerchantDetails);
            }
            if (this.getPaymentDetailsWithExtraFields) {
                useCase.put("getPaymentDetailsWithExtraFields", this.getPaymentDetailsWithExtraFields);
            }
            if (this.getSdkDetails) {
                useCase.put("getSdkDetails", true);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return useCase;
    }

    public static class Builder {
        private boolean getAdditionalCharges;
        private boolean getTaxSpecification;
        private boolean checkDownStatus;
        private boolean getOfferDetails;
        private boolean getExtendedPaymentDetails;
        private boolean checkCustomerEligibility;
        private boolean getMerchantDetails;
        private boolean getPaymentDetailsWithExtraFields;
        private boolean getSdkDetails;

        public Builder shouldGetAdditionalCharges(boolean getAdditionalCharges) {
            this.getAdditionalCharges = getAdditionalCharges;
            return this;
        }

        public Builder shouldGetExtendedPaymentDetails(boolean getExtendedPaymentDetails) {
            this.getExtendedPaymentDetails = getExtendedPaymentDetails;
            return this;
        }

        public Builder shouldGetOfferDetails(boolean getOfferDetails) {
            this.getOfferDetails = getOfferDetails;
            return this;
        }

        public Builder shouldCheckDownStatus(boolean checkDownStatus) {
            this.checkDownStatus = checkDownStatus;
            return this;
        }

        public Builder shouldGetTaxSpecification(boolean getTaxSpecification) {
            this.getTaxSpecification = getTaxSpecification;
            return this;
        }

        public Builder setCheckCustomerEligibility(Boolean checkCustomerEligibility) {
            this.checkCustomerEligibility = checkCustomerEligibility;
            return this;
        }

        public Builder shouldGetMerchantDetails(boolean getMerchantDetails) {
            this.getMerchantDetails = getMerchantDetails;
            return this;
        }

        public Builder shouldGetPaymentDetailsWithExtraFields(boolean getPaymentDetailsWithExtraFields) {
            this.getPaymentDetailsWithExtraFields = getPaymentDetailsWithExtraFields;
            return this;
        }

        public Builder shouldGetSdkDetails(boolean getSdkDetails) {
            this.getSdkDetails = getSdkDetails;
            return this;
        }

        public Usecase build() {
            return new Usecase(this);
        }
    }
}

