/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import com.payu.india.Interfaces.FetchAdsInformationApiListener;
import com.payu.india.Interfaces.FetchOfferDetailsListener;
import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Interfaces.HashGenerationListener;
import com.payu.india.Interfaces.V2APITaskListener;
import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.FetchOfferApiRequest;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.QuickPay.QuickPayRequest;
import com.payu.india.Model.ValidateOfferRequest;
import com.payu.india.Model.adsinformation.AdsApiRequest;
import com.payu.india.Model.adsinformation.AdsImpressionApiRequest;
import com.payu.india.Model.adsinformation.AdsPayUIdApiRequest;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.FetchAdsInformationTask;
import com.payu.india.Tasks.FetchOfferDetailsTask;
import com.payu.india.Tasks.QuickPayTask;
import com.payu.india.Tasks.SaveEventImpressionTask;
import com.payu.india.Tasks.UpdatePayUIdTask;
import com.payu.india.Tasks.ValidateOfferTask;
import java.util.HashMap;

public class V2ApiTask
implements V2APITaskListener {
    private String key;
    private PayuConfig payuConfig;

    public V2ApiTask(String key, PayuConfig payuConfig) {
        this.key = key;
        this.payuConfig = payuConfig;
    }

    @Override
    public void getOffers(FetchOfferApiRequest fetchOfferApiRequest, HashGenerationListener hashGenerationListener, FetchOfferDetailsListener fetchOfferDetailsListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(fetchOfferApiRequest.getJson()));
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader((String)map1.get("get_all_offer_details"), this.key);
            this.payuConfig.setData(fetchOfferApiRequest.getJson());
            FetchOfferDetailsTask fetchOfferDetailsTask = new FetchOfferDetailsTask(fetchOfferDetailsListener);
            fetchOfferDetailsTask.execute(new PayuConfig[]{this.payuConfig});
        });
    }

    @Override
    public void getQuickPayOptions(QuickPayRequest quickPayRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(quickPayRequest.getJson()));
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader((String)map1.get("quickPayEvent"), this.key);
            this.payuConfig.setData(quickPayRequest.getJson());
            QuickPayTask quickPayTask = new QuickPayTask(globalVaultListener);
            quickPayTask.execute(new PayuConfig[]{this.payuConfig});
        });
    }

    @Override
    public void validateOffers(ValidateOfferRequest validateOfferRequest, HashGenerationListener hashGenerationListener, ValidateOfferApiListener validateOfferApiListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(validateOfferRequest.getJson()));
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader((String)map1.get("validate_offer_details"), this.key);
            this.payuConfig.setData(validateOfferRequest.getJson());
            ValidateOfferTask validateOfferTask = new ValidateOfferTask(validateOfferApiListener);
            validateOfferTask.execute(new PayuConfig[]{this.payuConfig});
        });
    }

    @Override
    public void getAdsDetails(AdsApiRequest adsApiRequest, FetchAdsInformationApiListener fetchAdsInformationApiListener) {
        this.payuConfig.setData(adsApiRequest.getJson());
        FetchAdsInformationTask fetchAdsInformationTask = new FetchAdsInformationTask(fetchAdsInformationApiListener);
        fetchAdsInformationTask.execute(new PayuConfig[]{this.payuConfig});
    }

    @Override
    public void postAdsImpressionEvent(AdsImpressionApiRequest adsImpressionApiRequest) {
        this.payuConfig.setData(adsImpressionApiRequest.getJson());
        SaveEventImpressionTask saveEventImpressionTask = new SaveEventImpressionTask();
        saveEventImpressionTask.execute(new PayuConfig[]{this.payuConfig});
    }

    @Override
    public void updateAdsPayUId(AdsPayUIdApiRequest adsPayUIdApiRequest) {
        this.payuConfig.setData(adsPayUIdApiRequest.getJson());
        UpdatePayUIdTask updatePayUIdTask = new UpdatePayUIdTask();
        updatePayUIdTask.execute(new PayuConfig[]{this.payuConfig});
    }
}

