/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.PaymentRelatedDetailsListener;
import com.payu.india.Model.Emi;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Model.Upi;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetPaymentRelatedDetailsTask
extends AsyncTask<PayuConfig, Void, HashMap<String, String>> {
    PayuConfig payuConfig;
    PaymentRelatedDetailsListener mPaymentRelatedDetailsListener;

    public GetPaymentRelatedDetailsTask(PaymentRelatedDetailsListener paymentRelatedDetailsListener) {
        this.mPaymentRelatedDetailsListener = paymentRelatedDetailsListener;
    }

    protected HashMap<String, String> doInBackground(PayuConfig ... params) {
        this.payuConfig = params[0];
        String mUserCredentials = "";
        String patternText = "var1=([^&]*)";
        String searchString = this.payuConfig.getData();
        Pattern pattern = Pattern.compile(patternText);
        Matcher matcher = pattern.matcher(searchString);
        while (matcher.find()) {
            mUserCredentials = matcher.group(1);
        }
        return null;
    }

    protected void onPostExecute(HashMap<String, String> oneClickCardTokens) {
        super.onPostExecute(oneClickCardTokens);
        FetchPaymentDetailsTask mTask = new FetchPaymentDetailsTask();
        mTask.execute(new PayuConfig[]{this.payuConfig});
    }

    class FetchPaymentDetailsTask
    extends AsyncTask<PayuConfig, String, PayuResponse> {
        FetchPaymentDetailsTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected PayuResponse doInBackground(PayuConfig ... params) {
            PayuResponse payuResponse = new PayuResponse();
            PostData postData = new PostData();
            try {
                URL url = null;
                PayuConfig payuConfig = params[0];
                switch (payuConfig.getEnvironment()) {
                    case 0: {
                        url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                        break;
                    }
                    case 1: {
                        url = new URL("https://test.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 2: {
                        url = new URL("https://test.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 3: {
                        url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 4: {
                        url = new URL("https://bizcheckouttest.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    default: {
                        url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    }
                }
                byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
                HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
                if (null != conn) {
                    int i;
                    InputStream responseInputStream = conn.getInputStream();
                    StringBuffer responseStringBuffer = new StringBuffer();
                    byte[] byteContainer = new byte[1024];
                    while ((i = responseInputStream.read(byteContainer)) != -1) {
                        responseStringBuffer.append(new String(byteContainer, 0, i));
                    }
                    JSONObject response = new JSONObject(responseStringBuffer.toString());
                    payuResponse.setRawResponse(response);
                    if (response.has("ibiboCodes")) {
                        ArrayList<Emi> emiList;
                        Iterator keysIterator;
                        PaymentDetails paymentDetails;
                        String bankCode;
                        Iterator keysIterator2;
                        JSONObject ibiboCodes = response.getJSONObject("ibiboCodes");
                        if (ibiboCodes.has("creditcard")) {
                            JSONObject creditCardCollections = ibiboCodes.getJSONObject("creditcard");
                            ArrayList<PaymentDetails> ccList = new ArrayList<PaymentDetails>();
                            keysIterator2 = creditCardCollections.keys();
                            while (keysIterator2.hasNext()) {
                                bankCode = (String)keysIterator2.next();
                                JSONObject ccObject = creditCardCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(ccObject.getString("bank_id"));
                                paymentDetails.setBankName(ccObject.getString("title"));
                                paymentDetails.setPgId(ccObject.getString("pgId"));
                                ccList.add(paymentDetails);
                            }
                            payuResponse.setCreditCard(ccList);
                        }
                        if (ibiboCodes.has("debitcard")) {
                            JSONObject debitCardCollections = ibiboCodes.getJSONObject("debitcard");
                            ArrayList<PaymentDetails> dbList = new ArrayList<PaymentDetails>();
                            keysIterator2 = debitCardCollections.keys();
                            while (keysIterator2.hasNext()) {
                                bankCode = (String)keysIterator2.next();
                                PaymentDetails paymentDetails2 = new PaymentDetails();
                                JSONObject dcObject = debitCardCollections.getJSONObject(bankCode);
                                paymentDetails2.setBankCode(bankCode);
                                paymentDetails2.setBankId(dcObject.getString("bank_id"));
                                paymentDetails2.setBankName(dcObject.getString("title"));
                                paymentDetails2.setPgId(dcObject.getString("pgId"));
                                dbList.add(paymentDetails2);
                            }
                            payuResponse.setDebitCard(dbList);
                        }
                        if (ibiboCodes.has("netbanking")) {
                            JSONObject netBanksCollections = ibiboCodes.getJSONObject("netbanking");
                            keysIterator = netBanksCollections.keys();
                            ArrayList<PaymentDetails> nbList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject netBank = netBanksCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(netBank.getString("bank_id"));
                                paymentDetails.setBankName(netBank.getString("title"));
                                paymentDetails.setPgId(netBank.getString("pgId"));
                                nbList.add(paymentDetails);
                            }
                            Collections.sort(nbList, new PaymentDetailsComparator());
                            payuResponse.setNetBanks(nbList);
                        }
                        if (ibiboCodes.has("cashcard")) {
                            JSONObject cashCardCollections = ibiboCodes.getJSONObject("cashcard");
                            keysIterator = cashCardCollections.keys();
                            ArrayList<PaymentDetails> cashCardList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject cashCardJson = cashCardCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(cashCardJson.getString("bank_id"));
                                paymentDetails.setBankName(cashCardJson.getString("title"));
                                paymentDetails.setPgId(cashCardJson.getString("pgId"));
                                cashCardList.add(paymentDetails);
                                if (bankCode.equalsIgnoreCase("PPINTENT")) {
                                    payuResponse.setPhonePe(paymentDetails);
                                }
                                if (!bankCode.equalsIgnoreCase("TWID")) continue;
                                payuResponse.setTwid(paymentDetails);
                            }
                            Collections.sort(cashCardList, new PaymentDetailsComparator());
                            payuResponse.setCashCard(cashCardList);
                        }
                        if (ibiboCodes.has("ivr")) {
                            JSONObject ivrCCCollections = ibiboCodes.getJSONObject("ivr");
                            keysIterator = ivrCCCollections.keys();
                            ArrayList<PaymentDetails> ivrCCList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject ivrccObject = ivrCCCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(ivrccObject.getString("bank_id"));
                                paymentDetails.setBankName(ivrccObject.getString("title"));
                                paymentDetails.setPgId(ivrccObject.getString("pgId"));
                                ivrCCList.add(paymentDetails);
                            }
                            payuResponse.setIvr(ivrCCList);
                        }
                        if (ibiboCodes.has("ivrdc")) {
                            JSONObject ivrDCCollections = ibiboCodes.getJSONObject("ivrdc");
                            keysIterator = ivrDCCollections.keys();
                            ArrayList<PaymentDetails> ivrDCList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject ivrdcObject = ivrDCCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(ivrdcObject.getString("bank_id"));
                                paymentDetails.setBankName(ivrdcObject.getString("title"));
                                paymentDetails.setPgId(ivrdcObject.getString("pgId"));
                                ivrDCList.add(paymentDetails);
                            }
                            payuResponse.setIvrdc(ivrDCList);
                        }
                        if (ibiboCodes.has("paisawallet")) {
                            JSONObject paisaWalletCollections = ibiboCodes.getJSONObject("paisawallet");
                            keysIterator = paisaWalletCollections.keys();
                            ArrayList<PaymentDetails> paisaWalletList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject paisaWallet = paisaWalletCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(paisaWallet.getString("bank_id"));
                                paymentDetails.setBankName(paisaWallet.getString("title"));
                                paymentDetails.setPgId(paisaWallet.getString("pgId"));
                                paisaWalletList.add(paymentDetails);
                            }
                            payuResponse.setPaisaWallet(paisaWalletList);
                        }
                        if (ibiboCodes.has("lazypay")) {
                            JSONObject lazypayCollections = ibiboCodes.getJSONObject("lazypay");
                            keysIterator = lazypayCollections.keys();
                            ArrayList<PaymentDetails> lazypayList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject lazypay = lazypayCollections.getJSONObject(bankCode);
                                paymentDetails = new PaymentDetails();
                                paymentDetails.setBankCode(bankCode);
                                paymentDetails.setBankId(lazypay.getString("bank_id"));
                                paymentDetails.setBankName(lazypay.getString("title"));
                                paymentDetails.setPgId(lazypay.getString("pgId"));
                                lazypayList.add(paymentDetails);
                            }
                            payuResponse.setLazyPay(lazypayList);
                        }
                        if (ibiboCodes.has("emi")) {
                            emiList = this.getEmiList(ibiboCodes, "emi");
                            payuResponse.setEmi(emiList);
                        }
                        if (ibiboCodes.has("no_cost_emi")) {
                            emiList = this.getEmiList(ibiboCodes, "no_cost_emi");
                            payuResponse.setNoCostEMI(emiList);
                        }
                        if (ibiboCodes.has("upi")) {
                            Upi upi;
                            JSONObject upiCollections;
                            JSONObject upiObject = ibiboCodes.getJSONObject("upi");
                            if (upiObject.has("upi".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("upi".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.getString("title"));
                                upi.setBankID(upiCollections.getString("bank_id"));
                                upi.setPgID(upiCollections.getString("pgId"));
                                upi.setShowForm(upiCollections.getString("show_form"));
                                payuResponse.setUpi(upi);
                            }
                            if (upiObject.has("TEZ".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("TEZ".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.getString("title"));
                                upi.setBankID(upiCollections.getString("bank_id"));
                                upi.setPgID(upiCollections.getString("pgId"));
                                upi.setShowForm(upiCollections.getString("show_form"));
                                payuResponse.setGoogleTez(upi);
                            }
                            if (upiObject.has("INTENT".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("INTENT".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.getString("title"));
                                upi.setBankID(upiCollections.getString("bank_id"));
                                upi.setPgID(upiCollections.getString("pgId"));
                                upi.setShowForm(upiCollections.getString("show_form"));
                                payuResponse.setGenericIntent(upi);
                            }
                        }
                        if (ibiboCodes.has("standinginstruction")) {
                            JSONObject siObjectCollections = ibiboCodes.getJSONObject("standinginstruction");
                            keysIterator = siObjectCollections.keys();
                            ArrayList<PaymentDetails> siList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject siObject = siObjectCollections.getJSONObject(bankCode);
                                PaymentDetails siDetails = new PaymentDetails();
                                siDetails.setBankCode(bankCode);
                                siDetails.setBankId(siObject.getString("bank_id"));
                                siDetails.setBankName(siObject.getString("title"));
                                siDetails.setPgId(siObject.getString("pgId"));
                                siList.add(siDetails);
                            }
                            payuResponse.setStandingInstructions(siList);
                        }
                        if (ibiboCodes.has("enach")) {
                            JSONObject enachObjectCollections = ibiboCodes.getJSONObject("enach");
                            keysIterator = enachObjectCollections.keys();
                            ArrayList<PaymentDetails> siBankList = new ArrayList<PaymentDetails>();
                            while (keysIterator.hasNext()) {
                                bankCode = (String)keysIterator.next();
                                JSONObject enachObject = enachObjectCollections.getJSONObject(bankCode);
                                PaymentDetails siBankDetails = new PaymentDetails();
                                siBankDetails.setBankCode(bankCode);
                                siBankDetails.setBankId(enachObject.getString("bank_id"));
                                siBankDetails.setBankName(enachObject.getString("title"));
                                siBankDetails.setPgId(enachObject.getString("pgId"));
                                siBankList.add(siBankDetails);
                            }
                            payuResponse.setSiBankList(siBankList);
                        }
                    }
                    if (response.has("userCards") && response.getJSONObject("userCards").has("user_cards")) {
                        JSONObject cardsList = response.getJSONObject("userCards").getJSONObject("user_cards");
                        Iterator keysIterator = cardsList.keys();
                        ArrayList<StoredCard> userCardArrayList = new ArrayList<StoredCard>();
                        while (keysIterator.hasNext()) {
                            String cardToken = (String)keysIterator.next();
                            StoredCard userCard = new StoredCard();
                            JSONObject card = cardsList.getJSONObject(cardToken);
                            userCard.setNameOnCard(card.getString("card_name"));
                            userCard.setCardName(card.getString("card_name"));
                            userCard.setCardMode(card.getString("card_mode"));
                            userCard.setMaskedCardNumber(card.getString("card_no"));
                            userCard.setCardBrand(card.getString("card_brand"));
                            userCard.setCardBin(card.getString("card_bin"));
                            userCard.setIsDomestic(card.getString("isDomestic"));
                            userCard.setIssuingBank(card.getString("issuingBank"));
                            userCard.setCardType(card.getString("card_type"));
                            userCard.setCardToken(card.getString("card_token"));
                            userCard.setExpiryYear(card.optString("expiry_year"));
                            userCard.setExpiryMonth(card.optString("expiry_month"));
                            userCard.setIsExpired(card.optInt("is_expired") != 0);
                            userCardArrayList.add(userCard);
                            userCard = null;
                        }
                        payuResponse.setStoredCards(userCardArrayList);
                    }
                    if (response.has("status") && response.getString("status").contentEquals("0")) {
                        postData = new PostData();
                        postData.setCode(5019);
                        postData.setStatus("ERROR");
                        postData.setResult(response.getString("msg"));
                    } else {
                        postData.setCode(0);
                        postData.setResult("Data fetched successfully, Stored card status: ");
                        if (response.has("userCards") && response.getJSONObject("userCards").has("msg")) {
                            postData.setResult(postData.getResult() + " " + response.getJSONObject("userCards").get("msg").toString());
                        }
                        postData.setStatus("SUCCESS");
                    }
                }
            }
            catch (ProtocolException e) {
                postData.setCode(5016);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                postData.setCode(5004);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            catch (JSONException e) {
                postData.setCode(5014);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            catch (IOException e) {
                postData.setCode(5016);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            payuResponse.setResponseStatus(postData);
            return payuResponse;
        }

        private ArrayList<Emi> getEmiList(JSONObject ibiboCodes, String key) throws JSONException {
            JSONObject emiObjectCollections = ibiboCodes.getJSONObject(key);
            Iterator keysIterator = emiObjectCollections.keys();
            ArrayList<Emi> emiList = new ArrayList<Emi>();
            while (keysIterator.hasNext()) {
                String bankCode = (String)keysIterator.next();
                JSONObject emiObject = emiObjectCollections.getJSONObject(bankCode);
                Emi emi = new Emi();
                emi.setBankCode(bankCode);
                emi.setBankName(emiObject.getString("bank"));
                emi.setBankTitle(emiObject.getString("title"));
                emi.setPgId(emiObject.getString("pgId"));
                emi.setMinAmount(emiObject.optString("min_amount"));
                emiList.add(emi);
            }
            Collections.sort(emiList, new EmiComparator());
            return emiList;
        }

        protected void onPostExecute(PayuResponse payuResponse) {
            super.onPostExecute((Object)payuResponse);
            GetPaymentRelatedDetailsTask.this.mPaymentRelatedDetailsListener.onPaymentRelatedDetailsResponse(payuResponse);
        }

        class PaymentDetailsComparator
        implements Comparator<PaymentDetails> {
            PaymentDetailsComparator() {
            }

            @Override
            public int compare(PaymentDetails p1, PaymentDetails p2) {
                return p1.getBankName().compareTo(p2.getBankName());
            }
        }

        class EmiComparator
        implements Comparator<Emi> {
            EmiComparator() {
            }

            @Override
            public int compare(Emi p1, Emi p2) {
                return p1.getBankName().compareTo(p2.getBankName());
            }
        }
    }
}

