/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.EligibleBinsForEMIApiListener;
import com.payu.india.Model.EligibleEmiBins;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EligibleBinsForEMITask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    EligibleBinsForEMIApiListener apiListener;

    public EligibleBinsForEMITask(EligibleBinsForEMIApiListener apiListener) {
        this.apiListener = apiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has("msg")) {
                    postData.setResult(jsonResponse.getString("msg"));
                }
                if (jsonResponse.has("status") && jsonResponse.getInt("status") == 0) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                if (jsonResponse.has("details") && jsonResponse.get("details") != null) {
                    JSONObject detailsObject = jsonResponse.getJSONObject("details");
                    Iterator keys = detailsObject.keys();
                    ArrayList<EligibleEmiBins> eligibleEmiBinsList = new ArrayList<EligibleEmiBins>();
                    while (keys.hasNext()) {
                        EligibleEmiBins eligibleEmiBins = new EligibleEmiBins();
                        String bankShortName = (String)keys.next();
                        if (detailsObject.optJSONObject(bankShortName) == null) {
                            eligibleEmiBins.setIsEligible(detailsObject.optInt("isEligible"));
                            eligibleEmiBins.setBankShortName(detailsObject.optString("bank"));
                            eligibleEmiBins.setMinAmount(detailsObject.optInt("minAmount"));
                            if (detailsObject.has("msg")) {
                                eligibleEmiBins.setIsEligible(0);
                            }
                            eligibleEmiBinsList.add(eligibleEmiBins);
                            break;
                        }
                        JSONObject bankObject = detailsObject.optJSONObject(bankShortName);
                        eligibleEmiBins.setBankShortName(bankShortName);
                        eligibleEmiBins.setMinAmount(bankObject.optInt("minAmount"));
                        eligibleEmiBins.setIsEligible(1);
                        ArrayList<String> cardBinsList = new ArrayList<String>();
                        if (bankObject.has("cardBins") && bankObject.optJSONArray("cardBins") != null && bankObject.optJSONArray("cardBins").length() > 0) {
                            JSONArray cardBinsArray = bankObject.getJSONArray("cardBins");
                            for (int i2 = 0; i2 < cardBinsArray.length(); ++i2) {
                                cardBinsList.add(cardBinsArray.getString(i2));
                            }
                        }
                        eligibleEmiBins.setCardBins(cardBinsList);
                        eligibleEmiBinsList.add(eligibleEmiBins);
                    }
                    payuResponse.setEligibleEmiBins(eligibleEmiBinsList);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.apiListener.onEligibleBinsForEMIApiResponse(payuResponse);
    }
}

