/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.ValidateOfferDetails;
import com.payu.india.Model.ValidateOfferDiscount;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidateOfferTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private ValidateOfferApiListener mvalidateOfferApiListener;

    public ValidateOfferTask(ValidateOfferApiListener validateOfferApiListener) {
        this.mvalidateOfferApiListener = validateOfferApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://pp92api.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "offers/transactions/validate").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader()).setRequestType("application/json; charset=utf8").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                JSONObject result = response.optJSONObject("result");
                if (result != null) {
                    ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                    validateOfferDetails.setAmount(Double.parseDouble(!result.get("amount").equals(null) ? result.get("amount").toString() : "0"));
                    validateOfferDetails.setPaymentCode(result.optString("paymentCode"));
                    validateOfferDetails.setCategory(result.optString("category"));
                    validateOfferDetails.setIsValid(result.optBoolean("isValid"));
                    validateOfferDetails.setMid(result.optString("mid"));
                    ValidateOfferDiscount offerdiscount = new ValidateOfferDiscount();
                    JSONObject offerDiscountJson = result.optJSONObject("offerDiscount");
                    if (offerDiscountJson != null) {
                        offerdiscount.setDiscount(Double.parseDouble(!offerDiscountJson.get("discount").equals(null) ? offerDiscountJson.get("discount").toString() : "0"));
                        offerdiscount.setDiscountedAmount(Double.parseDouble(!offerDiscountJson.get("discountedAmount").equals(null) ? offerDiscountJson.get("discountedAmount").toString() : "0"));
                        offerdiscount.setDiscountType(offerDiscountJson.optString("discountType"));
                        offerdiscount.setOfferKey(offerDiscountJson.optString("offer_key"));
                        offerdiscount.setOfferType(offerDiscountJson.optString("offer_type"));
                    }
                    validateOfferDetails.setValidateOfferdiscount(offerdiscount);
                    ValidateOfferInfo validateOfferInfo = new ValidateOfferInfo();
                    if (result.optJSONObject("offerDetail") != null) {
                        JSONObject offerDetailJson = result.optJSONObject("offerDetail");
                        validateOfferInfo.setOfferKey(offerDetailJson.optString("offer_key"));
                        validateOfferInfo.setOfferType(offerDetailJson.optString("offer_type"));
                        validateOfferInfo.setTitle(offerDetailJson.optString("title"));
                        validateOfferInfo.setDescription(offerDetailJson.optString("description"));
                        validateOfferInfo.setValidFrom(offerDetailJson.optString("validFrom"));
                        validateOfferInfo.setValidTo(offerDetailJson.optString("validTo"));
                        validateOfferInfo.setTnc(offerDetailJson.optString("tnc"));
                        validateOfferInfo.setTncLink(offerDetailJson.optString("tncLink"));
                        validateOfferInfo.setDiscountType(offerDetailJson.optString("discountType"));
                        validateOfferInfo.setOfferPercentage(offerDetailJson.optString("offerPercentage"));
                        validateOfferInfo.setMaxDiscountPerTxn(offerDetailJson.optDouble("maxDiscountPerTxn"));
                        validateOfferInfo.setMaxTxnAmount(Double.parseDouble(!offerDetailJson.get("maxTxnAmount").equals(null) ? offerDetailJson.get("maxTxnAmount").toString() : "0"));
                        validateOfferInfo.setMinTxnAmount(Double.parseDouble(!offerDetailJson.get("minTxnAmount").equals(null) ? offerDetailJson.get("minTxnAmount").toString() : "0"));
                        validateOfferInfo.setStatus(offerDetailJson.optString("status"));
                        validateOfferInfo.setIsNce(offerDetailJson.optBoolean("isNce"));
                        validateOfferInfo.setDisallowTransactionInvalidOffer(offerDetailJson.optBoolean("disallowTransactionInvalidOffer"));
                        validateOfferDetails.setValidateOfferInfo(validateOfferInfo);
                    }
                    validateOfferDetails.setFailureReason(result.optString("failureReason"));
                    payuResponse.setValidateOfferDetails(validateOfferDetails);
                }
            }
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mvalidateOfferApiListener.onValiDateOfferResponse(payuResponse);
    }
}

