/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import android.annotation.SuppressLint;
import android.util.Log;
import com.payu.india.Model.Authorization;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class V2ApiHelper {
    private String date;
    private String digest;
    private String authHeder;
    private Authorization authorization = new Authorization();
    private static V2ApiHelper instance = null;

    private V2ApiHelper() {
    }

    public static V2ApiHelper getInstance() {
        if (instance == null) {
            instance = new V2ApiHelper();
        }
        return instance;
    }

    @SuppressLint(value={"NewApi"})
    public String generateSigningString(String jsonString) {
        Date myDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(myDate);
        calendar.add(12, -330);
        Date time = calendar.getTime();
        SimpleDateFormat outputFmt = new SimpleDateFormat("\"EEE, dd MMM yyyy HH:mm:ss 'GMT'\"");
        this.date = outputFmt.format(time);
        this.authorization.setDate(this.date);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] digest2 = md.digest(jsonString.getBytes());
        Log.v((String)"requestBody", (String)("GsonToJson1 " + Base64.getEncoder().encodeToString(digest2)));
        this.digest = Base64.getEncoder().encodeToString(digest2);
        this.authorization.setDigest(this.digest);
        String signingString = "date: " + this.date + ("\ndigest: " + this.digest);
        return signingString;
    }

    public HashMap<String, String> getAuthHeader() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("date", this.authorization.getDate());
        headerMap.put("digest", this.authorization.getDigest());
        this.authHeder = "hmac username=\"" + this.authorization.getMerchantkey() + "\", algorithm=\"hmac-sha256\", headers=\"date digest\", signature=\"" + this.authorization.getSignature() + "\"";
        headerMap.put("authorization", this.authHeder);
        return headerMap;
    }

    public void setAuthHeader(String signature, String key) {
        this.authorization.setMerchantkey(key);
        this.authorization.setDate(this.date);
        this.authorization.setDigest(this.digest);
        this.authorization.setSignature(signature);
    }
}

