/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.SaveCardApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class SaveCardTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private SaveCardApiListener mSaveCardApiListener;

    public SaveCardTask(SaveCardApiListener saveCardApiListener) {
        this.mSaveCardApiListener = saveCardApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        StoredCard storedCard = new StoredCard();
        ArrayList<StoredCard> userCardArrayList = new ArrayList<StoredCard>();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("status") && response.getString("status").contentEquals("0")) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                }
                if (response.has("status") && response.getString("status").contentEquals("1")) {
                    postData.setStatus("SUCCESS");
                    postData.setCode(0);
                    storedCard.setCardToken(response.getString("cardToken"));
                    storedCard.setMaskedCardNumber(response.getString("card_number"));
                    storedCard.setCardName(response.getString("card_label"));
                    if (response.has("duplicate_cards_count")) {
                        try {
                            int count = Integer.parseInt(response.get("duplicate_cards_count").toString());
                            storedCard.setDuplicateCardCount(count);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    } else {
                        storedCard.setDuplicateCardCount(-1);
                    }
                    userCardArrayList.add(0, storedCard);
                }
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        payuResponse.setStoredCards(userCardArrayList);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mSaveCardApiListener.onSaveCardResponse(payuResponse);
    }
}

