/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import org.json.JSONException;
import org.json.JSONObject;

public class Usecase {
    private final boolean getAdditionalCharges;
    private final boolean getTaxSpecification;
    private final boolean checkDownStatus;
    private final boolean getOfferDetails;
    private final boolean getExtendedPaymentDetails;
    private final Boolean checkCustomerEligibility;

    private Usecase(Builder builder) {
        this.getAdditionalCharges = builder.getAdditionalCharges;
        this.getTaxSpecification = builder.getTaxSpecification;
        this.checkDownStatus = builder.checkDownStatus;
        this.getOfferDetails = builder.getOfferDetails;
        this.getExtendedPaymentDetails = builder.getExtendedPaymentDetails;
        this.checkCustomerEligibility = builder.checkCustomerEligibility;
    }

    public JSONObject prepareUseCaseJson() {
        JSONObject useCase = new JSONObject();
        try {
            if (this.getAdditionalCharges) {
                useCase.put("getAdditionalCharges", this.getAdditionalCharges);
            }
            if (this.getTaxSpecification) {
                useCase.put("getTaxSpecification", this.getTaxSpecification);
            }
            if (this.checkDownStatus) {
                useCase.put("checkDownStatus", this.checkDownStatus);
            }
            if (this.getOfferDetails) {
                useCase.put("getOfferDetails", this.getOfferDetails);
            }
            if (this.getExtendedPaymentDetails) {
                useCase.put("getExtendedPaymentDetails", this.getExtendedPaymentDetails);
            }
            if (this.checkCustomerEligibility.booleanValue()) {
                useCase.put("checkCustomerEligibility", (Object)this.checkCustomerEligibility);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return useCase;
    }

    public static class Builder {
        private boolean getAdditionalCharges = false;
        private boolean getTaxSpecification = false;
        private boolean checkDownStatus = false;
        private boolean getOfferDetails = false;
        private boolean getExtendedPaymentDetails = false;
        private Boolean checkCustomerEligibility = false;

        public Builder shouldGetAdditionalCharges(boolean getAdditionalCharges) {
            this.getAdditionalCharges = getAdditionalCharges;
            return this;
        }

        public Builder shouldGetExtendedPaymentDetails(boolean getExtendedPaymentDetails) {
            this.getExtendedPaymentDetails = getExtendedPaymentDetails;
            return this;
        }

        public Builder shouldGetOfferDetails(boolean getOfferDetails) {
            this.getOfferDetails = getOfferDetails;
            return this;
        }

        public Builder shouldCheckDownStatus(boolean checkDownStatus) {
            this.checkDownStatus = checkDownStatus;
            return this;
        }

        public Builder shouldGetTaxSpecification(boolean getTaxSpecification) {
            this.getTaxSpecification = getTaxSpecification;
            return this;
        }

        public Builder setCheckCustomerEligibility(Boolean checkCustomerEligibility) {
            this.checkCustomerEligibility = checkCustomerEligibility;
            return this;
        }

        public Usecase build() {
            return new Usecase(this);
        }
    }
}

