/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.CheckoutDetailsListener;
import com.payu.india.Model.Emi;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.Upi;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetCheckoutDetailsTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    CheckoutDetailsListener mCheckoutDetailsListener;

    public GetCheckoutDetailsTask(CheckoutDetailsListener checkoutDetailsListener) {
        this.mCheckoutDetailsListener = checkoutDetailsListener;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 4: {
                    url = new URL("https://bizcheckouttest.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                JSONObject paymentOptions;
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                if (response.has("details") && response.optJSONObject("details") != null && (paymentOptions = response.getJSONObject("details").optJSONObject("paymentOptions")) != null && paymentOptions.length() > 0) {
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "cc")) {
                        payuResponse.setCreditCard(this.prepareListWithKeyData(paymentOptions, "cc"));
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "dc")) {
                        payuResponse.setDebitCard(this.prepareListWithKeyData(paymentOptions, "dc"));
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "nb")) {
                        ArrayList<PaymentDetails> nbList = this.prepareListWithKeyData(paymentOptions, "nb");
                        payuResponse.setNetBanks(nbList);
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "enach")) {
                        ArrayList<PaymentDetails> nbSiList = this.prepareListWithKeyData(paymentOptions, "enach");
                        payuResponse.setSiBankList(nbSiList);
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "si")) {
                        ArrayList<PaymentDetails> siList = this.prepareListWithKeyData(paymentOptions, "si");
                        payuResponse.setStandingInstructions(siList);
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "cash")) {
                        ArrayList<PaymentDetails> walletList = this.prepareListWithKeyData(paymentOptions, "cash");
                        PaymentDetails paymentDetails = this.getDetailsForKey(walletList, "PPINTENT");
                        if (paymentDetails != null) {
                            payuResponse.setPhonePe(paymentDetails);
                        }
                        Collections.sort(walletList, new PaymentDetailsComparator());
                        payuResponse.setCashCard(walletList);
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "ivr")) {
                        payuResponse.setIvr(this.prepareListWithKeyData(paymentOptions, "ivr"));
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "ivrdc")) {
                        payuResponse.setIvrdc(this.prepareListWithKeyData(paymentOptions, "ivrdc"));
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "upi")) {
                        Upi upi;
                        JSONObject upiCollections;
                        JSONObject upiObject = paymentOptions.getJSONObject("upi").getJSONObject("all");
                        if (upiObject.has("upi".toUpperCase())) {
                            upiCollections = upiObject.getJSONObject("upi".toUpperCase());
                            upi = new Upi();
                            upi.setTitle(upiCollections.optString("title"));
                            upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                            payuResponse.setUpi(upi);
                        }
                        if (upiObject.has("TEZ".toUpperCase())) {
                            upiCollections = upiObject.getJSONObject("TEZ".toUpperCase());
                            upi = new Upi();
                            upi.setTitle(upiCollections.optString("title"));
                            upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                            payuResponse.setGoogleTez(upi);
                        }
                        if (upiObject.has("INTENT".toUpperCase())) {
                            upiCollections = upiObject.getJSONObject("INTENT".toUpperCase());
                            upi = new Upi();
                            upi.setTitle(upiCollections.optString("title"));
                            upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                            payuResponse.setGenericIntent(upi);
                        }
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "emi")) {
                        ArrayList<Emi> emiList = this.getEmiList(paymentOptions, "emi");
                        payuResponse.setEmi(emiList);
                    }
                    if (this.isJSONObjectAvailableForKey(paymentOptions, "lazypay")) {
                        payuResponse.setLazyPay(this.prepareListWithKeyData(paymentOptions, "lazypay"));
                    }
                }
                if (response.has("status") && response.getString("status").contentEquals("0")) {
                    postData = new PostData();
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                    postData.setResult(response.getString("msg"));
                } else {
                    postData.setCode(0);
                    postData.setResult("Data fetched successfully, Stored card status: ");
                    if (response.has("userCards") && response.getJSONObject("userCards").has("msg")) {
                        postData.setResult(postData.getResult() + " " + response.getJSONObject("userCards").get("msg").toString());
                    }
                    postData.setStatus("SUCCESS");
                }
            }
        }
        catch (ProtocolException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            postData.setCode(5004);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private ArrayList<Emi> getEmiList(JSONObject paymentOptions, String key) throws JSONException {
        JSONObject ccObject = paymentOptions.getJSONObject(key).getJSONObject("all").optJSONObject("cc");
        if (ccObject != null && ccObject.optJSONObject("all") != null) {
            JSONObject allObject = ccObject.getJSONObject("all");
            Iterator keysIterator = allObject.keys();
            ArrayList<Emi> emiList = new ArrayList<Emi>();
            while (keysIterator.hasNext()) {
                String code = (String)keysIterator.next();
                JSONObject emiObject = allObject.getJSONObject(code);
                JSONObject tenureOptions = emiObject.getJSONObject("tenureOptions");
                Iterator tenureKeysIterator = tenureOptions.keys();
                while (tenureKeysIterator.hasNext()) {
                    String bankCode = (String)tenureKeysIterator.next();
                    JSONObject tenureObject = tenureOptions.getJSONObject(bankCode);
                    Emi emi = new Emi();
                    emi.setBankCode(bankCode);
                    emi.setAdditionalCharge(tenureObject.optString("additionalCharge"));
                    emiList.add(emi);
                }
            }
            return emiList;
        }
        return null;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mCheckoutDetailsListener.onCheckoutDetailsResponse(payuResponse);
    }

    private PaymentDetails getDetailsForKey(ArrayList<PaymentDetails> paymentDetailsList, String key) {
        if (paymentDetailsList == null || paymentDetailsList.size() == 0 || key == null || key.isEmpty()) {
            return null;
        }
        for (PaymentDetails paymentDetails : paymentDetailsList) {
            if (!paymentDetails.getBankCode().equalsIgnoreCase(key)) continue;
            return paymentDetails;
        }
        return null;
    }

    private ArrayList<PaymentDetails> prepareListWithKeyData(JSONObject paymentOptions, String key) throws JSONException {
        JSONObject allObject = paymentOptions.getJSONObject(key).getJSONObject("all");
        ArrayList<PaymentDetails> paymentDetailsList = new ArrayList<PaymentDetails>();
        Iterator keysIterator = allObject.keys();
        while (keysIterator.hasNext()) {
            String bankCode = (String)keysIterator.next();
            JSONObject ccObject = allObject.getJSONObject(bankCode);
            PaymentDetails paymentDetails = new PaymentDetails();
            paymentDetails.setBankCode(bankCode);
            paymentDetails.setBankName(ccObject.optString("title"));
            paymentDetails.setAdditionalCharge(ccObject.optString("additionalCharge"));
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONObject(key) != null && paymentOptions.optJSONObject(key).optJSONObject("all") != null;
    }

    class PaymentDetailsComparator
    implements Comparator<PaymentDetails> {
        PaymentDetailsComparator() {
        }

        @Override
        public int compare(PaymentDetails p1, PaymentDetails p2) {
            return p1.getBankName().compareTo(p2.getBankName());
        }
    }

    class EmiComparator
    implements Comparator<Emi> {
        EmiComparator() {
        }

        @Override
        public int compare(Emi p1, Emi p2) {
            return p1.getBankName().compareTo(p2.getBankName());
        }
    }
}

