package com.payu.custombrowser.widgets;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.payu.custombrowser.R;
import com.payu.custombrowser.util.CBUtil;


/**
 * Created by himanshu.gupta on 28/12/17.
 */

public class PayUProgressDialog extends Dialog {

    private TextView tvMessage;
    private View layout;
    private static PayUProgressDialog instance = null;

    /**
     * Displaying Payuloader.
     *
     * @param context base activity context
     * @param view    Custom Progress Dialog Layout if any
     */
    public static PayUProgressDialog getInstance(Context context, View view) {
        if (instance == null) {
            instance = new PayUProgressDialog(context, view);
        }
        return instance;
    }

    private PayUProgressDialog(Context context, View view) {
        super(context, R.style.Theme_AppCompat_Light_NoActionBar);
        LayoutInflater mInflater = LayoutInflater.from(context);
        getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        layout = mInflater.inflate(R.layout.cb_prog_dialog, null, false);
        setContentView(layout);
        tvMessage = (TextView) layout.findViewById(R.id.dialog_title);
        ImageView ivProgress = (ImageView) layout.findViewById(R.id.payu_progress_loader);
        CBUtil.applyLoopingAnimatedVectorDrawable(ivProgress, context);
        setCancelable(true);
        setCanceledOnTouchOutside(false);
    }

    @Override
    public void dismiss() {
        CBUtil.stopLoopingAnimatedVectorDrawable();
        instance = null;
        super.dismiss();
    }


    @Override
    public void show() {
        if (!isShowing()) {
            PayUProgressDialog.super.show();
        }
    }

    public void setText(String text) {
        tvMessage.setText(text);
    }
}
