package com.payu.custombrowser.util;

import android.util.Log;
import android.webkit.WebView;


/**
 * Custom log class which can control logging based on the logging level set
 *
 * @author Shoaib
 */
public class L {

    private static final int VERBOSE = Log.VERBOSE;

    private static final int INFO = Log.INFO;

    private static final int DEBUG = Log.DEBUG;

    private static final int WARN = Log.WARN;

    private static final int ERROR = Log.ERROR;

    private static final String DEFAULT_LOG_TAG = "PAYU";

    public static synchronized void v(String message) {
        if (isLogEnabled(VERBOSE)) {
            Log.v(DEFAULT_LOG_TAG, message);
        }
    }

    public static synchronized void d(String message) {
        if (isLogEnabled(DEBUG)) {
            Log.d(DEFAULT_LOG_TAG, message);
        }

    }

    public static synchronized void e(String message) {
        if (isLogEnabled(ERROR)) {
            Log.e(DEFAULT_LOG_TAG, message + "");
        }
    }

    public static synchronized void w(String message) {
        if (isLogEnabled(WARN)) {
            Log.w(DEFAULT_LOG_TAG, message + "");
        }
    }

    public static synchronized void i(String message) {
        if (isLogEnabled(INFO)) {
            Log.i(DEFAULT_LOG_TAG, message);
        }
    }

    private static boolean isLogEnabled(int level) {
        return Log.isLoggable(DEFAULT_LOG_TAG, level);
    }
}
