package com.payu.custombrowser.util;

import com.payu.custombrowser.Bank;
import java.security.SecureRandom;

public interface CBConstant {
    String PAYU_DOMAIN_TEST = "https://test.payu.in";
    String PAYU_DOMAIN_PROD = "https://secure.payu.in";
    String PAYU_DOMAIN = Bank.DEBUG ? PAYU_DOMAIN_TEST : PAYU_DOMAIN_PROD;
    String PAYU_PAYTXN = "paytxn";

    String TXN_ID = "txnid";
    String AMOUNT = "amount";
    String MERCHANT_KEY = "merchantid";
    String BACK_BUTTON = "backButton";
    String SDK_DETAILS = "sdkname";
    String WEBVIEW = "webView";
    String TRANS_LAYOUT = "tranLayout";
    String VIEWPORTWIDE = "viewPortWide";
    String SHOW_CUSTOMROWSER = "showCustom";
    String AUTO_APPROVE = "auto_approve";
    String AUTO_SELECT_OTP = "auto_select_otp";

    //Rupay card URL
    String rupeeURL = "https://mwsrec.npci.org.in/MWS/Scripts/MerchantScript_v1.0.js";
    String rupeeURL1 = "https://swasrec2.npci.org.in";
    String rupeeURL2 = "https://swasrec.npci.org.in";

    String PAYMENT_URL = "https://secure.payu.in/_payment";
    String TEST_PAYMENT_URL = "https://test.payu.in/_payment";

    // SNOOZE MODES
    int WARN_MODE = 1; // Snooze  + MR
    int FAIL_MODE = 2; // MR

    int ENABLE = 0;
    int DISABLE = -1;


    String VERIFY_ADDON_PARAMS = "verify_add_param";
    // Snooze notification id
    int SNOOZE_NOTIFICATION_ID = (new SecureRandom().nextInt() * 9000) + 1000;

    int TRANSACTION_STATUS_NOTIFICATION_ID = (new SecureRandom().nextInt() * 9000) + 1000;

    // Custom browser state
    // Custom browser minimize (frameState = MINIMISED)
    int MINIMISED = 1;

    // Custom browser maximize (frameState = Maximized)
    int MAXIMISED = 2;

    // Button constant
    int PASSWORD = 1;
    int REGENERATE_OTP = 2;
    int PIN = 3;
    int ENTER_MANUALLY = 4;
    int APPROVE = 5;
    int OTP = 6;
    int SMS_OTP = 7;
    int DEFAULT = 0;
    int SUBMIT_OTP_COLLAPSED = 8;

    // PayU url (payment option url)
    String PAYMENT_OPTION_URL_PROD = "https://secure.payu.in/_payment_options";
    String PAYMENT_OPTION_URL_DEV = "https://test.payu.in/_payment_options";
    String PRODUCTION_FETCH_DATA_URL = "https://info.payu.in/merchant/postservice.php?form=2";
    String MOBILE_TEST_FETCH_DATA_URL = "https://test.payu.in/merchant/postservice?form=2";
    //String PAYM   ENT_OPTION_URL_DEV = "http://10.100.20.223:8000/_payment_options";

    // Payment url


    String TEST_URL = "https://cbstatic.payu.in/js/sdk_js/v3/";
    //    String TEST_URL = "http://69729313.ngrok.io/js/sdk_js/v3/";
    // String TEST_URL = "http://10.100.32.16:8000/js/sdk_js/v3/";
    String PRODUCTION_URL = "https://cbjs.payu.in/js/sdk_js/v3/";
//    String PRODUCTION_URL = "https://671277b9b165.ngrok.io/js/sdk_js/v3/";
//    String PRODUCTION_URL = "http://69729313.ngrok.io/js/sdk_js/v3/";
    // String PRODUCTION_URL = "http://10.100.32.12:8000/sdk_js/v3/";


    // String PRODUCTION_URL = "http://10.100.32.24:9090/js/sdk_js/v3/";

    // Android M sms permission
    String MERCHANT_SMS_PERMISSION = "smsPermission";
    //    String MAGIC_RETRY_PAKAGE = "com.payu.magicretry.MagicRetryFragment";
    String CB_VERSION = "cbVersion";
    int CB_ENABLE_OPTION = 1;
    String NB = "nb";
    String CC = "cc";
    String DC = "dc";
    String CARDS = "Cards";
    String NETBANKING = "Netbanking";
    String VERIFICATION_MSG_RECEIVED = "verificationMsgReceived";
    String POST_TYPE = "post_type";
    String PAYU_RESPONSE = "payu_response";

    // mobile dedicated test env - seamless
    String TEST_PAYMENT_URL_SEAMLESS = "https://test.payu.in/_seamless_payment";
    // String MOBILE_TEST_PAYMENT_URL_SEAMLESS="https://mobiledev.payu.in/_seamless_payment";
    // production - seamless
    String PRODUCTION_PAYMENT_URL_SEAMLESS = "https://secure.payu.in/_seamless_payment";

    // String MOBILE_TEST_PAYMENT_URL = "https://mobiledev.payu.in/_payment";
    // production
    String PRODUCTION_PAYMENT_URL = "https://secure.payu.in/_payment";

    //https://mpi.onlinesbi.com/electraSECURE/vbv/MPIACSResponse.jsp
    String CB_CONFIG = "cb_config";

    // STATIC MESSAGES
    String MSG_NO_INTERNET = "No internet connection";
    String MSG_OTP_Filled = "OTP securely filled by PayU";

    // Snooze Default percent to load url in SNOOZE_DEFAULT_URL_LOAD_TIME_OUT
    int SNOOZE_DEFAULT_URL_LOAD_PERCENTAGE = 1;
    // Snooze Default time to load SNOOZE_DEFAULT_URL_LOAD_PERCENTAGE of the url.
    int SNOOZE_DEFAULT_URL_LOAD_TIME_OUT = 1800000;

    // Snooze String constants
    String DEFAULT_PAYMENT_URLS = "*";
    String URL = "url";
    String PROGRESS_PERCENT = "progress_percent";
    String TIME_OUT = "time_out";

    String SNOOZE_IMAGE_DOWNLOAD_END_POINT = Bank.DEBUG ? "https://test.payu.in/images/speed_test/" : "https://static.payu.in/images/speed_test/";

    String[] SNOOZE_IMAGE_COLLECTIONS = {"coffie_128.jpg", "dogs_128.jpg", "pasta_128.jpg"}; // TODO: Fix typo coffie_128.jpg
    String CURRENT_URL = "currentUrl";
    String S2S_RETRY_URL = "s2sRetryUrl";
    String MERCHANT_CHECKOUT_ACTIVITY = "merchantCheckoutActivity";
    String SENDER = "sender";
    String SNOOZE_SERVICE = "snoozeService";
    String SNOOZE_ENABLED = "snoozeEnabled";
    String SNOOZE_SERVICE_STATUS = "snoozeServiceStatus";
    String SNOOZE_SERVICE_DEAD = "snoozeServiceDead";
    String POST_DATA = "postData";

    String SNOOZE_SHARED_PREF = "com.payu.custombrowser.snoozepref";
    String SNOOZE_IMAGE_DOWNLOAD_TIME_OUT = "sp_image_download_time_out";

    String CB_DELIMITER = "||";

    // CBActivity state
    int STATE_RESUMED = 1;
    int STATE_PAUSED = 2;
    int STATE_DESTROYED = 3;

    // configurable merhant key.
    String KEY = "key";

    String API_STATUS = "api_status";
    String RESPONSE = "response";
    String RESPONSE_BACKWARD = "_response";
    String SURL = "surl";
    String FURL = "furl";


    String MAIN_LAYOUT = "mainLayout";
    String LOADING = "loading";

    // Generic Async task
    String HTTP_URLENCODED = "application/x-www-form-urlencoded";

    String PAYUID = "PAYUID";

    // Analytics events
    String STR_SNOOZE_MODE_WARN = "Warn";
    String STR_SNOOZE_MODE_FAIL = "Fail";

    int VERIFY_HTTP_TIMEOUT = 120000;
    int HTTP_TIMEOUT = 30000;

    // default Sure pay living time 30 minutes
    int DEFAULT_SURE_PAY_TTL = 1800000; //1800000; // 30min * 60sec * 1000ms

    String BROADCAST_FROM_SERVICE_UPDATE_UI = "broadcast_from_service_update_ui";
    String VALUE = "value";

    String GOOD_NETWORK_NOTIFICATION_LAUNCHED = "good_network_notification_launched";

    String BACKWARD_JOURNEY_STATUS = "backward_journey_status";
    String IS_FORWARD_JOURNEY = "is_forward_journey";

    String ERR_CONNECTION_RESET = "net::ERR_CONNECTION_RESET";
    String ERR_NAME_NOT_RESOLVED = "net::ERR_NAME_NOT_RESOLVED";
    String ERR_ADDRESS_UNREACHABLE = "net::ERR_ADDRESS_UNREACHABLE";
    String ERR_INTERNET_DISCONNECTED ="net::ERR_INTERNET_DISCONNECTED";
    String ERR_CONNECTION_REFUSED ="net::ERR_CONNECTION_REFUSED";
    String ERR_CONNECTION_ABORTED ="net::ERR_CONNECTION_ABORTED";
    String ERR_FAILED = "net::ERR_FAILED";

    // Time to live of internet restored window. 5 sec default.
    int INTERNET_RESTORED_WINDOW_TTL = 5000;
    String DISABLE_SP_FOR = "disable_sp_for";

    int MERCHANT_URL_LOADING_TIMEOUT = 5000;
    String WARN = "warn";
    String FAIL = "fail";

    int ENABLE_WARN_AND_FAIL_MODE = 0;
    int DISABLE_WARN_MODE = 1;
    int DISABLE_FAIL_MODE = 2;
    int DISABLE_WARN_AND_FAIL_MODE = 3;

    String TRANSACTION_STATUS_SUCCESS = "1";

    String ORDER_DETAILS = "order_details";


    int CHECK_CB_ENABLE_JS_STATUS = 0;
    int CHECK_SURE_PAY_ENABLE_JS_STATUS = 1;
    int CHECK_REVIEW_ORDER_ENABLE_JS_STATUS = 2;
    int CHECK_CATCH_ALL_JS_ENABLE_JS_STATUS = 3;

    String PLAY_STORE_URL = "https://play.google.com";
    String PLAY_STORE_MARKET_URI = "market://";
    String DEEP_LINK_INTENT_URI = "intent://";

    String DEEP_LINK_GENERIC_INTENT_URI = "upi://";

    String BROWSER_FALLBACK_URL = "browser_fallback_url";

    String WEBVIEW_VERSION = "webview_version";

    //For PaymentOptionWrapper

    String PAYMENT_OPTION_SUCCESS = "onPaymentOptionSuccess";
    String PAYMENT_OPTION_FAILURE = "onPaymentOptionFailure";
    String PAYMENT_OPTION_INIT_SUCCESS = "onPaymentOptionInitialisationSuccess";
    String PAYMENT_OPTION_INIT_FAILURE = "onPaymentOptionInitialisationFailure";
    String IS_PAYMENT_OPTION_AVAILABLE = "isPaymentOptionAvailable";
    String ON_PAYMENT_FAILURE = "onPaymentFailure";
    String ON_PAYMENT_SUCCESS = "onPaymentSuccess";
    String ON_VPA_ENTERED = "onVpaEntered";
    String ON_PAYMENT_TERMINATED = "onPaymentTerminate";
    String ON_UPI_ERROR_RECEIVED = "onUpiErrorReceived";
    String ON_BACK_APPROVE = "onBackApprove";
    String ON_BACK_DISMISS = "onBackDismiss";
    String ON_BACK_BUTTON = "onBackButton";

    //CB SamsungPay Error Codes and Messages
    int CHECK_PAYMENT_NOT_CALLED = 1021;
    String CHECK_PAYMENT_NOT_CALLED_MSG = "Forget to call checkForPaymentAvailability";
    int DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED = 1022;

    String DEVICE_NOT_SUPPORTED_OR = "Device not supported or ";

    String IS_MISSING = " is missing";
    //Error Code
    int OS_NOT_SUPPORTED_CODE = 101;
    int RESPONSE_NOT_PRESENT_CODE = 102;
    int CHROME_NOT_PRESENT_CODE = 103;
    int POST_DATA_OR_HTML_DATA_NOT_PRESENT_CODE = 104;
    int ACTIVITY_NOT_FOUND_CODE = 105;
    String ACTIVITY_NOT_FOUND = "Activity not found";
    String OS_NOT_SUPPORTED = "OS_NOT_SUPPORTED";
    String RESPONSE_NOT_PRESENT = "RESPONSE_NOT_PRESENT";
    String CHROME_NOT_PRESENT = "CHROME_NOT_PRESENT";
    String POST_DATA_OR_HTML_DATA_NOT_PRESENT = "POST_DATA_OR_HTML_DATA_NOT_PRESENT";
    //SurePay S2S constants
    String S2SPAYUID = "cookiePayuId";
    String S2SREPLAYURL = "replayUrl";
    String MERCHANTKEY = "merchantKey";
    String SNOOZE_COUNT = "snoozeCount";
    String SUREPAY_S2S = "surepay_s2s";
    String TXN_TYPE = "txnType";
    String TXNID = "txnId";

    //Notification Channel Id
    String NOTIFICATION_CHANNEL_ID = "payu_surepay_channel";
    String NOTIFICATION_CHANNEL_NAME = "No Internet Notification";
    String NOTIFICATION_CHANNEL_DESCRIPTION = "No Internet Notification";
    String SUCCESS = "success";
    String UNDEFINED = "undefined";
    String BANK_CODE = "bankcode";
    String SURE_PAY_ANALYTICS = "SURE_PAY_ANALYTICS";
    String UPI_SDK_PACKAGE = "com.payu.upisdk.Upi";

    //Analytics
    String PLATFORM_KEY = "platform";
    String PLATFORM_VALUE = "android";
    String SDK_PLATFORM_KEY = "sdk_platform";
    String NAME_KEY = "name";
    String NAME_VALUE = "custombrowser";
    String VERSION_KEY = "version";
    String CB_BOTTOMSHEET = "cb_bottomsheet";
    String CB_OTP_RECEIVED = "cb_otp_received";
    String CB_OTP_USERDENIED = "cb_otp_onUserDenied";

    int MANUAL_OTP = 1;
    int WAITING_OTP = 2;
    int REGISTRATION = 3;
    int AUTO_SUBMIT = 5;
    int CHOOSE_OPTION = 6;
    String UI_LOADING = "ui_loading";
    String UI_CHOOSE_FASTER_ACTION = "ui_choose_faster_action";
    String UI_MANUAL_OTP = "ui_manual_otp";
    String UI_ENTER_OTP = "ui_enter_otp";
    String UI_CANCEL_TRANSACTION = "ui_cancel_transaction";
    String UI_FASTER_PASSWORD = "ui_faster_password";
    String VIEW_PORT_WIDE_ENABLE = "view_port_wide_enable";
    String INTERNET_RESTORED_TTL = "internet_restored_window_ttl";
    String SDK_VERSION_NAME = "sdk_version_name";
    String MERCHANT_CHECKOUT_ACTIVITY_PATH = "merchant_checkout_activity_path";
    String HTML_DATA = "html_data";
    String CBDRAWER_CUSTOM_MENU = "cbdrawer_custom_menu";
    String GMS_PROVIDER_UPDATED_STATUS = "gms_provider_updated_status";
    String REACT_VERSION = "react_version";
    String TRANSACTION_ID = "transaction_id";
    String PAYU_PAYMENT_PARAMS = "payu_payment_params";
    String CB_LISTENER = "CBListener";
    String ON_CBERROR_RECEIVED = "onCBErrorReceived";
    String ERROR_MESSAGE = "errorMessage";
    String ERROR_CODE = "errorCode";
    String MERCHANT_RESPONSE = "merchantResponse";
    String PAYU_RESULT = "payuResult";
    String EVENT_TYPE = "eventType";
    String CB_PAYMENT_INITIATED = "CB Intent Initiated";

    String DISABLE_INTENTSEAMLESS_FAILURE = "disable_intentseamless_failure";
    String DISABLE_BACKBUTTON_DIALOG = "disable_backbutton_dialog";
    String ENABLE_SSL_DIALOG = "enable_ssl_dialog";
    String EMAIL = "email";
    String FIRST_NAME = "first_name";
    String LAST_NAME = "last_name";
    String PACKAGE_NAME_FOR_SPECIFIC_APP = "package_name_for_specific_app";
    String PAYMENT_TYPE = "payment_type";
    String PHONE_PE_USER_CACHE_ENABLED = "phone_pe_user_cache_enabled";
    String MERCHANT_RESPONSE_TIMEOUT = "merchant_response_timeout";
    String HYBRID_POST_DATA = "post_data";
    String HYBRID_MERCHANT_SMS_PERMISSION = "sms_permission";

    String FALLBACK_URL_NOT_FOUND = "Fallback URL not found";

    //clevertap ids
    String CTID1 = "WR7";
    String CTID2 = "R6W";
    String CTID3 = "646Z";
    String CTPASS1 = "IOQ";
    String CTPASS2 = "IIE";
    String CTPASS3 = "OAUL";

    String ASYNC_TASK_ILLEGAL_STATE_EXCEPTION_MESSAGE_1 = "Cannot execute task:"
            + " the task is already running.";

    String ASYNC_TASK_ILLEGAL_STATE_EXCEPTION_MESSAGE_2 = "Cannot execute task:"
            + " the task has already been executed "
            + "(a task can be executed only once)";

    interface errorMessages {
        String MANDATORY_PARAM_PREFIX = "Mandatory param ";
        String INVALID_PARAM_PREFIX = "Invalid param ";
        String INVALID_PARAMS = "Invalid params";
        String IS_MISSING_POSTFIX = " is missing";
        String PAYMENT_INITIATED = "payment_initiated";
    }

    interface errorCodes {
        int MISSING_PARAMETER_EXCEPTION = 5001;
        int SSL_ERROR = 5002;
    }

}
