package com.payu.custombrowser.parser;

import android.text.TextUtils;

import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import java.util.HashMap;

public class ParsingValidator {
    private boolean isValid = true;
    private String errorMessage;
    private final HashMap<String, Object> payUPaymentParams;

    public ParsingValidator(HashMap<String, Object> paymentParams) {
        this.payUPaymentParams = paymentParams;
    }

    public boolean isValid() {
        return isValid;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public ParsingValidator validateConfigParams() {
        if (!payUPaymentParams.containsKey(CBConstant.KEY)
                || TextUtils.isEmpty(CBUtil.valueOf(payUPaymentParams.get(CBConstant.KEY)))) {
            this.isValid = false;
            this.errorMessage = CBConstant.errorMessages.MANDATORY_PARAM_PREFIX
                    + CBConstant.KEY
                    + CBConstant.errorMessages.IS_MISSING_POSTFIX;
            return this;
        }
        if (!payUPaymentParams.containsKey(CBConstant.TRANSACTION_ID)
                || TextUtils.isEmpty(CBUtil.valueOf(payUPaymentParams.get(CBConstant.TRANSACTION_ID)))) {
            this.isValid = false;
            this.errorMessage = CBConstant.errorMessages.MANDATORY_PARAM_PREFIX
                    + CBConstant.TRANSACTION_ID
                    + CBConstant.errorMessages.IS_MISSING_POSTFIX;
            return this;
        }
        if (payUPaymentParams.containsKey(CBConstant.CB_CONFIG)
                && payUPaymentParams.get(CBConstant.CB_CONFIG) != null
                && payUPaymentParams.get(CBConstant.CB_CONFIG) instanceof HashMap) {
            try {
                HashMap<String, Object> cbConfigMap = (HashMap<String, Object>) payUPaymentParams.get(CBConstant.CB_CONFIG);
                if (cbConfigMap != null) {

                    if (!cbConfigMap.containsKey(CBConstant.HYBRID_POST_DATA)) {
                        this.isValid = false;
                        this.errorMessage = CBConstant.errorMessages.MANDATORY_PARAM_PREFIX
                                + CBConstant.HYBRID_POST_DATA
                                + CBConstant.errorMessages.IS_MISSING_POSTFIX;
                        return this;
                    }
                    if (!cbConfigMap.containsKey(CBConstant.URL)) {
                        this.isValid = false;
                        this.errorMessage = CBConstant.errorMessages.MANDATORY_PARAM_PREFIX
                                + CBConstant.URL
                                + CBConstant.errorMessages.IS_MISSING_POSTFIX;
                        return this;
                    }
                }
            } catch (ClassCastException e) {
                this.isValid = false;
                this.errorMessage = CBConstant.errorMessages.INVALID_PARAM_PREFIX
                        + CBConstant.CB_CONFIG;
                return this;
            }
        } else {
            this.isValid = false;
            this.errorMessage = CBConstant.errorMessages.INVALID_PARAM_PREFIX
                    + CBConstant.CB_CONFIG;
            return this;
        }
        return this;
    }
}
