package com.payu.custombrowser.parser;


import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import java.util.HashMap;

public class HashMapToCBConfigHybrid {

    private final HashMap<String, Object> payUPaymentParams;
    private boolean isValid = true;
    private String errorMessage;
    private CustomBrowserConfig config;

    public CustomBrowserConfig getConfig() {
        return config;
    }

    public boolean isValid() {
        return isValid;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public HashMapToCBConfigHybrid(HashMap<String, Object> paymentConfig) {
        this.payUPaymentParams = paymentConfig;
    }

    public HashMapToCBConfigHybrid parse() {
        ParsingValidator parsingValidator = new ParsingValidator(payUPaymentParams).validateConfigParams();
        if (!parsingValidator.isValid()) {
            this.isValid = false;
            this.errorMessage = parsingValidator.getErrorMessage();
            return this;
        }
        String merchantKey = CBUtil.valueOf(payUPaymentParams.get(CBConstant.KEY));
        String txnId = CBUtil.valueOf(payUPaymentParams.get(CBConstant.TRANSACTION_ID));


        CustomBrowserConfig config = new CustomBrowserConfig(merchantKey, txnId);

        HashMap<String, Object> cbConfigMap = (HashMap<String, Object>) payUPaymentParams.get(CBConstant.CB_CONFIG);
        if (cbConfigMap != null) {

            if (cbConfigMap.containsKey(CBConstant.HYBRID_POST_DATA)) {
                config.setPayuPostData(CBUtil.valueOf(cbConfigMap.get(CBConstant.HYBRID_POST_DATA)));
            }
            if (cbConfigMap.containsKey(CBConstant.URL)) {
                config.setPostURL(CBUtil.valueOf(cbConfigMap.get(CBConstant.URL)));
            }
            if (cbConfigMap.containsKey(CBConstant.VIEW_PORT_WIDE_ENABLE)) {
                config.setViewPortWideEnable(Boolean.parseBoolean(CBUtil.valueOf(cbConfigMap.get(CBConstant.VIEW_PORT_WIDE_ENABLE))));
            }

            if (cbConfigMap.containsKey(CBConstant.AUTO_APPROVE)) {
                config.setAutoApprove(Boolean.parseBoolean(CBUtil.valueOf(cbConfigMap.get(CBConstant.AUTO_APPROVE))));
            }

            if (cbConfigMap.containsKey(CBConstant.AUTO_SELECT_OTP)) {
                config.setAutoSelectOTP(Boolean.parseBoolean(CBUtil.valueOf(cbConfigMap.get(CBConstant.AUTO_SELECT_OTP))));
            }

            if (cbConfigMap.containsKey(CBConstant.INTERNET_RESTORED_TTL)) {
                config.setInternetRestoredWindowTTL(CBUtil.parseInt(CBUtil.valueOf(cbConfigMap.get(CBConstant.INTERNET_RESTORED_TTL))));
            }
            if (cbConfigMap.containsKey(CBConstant.SDK_VERSION_NAME)) {
                config.setSdkVersionName(CBUtil.valueOf(cbConfigMap.get(CBConstant.SDK_VERSION_NAME)));
            }

            if (cbConfigMap.containsKey(CBConstant.MERCHANT_CHECKOUT_ACTIVITY_PATH)) {
                config.setMerchantCheckoutActivityPath(CBUtil.valueOf(cbConfigMap.get(
                        CBConstant.MERCHANT_CHECKOUT_ACTIVITY_PATH
                )));
            }
            if (cbConfigMap.containsKey(CBConstant.HTML_DATA)) {
                config.setHtmlData(CBUtil.valueOf(cbConfigMap.get(CBConstant.HTML_DATA)));
            }
            if (cbConfigMap.containsKey(CBConstant.CBDRAWER_CUSTOM_MENU)) {
                config.setCbDrawerCustomMenu(CBUtil.parseInt(CBUtil.valueOf(cbConfigMap.get(CBConstant.CBDRAWER_CUSTOM_MENU))));
            }
            if (cbConfigMap.containsKey(CBConstant.GMS_PROVIDER_UPDATED_STATUS)) {
                config.setGmsProviderUpdatedStatus(CBUtil.parseInt(CBUtil.valueOf(cbConfigMap.get(CBConstant.GMS_PROVIDER_UPDATED_STATUS))));
            }
            if (cbConfigMap.containsKey(CBConstant.REACT_VERSION)) {
                config.setReactVersion(CBUtil.valueOf(cbConfigMap.get(CBConstant.REACT_VERSION)));
            }
            if (cbConfigMap.containsKey(CBConstant.DISABLE_INTENTSEAMLESS_FAILURE)) {
                config.setDisableIntentSeamlessFailure(
                        CBUtil.parseInt(CBUtil.valueOf(cbConfigMap.get(CBConstant.DISABLE_INTENTSEAMLESS_FAILURE)))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.DISABLE_BACKBUTTON_DIALOG)) {
                config.setDisableBackButtonDialog(
                        Boolean.parseBoolean(CBUtil.valueOf(cbConfigMap.get(CBConstant.DISABLE_BACKBUTTON_DIALOG)))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.ENABLE_SSL_DIALOG)) {
                config.setEnableSslDialog(Boolean.parseBoolean(CBUtil.valueOf(cbConfigMap.get(CBConstant.ENABLE_SSL_DIALOG))));
            }
            if (cbConfigMap.containsKey(CBConstant.EMAIL)) {
                config.setEmail(
                        CBUtil.valueOf(cbConfigMap.get(CBConstant.EMAIL))

                );
            }
            if (cbConfigMap.containsKey(CBConstant.FIRST_NAME)) {
                config.setFirstName(
                        CBUtil.valueOf(cbConfigMap.get(CBConstant.FIRST_NAME))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.LAST_NAME)) {
                config.setLastName(
                        CBUtil.valueOf(cbConfigMap.get(CBConstant.LAST_NAME))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.HYBRID_MERCHANT_SMS_PERMISSION)) {
                config.setMerchantSMSPermission(
                        Boolean.parseBoolean(CBUtil.valueOf(cbConfigMap.get(CBConstant.HYBRID_MERCHANT_SMS_PERMISSION)))
                );
            }

            if (cbConfigMap.containsKey(CBConstant.PACKAGE_NAME_FOR_SPECIFIC_APP)) {
                config.setPackageNameForSpecificApp(
                        CBUtil.valueOf(cbConfigMap.get(CBConstant.PACKAGE_NAME_FOR_SPECIFIC_APP))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.PAYMENT_TYPE)) {
                config.setPaymentType(
                        CBUtil.valueOf(cbConfigMap.get(CBConstant.PAYMENT_TYPE))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.PHONE_PE_USER_CACHE_ENABLED)) {
                config.setIsPhonePeUserCacheEnabled(
                        CBUtil.parseInt(CBUtil.valueOf(cbConfigMap.get(CBConstant.PHONE_PE_USER_CACHE_ENABLED)))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.SDK_VERSION_NAME)) {
                config.setSdkVersionName(
                        CBUtil.valueOf(cbConfigMap.get(CBConstant.SDK_VERSION_NAME))
                );
            }
            if (cbConfigMap.containsKey(CBConstant.MERCHANT_RESPONSE_TIMEOUT)) {
                config.setMerchantResponseTimeout(
                        CBUtil.parseInt(CBUtil.valueOf(cbConfigMap.get(CBConstant.MERCHANT_RESPONSE_TIMEOUT)))
                );
            }
        }
        this.config = config;
        return this;

    }

}
