package com.payu.custombrowser.cbinterface;

import com.payu.custombrowser.CBActivity;

public interface CustomBrowserUiEvents {
    /**
     * Open Bottomsheet loader with the message below the progress bar.
     *
     * @param message, loader message on BottomSheet loader.
     */
    void loading(String message);

    /**
     * Can get some bank error through Js method, in this case, CB Bottom sheet will be close.
     *
     * @param field, js field.
     */
    void onBankError(String field);

    /**
     * When showing users two options, Register or OTP.
     *
     * @param params, Js params
     * @see com.payu.custombrowser.Bank#convertToNative(String, String)
     */
    void chooseFasterAction(String params);

    /**
     * Invoke on the basis of Js field incorrectOTP
     *
     * @param params, Js params
     * @see com.payu.custombrowser.Bank#convertToNative(String, String)
     */
    void incorrectOtp(String params);

    /**
     * Opens, 1. when get userDenied from OtpParser.
     * {@see PayUCBLifecycle#prepareSmsListener()}
     * 2. When user expand the bottom sheet from collapsed UI.
     * {@see PayUCBLifecycle#openCollapsedUI()}
     *
     * @param otp, String otp
     */
    void enterManually(String otp);

    /**
     * Invoke on the basis of Js field enterOtp
     *
     * @param params, Js params
     * @see com.payu.custombrowser.Bank#convertToNative(String, String)
     */
    void enterOtp(String params);

    /**
     * Invoke Bottom sheet back button behaviour, when user presses back button.
     *
     * @see CBActivity#onBackPressed()
     */
    void backButton();


    /**
     * It closes the bottomsheet.
     */
    void finish();

    /**
     * Invoke on the basis of Js field retryOtp
     *
     * @param params, Js params
     * @see com.payu.custombrowser.Bank#convertToNative(String, String)
     */
    void retryOtp(String params);

    /**
     * Invoked when fetched the Otp through Otp Parser SDK.
     * {@see PayUCBLifecycle#prepareSmsListener()}
     *
     * @param otp, Otp String
     */
    void otpFetched(String otp);

}
