package com.payu.custombrowser.bean;

import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.PaymentOption;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public enum CustomBrowserData {
    SINGLETON;
    private PayUCustomBrowserCallback payuCustomBrowserCallback;


    private Set<String> domainListofSession = new CopyOnWriteArraySet<>();

    private Set<PaymentOption> paymentOptionSet = new HashSet<>();

    /**
     * Getter of PayU CustomBrowser Callback
     *
     * @return {@link com.payu.custombrowser.PayUCustomBrowserCallback}
     */
    public PayUCustomBrowserCallback getPayuCustomBrowserCallback() {
        return payuCustomBrowserCallback;
    }

    /**
     * Setter of PayU CustomBrowser Callback
     *
     * @param payuCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}
     */
    public void setPayuCustomBrowserCallback(PayUCustomBrowserCallback payuCustomBrowserCallback) {
        this.payuCustomBrowserCallback = payuCustomBrowserCallback;
    }

    /**
     * Check if PaymentOption availability called
     *
     * @param paymentOptionName PaymentOption Type
     * @return true/false
     */
    public boolean isPaymentOptionAvailabilityCalled(PaymentOption paymentOptionName) {
        for (PaymentOption paymentOption : paymentOptionSet

        ) {
            L.v("Class Name: " + getClass().getCanonicalName() + "Payment options: " + paymentOption.getPaymentName());

        }
        return paymentOptionSet.contains(paymentOptionName);
    }

    /**
     * Put paymentOptionWrapper for paymentoption in Set
     *
     * @param paymentOptionName PaymentOption Type
     */
    public void setPaymentOption(PaymentOption paymentOptionName) {
        this.paymentOptionSet.add(paymentOptionName);
    }

    /**
     * Remove PaymentOption from paymentOptionSet
     *
     * @param paymentOption PaymentOption Type
     */
    public void removePaymentOption(PaymentOption paymentOption) {
        this.paymentOptionSet.remove(paymentOption);
    }

    public Set<String> getDomainListofSession() {
        return domainListofSession;
    }

    public void addDomain(String domainName) {
        domainListofSession.add(domainName);
    }

    public void removeDomain(String domainName) {
        domainListofSession.remove(domainName);
    }
}
