package com.payu.custombrowser.analytics;

import static android.provider.Settings.Secure.getString;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;

import com.payu.custombrowser.AnalyticsHandler.AnalyticsConstant;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.BuildConfig;
import com.payu.custombrowser.util.CBUtil;
import com.payu.payuanalytics.analytics.factory.AnalyticsFactory;
import com.payu.payuanalytics.analytics.model.AnalyticsConfig;
import com.payu.payuanalytics.analytics.model.AnalyticsType;
import com.payu.payuanalytics.analytics.model.BaseAnalytics;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AnalyticsHandler {
    public void logAnalytics(Context context, String eventName, Map<String, Object> eventData, String amount) {
        //Prepare final event map
        Map<String, Object> eventMap = new HashMap<>();
        eventMap.put(AnalyticsConstant.UI_EVENT_NAME, eventName);
        eventData.put(AnalyticsConstant.UI_DEVICE, AnalyticsConstant.CB_ANDROID);
        eventData.put(AnalyticsConstant.UI_DEVICE_ID, getDeviceID(context));
        eventData.put(AnalyticsConstant.CB_DEVICE_NAME, Build.MANUFACTURER.concat(" " + Build.MODEL));
        eventData.put(AnalyticsConstant.CB_DEVICE_VERSION, Build.VERSION.RELEASE);
        eventData.put(AnalyticsConstant.CB_SDK_VERSION, BuildConfig.VERSION_NAME);
        eventData.put(AnalyticsConstant.UI_AMOUNT, amount);
        eventData.put(AnalyticsConstant.UI_TXNID, Bank.transactionID);
        eventData.put(AnalyticsConstant.UI_MERCHANT_IDENTIFIER, Bank.keyAnalytics);
        eventMap.put(AnalyticsConstant.UI_EVENT_DATA, eventData);
        if (null != Bank.transactionID && null != Bank.keyAnalytics) {
            eventMap.put(AnalyticsConstant.UI_IDENTITY, Bank.transactionID.concat(Bank.keyAnalytics));
        } else {
            eventMap.put(AnalyticsConstant.UI_IDENTITY, "no_txnid");
        }
        eventMap.put(AnalyticsConstant.UI_TYPE, AnalyticsConstant.CB_EVENT);
        AnalyticsConfig analyticsConfig = new AnalyticsConfig();
//        analyticsConfig.setEnabled(false);
        analyticsConfig.setInitiatorIdentifier(AnalyticsConstant.CB_PACKAGE_NAME.concat(AnalyticsType.CLEVERTAP.name()));
        analyticsConfig.setCtAccountId(CBUtil.getWizRocketID().get(0) + "-" + CBUtil.getWizRocketID().get(1) + "-" + CBUtil.getWizRocketID().get(2));
        analyticsConfig.setCtPassCode(CBUtil.getWizRocketPass().get(0) + "-" + CBUtil.getWizRocketPass().get(1) + "-" + CBUtil.getWizRocketPass().get(2));
        BaseAnalytics clevertapAnalytics = new AnalyticsFactory(context, analyticsConfig).getAnalyticsClass(AnalyticsType.CLEVERTAP);
        clevertapAnalytics.log(new JSONObject(eventMap).toString());
    }

    @SuppressLint("HardwareIds")
    private String getDeviceID(Context applicationContext) {
        return getString(applicationContext.getContentResolver(), Settings.Secure.ANDROID_ID);
    }
}
