package com.payu.custombrowser;

import static android.content.Context.NOTIFICATION_SERVICE;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.parser.HashMapToCBConfigHybrid;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.wrapper.UpiWrapper;
import com.payu.payuanalytics.analytics.model.PayUAnalytics;

import java.util.HashMap;


public class CustomBrowser {

    /**
     * Function to check if payment is supported
     *
     * @param activity                  Activity instance
     * @param paymentOption             {@link com.payu.custombrowser.util.PaymentOption}Payment Type
     * @param payUCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}PayUCustomBrowserCallback instance
     * @param paymentOptionHash         Hash for Payment Related Details api
     * @param merchantKey               Merchant Key
     * @param user_credentials          User Credentials
     */

    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials) {
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        UpiWrapper upiWrapper = new UpiWrapper();
        switch (paymentOption) {
            case SAMSUNGPAY:
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, PaymentOption.SAMSUNGPAY.getPaymentName());
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, CBConstant.DEVICE_NOT_SUPPORTED_OR + paymentOption.getPackageName() + CBConstant.IS_MISSING);
                }
                break;
           /*     case TEZ:

                if(CBUtil.isPaymentModuleAvailable(paymentOption)){
                    upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, PaymentOption.TEZ.getPaymentName());
                }else{
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED,CBConstant.DEVICE_NOT_SUPPORTED_OR+paymentOption.getPackageName()+CBConstant.IS_MISSING);
                }
                break;*/
            case PHONEPE:
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, PaymentOption.PHONEPE.getPaymentName());
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, CBConstant.DEVICE_NOT_SUPPORTED_OR + paymentOption.getPackageName() + CBConstant.IS_MISSING);
                }
                break;
            case TEZ:
            case UPI_INTENT:
            case UPI_TPV_COLLECT:
            case TEZ_OMNI:
            case UPI_COLLECT:
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    CustomBrowserResultData customBrowserResultData = new CustomBrowserResultData();
                    customBrowserResultData.setPaymentOption(paymentOption);
                    customBrowserResultData.setPaymentOptionAvailable(true);

                    CustomBrowserData.SINGLETON.setPaymentOption(paymentOption);
                    payUCustomBrowserCallback.isPaymentOptionAvailable(customBrowserResultData);
                    //upiWrapper.checkForPaymentOptionAvailability(activity, paymentOptionHash, merchantKey, user_credentials, "UPI");

                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, CBConstant.DEVICE_NOT_SUPPORTED_OR + paymentOption.getPackageName() + CBConstant.IS_MISSING);
                }
                break;
        }

    }

    /**
     * Call this method to add CustomBrowser to application
     *
     * @param activity                    base class activity
     * @param map                         contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, HashMap<String, Object> map, PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {
        HashMapToCBConfigHybrid hashMapToCBConfigHybrid = new HashMapToCBConfigHybrid(map).parse();
        if (hashMapToCBConfigHybrid.isValid()) {
            addCustomBrowser(activity, hashMapToCBConfigHybrid.getConfig(), cbPayUCustomBrowserCallback);
        } else {
            cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.errorCodes.MISSING_PARAMETER_EXCEPTION,
                    hashMapToCBConfigHybrid.getErrorMessage());
        }

    }
    /**
     * Call this method to add CustomBrowser to application
     *
     * @param cbCustomBrowserConfig       contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public Fragment addSeamlessCustomBrowser(@NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback, Context context) {
        PayUAnalytics analytics = AnalyticsCBInit.getInstance(context.getApplicationContext());
        analyticsLogging(cbCustomBrowserConfig, analytics, context, "cb_config", cbCustomBrowserConfig.getAnalyticsString());
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        cbCustomBrowserConfig.setPayuPostData(new CBUtil().getAnalyticsAddedPostData(cbCustomBrowserConfig.getPayuPostData()));
        PaymentOption paymentOptionName = new CBUtil().getPaymentOptionFromPostData(cbCustomBrowserConfig.getPayuPostData());
        if (!TextUtils.isEmpty(cbCustomBrowserConfig.getReactVersion()))
            analyticsLogging(cbCustomBrowserConfig, analytics, context, CBAnalyticsConstant.REACT_VERSION_NAME, cbCustomBrowserConfig.getReactVersion());
        //Check if payment option is supported
        L.v("Class Name: " + getClass().getCanonicalName() + "Payment option name:" + paymentOptionName);
        //We have payment which is supported by UPI Sdk.Lets call UPI SDK
        if (paymentOptionName != null) {

            L.v("Class Name: " + getClass().getCanonicalName() + "PaymentOptionName CB " + paymentOptionName.getPaymentName());
            if (paymentOptionName.isDefault()) {
                if (CBUtil.isPaymentModuleAvailable(paymentOptionName)) {
                    analyticsLogging(cbCustomBrowserConfig, analytics, context, CBAnalyticsConstant.PAYMENT_OPTION, CBAnalyticsConstant.DEFAULT);
                    Log.v("analyticsLoggingCB", "analyticsLogging");
                    return callSeamlessUpiWrapper(paymentOptionName, cbCustomBrowserConfig, context);
                } else {
                    analytics.log(CBUtil.getLogMessage(context.getApplicationContext(), CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED + "_" + paymentOptionName.getAnalyticsKey().toLowerCase() + CBConstant.IS_MISSING, paymentOptionName.getAnalyticsKey().toLowerCase() + CBAnalyticsConstant.LAUNCH_FAILED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                    cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, paymentOptionName.getPackageName() + CBConstant.IS_MISSING);
                }
            } else if (CustomBrowserData.SINGLETON.isPaymentOptionAvailabilityCalled(paymentOptionName)) {
                analyticsLogging(cbCustomBrowserConfig, analytics, context, CBAnalyticsConstant.PAYMENT_OPTION, CBAnalyticsConstant.NOTDEFAULT);
                return callSeamlessUpiWrapper(paymentOptionName, cbCustomBrowserConfig, context);
            } else {
                analyticsLogging(cbCustomBrowserConfig, analytics, context, paymentOptionName.getAnalyticsKey().toLowerCase(), paymentOptionName.getAnalyticsKey().toLowerCase() + CBAnalyticsConstant.LAUNCH_FAILED);
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHECK_PAYMENT_NOT_CALLED, CBConstant.CHECK_PAYMENT_NOT_CALLED_MSG + " for " + paymentOptionName.getPaymentName());
            }
        } else {
            analyticsLogging(cbCustomBrowserConfig, analytics, context, CBAnalyticsConstant.PAYMENT_OPTION, CBAnalyticsConstant.PAYMENTOPTIONNAMEISNULL);

            if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (null != cbCustomBrowserConfig.getPostURL() && (cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)
                    || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL_SEAMLESS) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS)))) {
                // Sometimes post data contains & at the end, just removing it from the postdata
                if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                    cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
                }
                // Adding snooze=<snooze_count> in the post data being sent to payu server (_payment)
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
            }
            //If merchant hasn't created a channel we create our default
            if (cbCustomBrowserConfig.getSurePayNotificationChannelId().equalsIgnoreCase(CBConstant.NOTIFICATION_CHANNEL_ID)) {
                createNotificationChannel(context);
            }
            CBFragment.cbConfigProgressDialogView = cbCustomBrowserConfig.getProgressDialogCustomView();
            if (cbCustomBrowserConfig.getPayuPostData() != null) {
                String bankCode = new CBUtil().getDataFromPostData(cbCustomBrowserConfig.getPayuPostData()).get(CBConstant.BANK_CODE);
                analytics.log(CBUtil.getLogMessage(context.getApplicationContext(), CBAnalyticsConstant.PAYMENT_OPTION, CBConstant.BANK_CODE + "_" + bankCode, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
            }

            Bundle bundle = new Bundle();
            bundle.putParcelable("cb_config", cbCustomBrowserConfig);

            return CBFragment.newInstance(bundle);
//            CbBottomSheet cbBottomSheet = new CbBottomSheet(null, new Bank());
//            cbBottomSheet.show(((FragmentActivity)activity).getSupportFragmentManager(), "Test");

        }
        return null;
    }

    /**
     * Call this method to add CustomBrowser to application
     *
     * @param activity                    base class activity
     * @param cbCustomBrowserConfig       contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {
        if (activity == null || activity.isFinishing() || activity.isDestroyed()) {
            cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.ACTIVITY_NOT_FOUND_CODE, CBConstant.ACTIVITY_NOT_FOUND);
        } else {
        PayUAnalytics analytics = AnalyticsCBInit.getInstance(activity.getApplicationContext());
        analyticsLogging(cbCustomBrowserConfig, analytics, activity, "cb_config", cbCustomBrowserConfig.getAnalyticsString());
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        cbCustomBrowserConfig.setPayuPostData(new CBUtil().getAnalyticsAddedPostData(cbCustomBrowserConfig.getPayuPostData()));
        PaymentOption paymentOptionName = new CBUtil().getPaymentOptionFromPostData(cbCustomBrowserConfig.getPayuPostData());
        if (!TextUtils.isEmpty(cbCustomBrowserConfig.getReactVersion()))
            analyticsLogging(cbCustomBrowserConfig, analytics, activity, CBAnalyticsConstant.REACT_VERSION_NAME, cbCustomBrowserConfig.getReactVersion());
        //Check if payment option is supported
        L.v("Class Name: " + getClass().getCanonicalName() + "Payment option name:" + paymentOptionName);
        //We have payment which is supported by UPI Sdk.Lets call UPI SDK
        if (paymentOptionName != null) {

            L.v("Class Name: " + getClass().getCanonicalName() + "PaymentOptionName CB " + paymentOptionName.getPaymentName());
            if (paymentOptionName.isDefault()) {
                if (CBUtil.isPaymentModuleAvailable(paymentOptionName)) {
                    analyticsLogging(cbCustomBrowserConfig, analytics, activity, CBAnalyticsConstant.PAYMENT_OPTION, CBAnalyticsConstant.DEFAULT);
                    Log.v("analyticsLoggingCB", "analyticsLogging");
                    callUpiWrapper(paymentOptionName, cbCustomBrowserConfig, activity);
                } else {
                    analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED + "_" + paymentOptionName.getAnalyticsKey().toLowerCase() + CBConstant.IS_MISSING, paymentOptionName.getAnalyticsKey().toLowerCase() + CBAnalyticsConstant.LAUNCH_FAILED, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                    cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED, paymentOptionName.getPackageName() + CBConstant.IS_MISSING);
                }
            } else if (CustomBrowserData.SINGLETON.isPaymentOptionAvailabilityCalled(paymentOptionName)) {
                analyticsLogging(cbCustomBrowserConfig, analytics, activity, CBAnalyticsConstant.PAYMENT_OPTION, CBAnalyticsConstant.NOTDEFAULT);
                callUpiWrapper(paymentOptionName, cbCustomBrowserConfig, activity);
            } else {
                analyticsLogging(cbCustomBrowserConfig, analytics, activity, paymentOptionName.getAnalyticsKey().toLowerCase(), paymentOptionName.getAnalyticsKey().toLowerCase() + CBAnalyticsConstant.LAUNCH_FAILED);
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHECK_PAYMENT_NOT_CALLED, CBConstant.CHECK_PAYMENT_NOT_CALLED_MSG + " for " + paymentOptionName.getPaymentName());
            }
        } else {
            analyticsLogging(cbCustomBrowserConfig, analytics, activity, CBAnalyticsConstant.PAYMENT_OPTION, CBAnalyticsConstant.PAYMENTOPTIONNAMEISNULL);

            if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (null != cbCustomBrowserConfig.getPostURL() && (cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)
                    || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL_SEAMLESS) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS)))) {
                // Sometimes post data contains & at the end, just removing it from the postdata
                if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                    cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
                }
                // Adding snooze=<snooze_count> in the post data being sent to payu server (_payment)
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
            }
            //If merchant hasn't created a channel we create our default
            if (cbCustomBrowserConfig.getSurePayNotificationChannelId().equalsIgnoreCase(CBConstant.NOTIFICATION_CHANNEL_ID)) {
                createNotificationChannel(activity);
            }
            CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
            if(cbCustomBrowserConfig.getToolBarView() != null)
                CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
            CBActivity.cbConfigProgressDialogView = cbCustomBrowserConfig.getProgressDialogCustomView();
            if (cbCustomBrowserConfig.getPayuPostData() != null) {
                String bankCode = new CBUtil().getDataFromPostData(cbCustomBrowserConfig.getPayuPostData()).get(CBConstant.BANK_CODE);
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.PAYMENT_OPTION, CBConstant.BANK_CODE + "_" + bankCode, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
            }

            Intent intent = new Intent(activity, CBActivity.class);
            intent.putExtra("cb_config", cbCustomBrowserConfig);

            activity.startActivity(intent);
//            CbBottomSheet cbBottomSheet = new CbBottomSheet(null, new Bank());
//            cbBottomSheet.show(((FragmentActivity)activity).getSupportFragmentManager(), "Test");

        }
    }
    }

    private void analyticsLogging(@NonNull CustomBrowserConfig cbCustomBrowserConfig, PayUAnalytics analytics, Context context, String key, String value) {
        try {
            analytics.log(CBUtil.getLogMessage(context, key, value, null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));

        } catch (Exception e) {
            L.v("Class analyticsLogging: key" + key + " value" + value + " " + e.getMessage());
        }
    }

    private void callUpiWrapper(PaymentOption paymentOptionName, CustomBrowserConfig cbCustomBrowserConfig, Activity activity) {
        UpiWrapper upiWrapper = new UpiWrapper();
        cbCustomBrowserConfig.setPaymentType(paymentOptionName.getPaymentName());
        CBUtil.setVariableReflection(CBConstant.UPI_SDK_PACKAGE, BuildConfig.VERSION_NAME, CBConstant.CB_VERSION); //Update cb version name in UPI sdk
        L.v("Class Name: " + getClass().getCanonicalName() + "< postdata >" + cbCustomBrowserConfig.getPayuPostData());
        upiWrapper.makePayment(activity, cbCustomBrowserConfig);
    }

    private Fragment callSeamlessUpiWrapper(PaymentOption paymentOptionName, CustomBrowserConfig cbCustomBrowserConfig, Context context) {
        UpiWrapper upiWrapper = new UpiWrapper();
        cbCustomBrowserConfig.setPaymentType(paymentOptionName.getPaymentName());
        CBUtil.setVariableReflection(CBConstant.UPI_SDK_PACKAGE, BuildConfig.VERSION_NAME, CBConstant.CB_VERSION); //Update cb version name in UPI sdk
        L.v("Class Name: " + getClass().getCanonicalName() + "< postdata >" + cbCustomBrowserConfig.getPayuPostData());
        return upiWrapper.makeSeamlessPayment(cbCustomBrowserConfig,context);
    }

    /**
     * Function to create Default Notification Channel
     * If parameters are same channel creation is ignored
     *
     * @param context base class activity
     */
    @TargetApi(26)
    private void createNotificationChannel(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            @SuppressLint("WrongConstant")
            NotificationChannel mChannel = new NotificationChannel(CBConstant.NOTIFICATION_CHANNEL_ID, CBConstant.NOTIFICATION_CHANNEL_NAME, NotificationManager.IMPORTANCE_DEFAULT);
            mChannel.setDescription(CBConstant.NOTIFICATION_CHANNEL_DESCRIPTION);
            // Register the channel with the system; you can't change the importance
            // or other notification behaviors after this
            NotificationManager notificationManager = (NotificationManager) context.getSystemService(
                    NOTIFICATION_SERVICE);
            if (null != notificationManager)
                notificationManager.createNotificationChannel(mChannel);
        }
    }

}
