package com.payu.custombrowser;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;

import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.payu.commonui.utils.CommonUIViewUtils;
import com.payu.custombrowser.AnalyticsHandler.AnalyticsConstant;
import com.payu.custombrowser.cbinterface.CbBottomSheetEventListener;
import com.payu.custombrowser.cbinterface.CustomBrowserUiEvents;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

import kotlin.ranges.RangesKt;

public class CbBottomSheet extends BottomSheetDialogFragment implements CustomBrowserUiEvents, View.OnClickListener, TimeAnimator.TimeListener {
    private final String TAG = "CbBottomSheet";
    private CbBottomSheetEventListener cbBottomSheetEventListener;
    private RelativeLayout rlManualOtpSubmit, rlContent, rlCancelLayout, rlSubmittingOtpTapToPause;
    private RelativeLayout waitingForOtp, rlManualPasswordSubmit;
    private RelativeLayout rlPasswordSectionFaster, rlOtpCardNotRegistered;
    private RelativeLayout rlPasswordFaster;
    private RelativeLayout rlOtpSectionFaster, rlOtpFaster, rlRegisterCardNotRegistered;
    private EditText etEnterOtpEditTextSubmitOtp;
    private Button btnSubmitOtpManual;
    private Button btnSubmittingOtpTapToPause, btnYes;
    private Bank bank;
    private TextView tvWaitingForOtp, tvTitleText, tvResendOtp;
    private TextView tvErrorMsg, tvNo;
    private TextView tvProgressDialogSubText;
    private LinearLayout llProgressScreen, llOptionForFasterPayment, llCardNotRegisteredForPin;

    private AppCompatImageView payUOtpProgressBar;
    private RelativeLayout rlOtpSectionForCardNotRegistered;
    private TimeAnimator mAnimator;
    private boolean isWaitTimeFinished, isWaitTimerRunning;
    private boolean isUserPausedSubmitOtp;
    private ClipDrawable mClipDrawable;
    private int mCurrentLevel = 0;
    private boolean isSubmitOtpApiInProgress = false;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(STYLE_NORMAL, R.style.Cb_Otp_CustomBottomSheetDialogTheme);
    }

    /**
     * Constructor for the Cb Bottom sheet.
     *
     * @param cbBottomSheetEventListener, listener that will call when we need to open collapsed UI.
     * @param bank,                       instance of Bank that we need to call bank page functionality.
     */
    CbBottomSheet(CbBottomSheetEventListener cbBottomSheetEventListener, Bank bank) {
        this.cbBottomSheetEventListener = cbBottomSheetEventListener;
        this.bank = bank;
    }

    @Override
    public void onCancel(@NonNull DialogInterface dialog) {
        super.onCancel(dialog);
        if (null != bank) {
            if (!isWaitTimeFinished) {
                bank.timerValueRemaining = remainingTime;
            }
            bank.isCbBottomSheetExpanded = false;
            bank.params = params;
        }
        clear();
        if (null != cbBottomSheetEventListener)
            cbBottomSheetEventListener.onCbBottomSheetCancel();
    }

    private void clear() {
        cancelCountDownTimer();
        cancelAnimation();
        clearReferences();
    }

    /**
     * Closing waiting timer.
     */
    void cancelCountDownTimer() {
        isWaitTimeFinished = true;
        isWaitTimerRunning = false;
        if (null != countDownTimerForOtp) {
            countDownTimerForOtp.cancel();
            countDownTimerForOtp = null;
        }

    }

    /**
     * Cancelling left to right sliding animation.
     */
    void cancelAnimation() {
        if (null != mAnimator && mAnimator.isRunning()) {
            mAnimator.pause();
            mAnimator = null;
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.bottom_sheet_cb, container, false);
        if (null != bank)
            bank.isCbBottomSheetExpanded = true;
        initViews(view);
        initListeners();
        return view;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        if (bank != null && bank.customBrowserConfig != null)
            CommonUIViewUtils.updateLayoutSecurity(requireActivity(), bank.customBrowserConfig.isProtectedScreen());
    }

    @Override
    public void onDetach() {
        super.onDetach();
        CBUtil.stopLoopingAnimatedVectorDrawable();
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false);
    }

    /**
     * Initializing Views.
     *
     * @param view, View instance
     */
    private void initViews(View view) {
        llProgressScreen = view.findViewById(R.id.llProgressScreen);
        rlManualOtpSubmit = view.findViewById(R.id.rlManualOtpSubmit);
        rlContent = view.findViewById(R.id.rlContent);
        rlCancelLayout = view.findViewById(R.id.rlCancelLayout);
        rlSubmittingOtpTapToPause = view.findViewById(R.id.rlSubmittingOtpTapToPause);
        waitingForOtp = view.findViewById(R.id.waitingForOtp);
        llOptionForFasterPayment = view.findViewById(R.id.llOptionForFasterPayment);
        llCardNotRegisteredForPin = view.findViewById(R.id.llCardNotRegisteredForPin);
        rlManualPasswordSubmit = view.findViewById(R.id.rlManualPasswordSubmit);
        tvWaitingForOtp = view.findViewById(R.id.tvWaitingForOtp);
        rlPasswordSectionFaster = view.findViewById(R.id.rlPasswordSectionFaster);
        rlRegisterCardNotRegistered = view.findViewById(R.id.rlRegisterCardNotRegistered);
        rlOtpSectionForCardNotRegistered = view.findViewById(R.id.rlOtpSectionForCardNotRegistered);
        rlOtpCardNotRegistered = view.findViewById(R.id.rlOtpCardNotRegistered);
        rlPasswordFaster = view.findViewById(R.id.rlPasswordFaster);
        rlOtpSectionFaster = view.findViewById(R.id.rlOtpSectionFaster);
        rlOtpFaster = view.findViewById(R.id.rlOtpFaster);
        tvTitleText = view.findViewById(R.id.tvTitleText);
        tvResendOtp = view.findViewById(R.id.tvResendOtp);
        tvErrorMsg = view.findViewById(R.id.tvErrorMsg);
        tvErrorMsg.setVisibility(View.GONE);
        etEnterOtpEditTextSubmitOtp = view.findViewById(R.id.etEnterOtpEditTextSubmitOtp);
        btnSubmitOtpManual = view.findViewById(R.id.btnSubmitOtpManual);
        btnSubmittingOtpTapToPause = view.findViewById(R.id.btnSubmittingOtpTapToPause);
        btnYes = view.findViewById(R.id.btnYes);
        tvProgressDialogSubText = view.findViewById(R.id.tvProgressDialogSubText);
        tvNo = view.findViewById(R.id.tvNo);
        payUOtpProgressBar = view.findViewById(R.id.payUOtpProgressBar);
        initDrawables();
    }

    /**
     * Initializing drawable fot clip animation.
     */
    private void initDrawables() {
        LayerDrawable layerDrawable = (LayerDrawable) btnSubmittingOtpTapToPause.getBackground();
        mClipDrawable = (ClipDrawable) layerDrawable.findDrawableByLayerId(R.id.clip_drawable);
        mAnimator = new TimeAnimator();
        Drawable backgroundDrawable = layerDrawable.getDrawable(0);
        Drawable progressDrawable = layerDrawable.getDrawable(1);

        backgroundDrawable.setColorFilter(
                ContextCompat.getColor(requireContext(), R.color.cb_slide_color_primary_bg),
                PorterDuff.Mode.SRC_IN
        );

        progressDrawable.setColorFilter(
                ContextCompat.getColor(requireContext(), R.color.cb_slide_color_primary),
                PorterDuff.Mode.SRC_IN
        );
    }

    /**
     * Inializing the listeners.
     */
    private void initListeners() {
        tvNo.setOnClickListener(this);
        btnYes.setOnClickListener(this);
        rlPasswordFaster.setOnClickListener(this);
        rlOtpFaster.setOnClickListener(this);
        btnSubmitOtpManual.setOnClickListener(this);
        btnSubmittingOtpTapToPause.setOnClickListener(this);
        rlRegisterCardNotRegistered.setOnClickListener(this);
        rlOtpCardNotRegistered.setOnClickListener(this);
        tvResendOtp.setOnClickListener(this);
        mAnimator.setTimeListener(this);
        etEnterOtpEditTextSubmitOtp.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                String otp = charSequence.toString();
                if (i3 != 0 || i2 != 0)
                    bank.otpFetched = otp;
                if (otp.length() >= 6 && otp.length() <= 8) {
                    btnSubmitOtpManual.setEnabled(true);
                    ViewCompat.setBackgroundTintList(btnSubmitOtpManual, ColorStateList.valueOf(ContextCompat.getColor(requireActivity(), R.color.payu_cb_primary_color)));

                } else {
                    disableSubmitOtpButton();
                }
            }

            @Override
            public void afterTextChanged(Editable editable) {
            }
        });

        mAnimator.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (null != bank && !isUserPausedSubmitOtp) {
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.AUTO_APPROVED_OTP);
                    submitOtpJs(bank.otpFetched);
                }

            }
        });
        Objects.requireNonNull(getDialog()).setOnKeyListener((dialog, keyCode, event) -> {
            if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_BACK) {
                showCancelTxnOption();
                return true;
            }
            return false;
        });
    }

    private void disableSubmitOtpButton() {
        btnSubmitOtpManual.setEnabled(false);
        String alphaColor =
                CBUtil.addAlpha(
                        "#" + Integer.toHexString(ContextCompat.getColor(requireActivity(), R.color.payu_cb_primary_color) & 0x00ffffff), 0.68);
        try {
            ViewCompat.setBackgroundTintList(btnSubmitOtpManual, ColorStateList.valueOf(Color.parseColor(alphaColor)));
        } catch (IllegalArgumentException e) {
            ViewCompat.setBackgroundTintList(btnSubmitOtpManual, ColorStateList.valueOf(ContextCompat.getColor(requireActivity(), R.color.payu_cb_primary_color_secendary)));
        }
    }

    @Override
    public void loading(String message) {
        this.setCancelable(false);
        changeVisibility(CBConstant.UI_LOADING);
    }

    @Override
    public void onBankError(String field) {
        if (null != bank) {
            String errorReason = "";
            if (null != field && !field.isEmpty())
                errorReason = field;
            if (null != bank)
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.ARRIVAL, CBAnalyticsConstant.BANK_ERROR + "_" + errorReason);
        }
        finish();
    }

    private void changeVisibility(String type) {
        rlContent.setVisibility(View.VISIBLE);
        waitingForOtp.setVisibility(View.GONE);
        llCardNotRegisteredForPin.setVisibility(View.GONE);
        rlManualPasswordSubmit.setVisibility(View.GONE);
        rlSubmittingOtpTapToPause.setVisibility(View.GONE);
        rlCancelLayout.setVisibility(View.GONE);
        rlManualOtpSubmit.setVisibility(View.GONE);
        llProgressScreen.setVisibility(View.GONE);
        llOptionForFasterPayment.setVisibility(View.GONE);
        tvErrorMsg.setVisibility(View.GONE);
        switch (type) {
            case CBConstant.UI_CHOOSE_FASTER_ACTION:
                llOptionForFasterPayment.setVisibility(View.VISIBLE);
                break;
            case CBConstant.UI_MANUAL_OTP:
                rlManualOtpSubmit.setVisibility(View.VISIBLE);
                break;
            case CBConstant.UI_FASTER_PASSWORD:
                llCardNotRegisteredForPin.setVisibility(View.VISIBLE);
                break;
            case CBConstant.UI_CANCEL_TRANSACTION:
                rlContent.setVisibility(View.GONE);
                rlCancelLayout.setVisibility(View.VISIBLE);
                break;

            case CBConstant.UI_LOADING:
                rlContent.setVisibility(View.GONE);
                llProgressScreen.setVisibility(View.VISIBLE);
                CBUtil.applyLoopingAnimatedVectorDrawable(payUOtpProgressBar, this.requireActivity());
                break;

            case CBConstant.UI_ENTER_OTP:
                waitingForOtp.setVisibility(View.VISIBLE);
                break;
        }
    }

    private String params;

    @Override
    public void chooseFasterAction(String params) {
        this.setCancelable(true);
        if (null != bank) {
            bank.BOTTOM_SHEET_STATUS = CBConstant.CHOOSE_OPTION;
            bank.pageType = "";
        }
        this.params = params;
        changeVisibility(CBConstant.UI_CHOOSE_FASTER_ACTION);
        tvTitleText.setText(getString(R.string.cb_select_an_option_for_faster_payment));
        final JSONObject jsonObject;

        try {
            jsonObject = new JSONObject(params);

            if ((jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp))) || (jsonObject.has(getString(R.string.cb_pin)) && jsonObject.getBoolean(getString(R.string.cb_pin)))) {
                if (null != bank)
                    bank.pageType = CBAnalyticsConstant.CHOOSE_SCREEN;
            } else {
                if (null != bank)
                    bank.pageType = "";
            }
            if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) { // otp flow is not visible
                rlOtpSectionFaster.setVisibility(View.GONE);
            } else {
                if (null != bank && bank.autoSelectOtp) {
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.CB_AUTO_OTP_SELECT);
                    bank.otpClicked();
                    bank.autoSelectOtp = false;
                }
            }
            if (jsonObject.has(getString(R.string.cb_pin)) && !jsonObject.getBoolean(getString(R.string.cb_pin))) { // pin flow is not visible
                rlPasswordSectionFaster.setVisibility(View.GONE);
            } else {
                rlPasswordFaster.setOnClickListener(this);
            }
            //TODO: Error Message Screen
            if (null != bank && jsonObject.has(getString(R.string.cb_error))) { // oops sorry some error occured
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.ERROR_OCCURED_CHOOSE_FASTER_PAYMENT);
//                view.findViewById(R.id.error_message).setVisibility(View.VISIBLE);
//                ((TextView) view.findViewById(R.id.error_message)).setText(jsonObject.getString("error"));
            }
        } catch (JSONException e) {
            if (null != e && null != e.getMessage())
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.CB_EXCEPTION, "chooseFasterAction_" + e.getMessage());
        }
    }

    @Override
    public void incorrectOtp(String params) {
        isSubmitOtpApiInProgress = false;
        this.setCancelable(true);
        this.params = params;
        manualOtpVisible();
        tvErrorMsg.setText(getString(R.string.cb_invalid_otp_please_try_again));
        tvErrorMsg.setVisibility(View.VISIBLE);
        if (null != bank && bank.mPassword == null) {
            tvResendOtp.setVisibility(View.GONE);
        }
    }

    @Override
    public void enterManually(String otp) {
        isSubmitOtpApiInProgress = false;
        this.setCancelable(true);
        manualOtpVisible();
        setOtpToEditText(otp);
    }

    public void makeManualOtpVisible(){
        cancelCountDownTimer();
        handleResendOtpVisibility();
        if (null != bank)
            bank.BOTTOM_SHEET_STATUS = CBConstant.MANUAL_OTP;
        tvTitleText.setText(getString(R.string.cb_submit_otp));
        changeVisibility(CBConstant.UI_MANUAL_OTP);
        CBUtil.logAnalytics(bank, CBConstant.CB_BOTTOMSHEET, CBConstant.UI_MANUAL_OTP);
    }

    private void manualOtpVisible() {
        cancelCountDownTimer();
        handleResendOtpVisibility();
        if (null != bank)
            bank.BOTTOM_SHEET_STATUS = CBConstant.MANUAL_OTP;
        tvTitleText.setText(getString(R.string.cb_submit_otp));
        changeVisibility(CBConstant.UI_MANUAL_OTP);
        CBUtil.logAnalytics(bank, CBConstant.CB_BOTTOMSHEET, CBConstant.UI_MANUAL_OTP);

    }

    private void handleResendOtpVisibility() {
        if (null != params && !params.isEmpty()) {
            final boolean regenerate = CBUtil.hasKeyValue(params, getString(R.string.cb_regenerate));
            if (getActivity() != null) {
                if (regenerate) {
                    tvResendOtp.setVisibility(View.VISIBLE);
                } else {
                    tvResendOtp.setVisibility(View.GONE);
                }
            }
        }
    }

    @Override
    public void enterOtp(String params) {
        this.setCancelable(true);
        this.params = params;

        changeVisibility(CBConstant.UI_ENTER_OTP);
        try {
            final boolean regenerate = CBUtil.hasKeyValue(params, getString(R.string.cb_regenerate));
            final boolean pin = CBUtil.hasKeyValue(params, getString(R.string.cb_pin));

            if ((regenerate || pin) || (null != bank && bank.permissionGranted)) {
                //Reset the prefilled OTP
                rlManualOtpSubmit.setVisibility(View.GONE);
                waitingForOtp.setVisibility(View.VISIBLE);
                tvTitleText.setText(getString(R.string.cb_auto_reading_otp));
                if (!isWaitTimerRunning) {
                    cancelCountDownTimer();
                    showWaitOtpTimer();
                }
                hideResendText();
            }
            if (null != bank && !bank.permissionGranted) {
                manualOtpVisible();

            }
        } catch (Exception e) {
            if (null != e && null != e.getMessage())
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.CB_EXCEPTION, "enter_otp_" + e.getMessage());

        }
    }

    @Override
    public void backButton() {
        this.setCancelable(false);
        showCancelTxnOption();
    }

    private void showCancelTxnOption() {
        changeVisibility(CBConstant.UI_CANCEL_TRANSACTION);
    }

    @Override
    public void finish() {
        Log.d(TAG, "dismissing the BottomSheet");
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false);
        this.dismissAllowingStateLoss();
        clear();
    }

    /**
     * Retry OTP Event of JS
     *
     * @param params
     */
    @Override
    public void retryOtp(String params) {
        isSubmitOtpApiInProgress = false;
        this.setCancelable(true);
        this.params = params;
        manualOtpVisible();
        tvErrorMsg.setText(getString(R.string.cb_invalid_otp_please_try_again));
        tvErrorMsg.setVisibility(View.VISIBLE);

    }

    /**
     * When OTP fetched in CB
     *
     * @param otp, otp fetched by parser SDK.
     */
    @Override
    public void otpFetched(String otp) {
        if (null != bank)
            bank.otpFetched = otp;
        if (!isWaitTimeFinished) {
            // Will OTP Submit
            rlSubmittingOtpTapToPause.setVisibility(View.VISIBLE);
            rlManualOtpSubmit.setVisibility(View.GONE);
            waitingForOtp.setVisibility(View.GONE);
            rlCancelLayout.setVisibility(View.GONE);
            setOtpToEditText(otp);
            if (null != bank && bank.autoApprove) {
                if (null != mAnimator && !mAnimator.isRunning()) {
                    tvTitleText.setText(getString(R.string.cb_submitting_otp));
                    hideResendText();
                    SpannableString spannableStr = new SpannableString(String.format("%s %s - %s", getString(R.string.cb_payu_otp), otp, getString(R.string.cb_tap_to_pause)));
                    spannableStr.setSpan(new ForegroundColorSpan(ContextCompat.getColor(requireContext(), R.color.payu_cb_primary_color)), 4, 4 + otp.length(), Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
                    btnSubmittingOtpTapToPause.setText(spannableStr);
                    cancelCountDownTimer();
                    isUserPausedSubmitOtp = false;
                    mAnimator.start();
                }
            } else {
                manualOtpVisible();
                setOtpToEditText(otp);
            }
        } else {
            manualOtpVisible();
            setOtpToEditText(otp);
        }

    }

    private void hideResendText() {
        tvResendOtp.setVisibility(View.GONE);
    }

    private CountDownTimer countDownTimerForOtp;
    private long remainingTime = 0L;

    private void setOtpToEditText(String otp) {
        etEnterOtpEditTextSubmitOtp.setText(otp);
        etEnterOtpEditTextSubmitOtp.setSelection(etEnterOtpEditTextSubmitOtp.getText().length());

    }

    /**
     * Showing Wait timer...
     */
    private void showWaitOtpTimer() {
        isWaitTimeFinished = false;
        long WAIT_TIME_FOR_SMS;
        if (null != bank && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && bank.permissionGranted) {// while permission is denied we follow IOS flow and we will wait for 45 secs before showing regenerate layout
            WAIT_TIME_FOR_SMS = 45000;
        } else {
            WAIT_TIME_FOR_SMS = 30000;
        }

        remainingTime = WAIT_TIME_FOR_SMS;
        countDownTimerForOtp = new CountDownTimer(WAIT_TIME_FOR_SMS, 1000) {
            @SuppressLint("DefaultLocale")
            @Override
            public void onTick(long millisUntilFinished) {
                remainingTime = remainingTime - 1000;
                isWaitTimerRunning = true;
                if (isAdded()) {
                    if (null != bank)
                        bank.BOTTOM_SHEET_STATUS = CBConstant.WAITING_OTP;
                    tvWaitingForOtp.setText(String.format("%s %d SEC", getString(R.string.cb_payu_waiting_for_otp), millisUntilFinished / 1000));
                }
            }

            @Override
            public void onFinish() {
                if (isAdded()) {
                    isWaitTimeFinished = true;
                    isWaitTimerRunning = false;
                    manualOtpVisible();
                    disableSubmitOtpButton();

                }
            }
        };
        countDownTimerForOtp.start();

    }


    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.btnSubmitOtpManual) {
            if (null != getActivity() && !getActivity().isFinishing() && !getActivity().isDestroyed() && null != etEnterOtpEditTextSubmitOtp) {
                if (etEnterOtpEditTextSubmitOtp.getText().length() >= 4 && etEnterOtpEditTextSubmitOtp.getText().length() <= 8) {
                    if (null != bank) {
                        CBUtil.hideKeyboard(requireContext(), etEnterOtpEditTextSubmitOtp);
                        CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.APPROVED_OTP);
                        bank.logCBAnalytics(requireContext(), AnalyticsConstant.UI_CUSTOME_BROWSER_SUBMIT, AnalyticsConstant.UI_CB_SUBMIT, String.valueOf((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - Bank.time))));
                        submitOtpJs(etEnterOtpEditTextSubmitOtp.getText().toString());
                    }
                }
            }
        } else if (v.getId() == R.id.btnSubmittingOtpTapToPause) {
            isUserPausedSubmitOtp = true;
            mCurrentLevel = 0;
            if (null != mAnimator)
                mAnimator.cancel();
            manualOtpVisible();
            if (null != bank) {
                setOtpToEditText(bank.otpFetched);
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.TAP_TO_PAUSE);
            }
        } else if (v.getId() == R.id.tvNo) {

            if (isSubmitOtpApiInProgress) {
                loading(getString(R.string.cb_confirming_your_payment));
            } else {
                isUserPausedSubmitOtp = true;
                manualOtpVisible();
            }

        } else if (v.getId() == R.id.btnYes) {
            //Cancel Transaction
            if (null != bank) {
                bank.postToPaytxn();
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK);
                bank.onBackApproved();
                bank.stopListening();
            }
            finish();
            if (null != bank && bank.customBrowserConfig.isActionBarPresent() || requireActivity() instanceof CBActivity)
                requireActivity().finish();
        } else if (v.getId() == R.id.rlRegisterCardNotRegistered) {
            try {
                if (null != bank) {
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.REGISTER_CLICK);
                    bank.cbWebView.loadUrl("javascript:" + bank.mJS.getString(getString(R.string.cb_pin)));
                }
            } catch (JSONException e) {
                if (null != e && null != e.getMessage())
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.CB_EXCEPTION, "register_click_" + e.getMessage());
            }
        } else if (v.getId() == R.id.rlOtpCardNotRegistered) {
            if (null != bank) {
                bank.otpClicked();
            }

        } else if (v.getId() == R.id.rlOtpFaster) {
            if (null != bank)
                bank.otpClicked();

        } else if (v.getId() == R.id.tvResendOtp) {
            try {
                if (null != bank) {
                    enterOtp(params);
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.REGENERATE);
                    CBUtil.hideKeyboard(requireContext(), etEnterOtpEditTextSubmitOtp);
                    bank.mPassword = null;
                    bank.cbWebView.loadUrl("javascript:" + bank.mJS.getString(getString(R.string.cb_regen_otp)));
                    bank.isListenerAttached = false;//Reattach listener to again ask for permission
                    bank.permissionGranted = true;//Reset so that user knows that consent is working
                    bank.prepareSmsListener();

                    bank.otpFetched = "";
                    setOtpToEditText("");
                    bank.logCBAnalytics(requireContext(), AnalyticsConstant.UI_CUSTOME_BROWSER_RESEND, AnalyticsConstant.UI_CB_RESEND, String.valueOf((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - Bank.time))));
                }
            } catch (JSONException e) {
                if (null != e && null != e.getMessage())
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.CB_EXCEPTION, "resend_otp_click_" + e.getMessage());
            }

        } else if (v.getId() == R.id.rlPasswordFaster) {
            if (null != bank) {
                bank.pin_selected_flag = true;
                bank.approve_flag = true;
            }
            try {
                JSONObject jsonObject = new JSONObject(params);
                if (jsonObject.has(getString(R.string.cb_register)) && jsonObject.getBoolean(getString(R.string.cb_register))) { // Register user flow.

                    tvTitleText.setText(getString(R.string.cb_your_card_has_not_been_registered_for_pin));
                    changeVisibility(CBConstant.UI_FASTER_PASSWORD);
                    if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) {
                        rlOtpSectionForCardNotRegistered.setVisibility(View.GONE);
                    }
                } else {
                    loading(getString(R.string.cb_please_wait));
                    if (null != bank) {
                        CBUtil.logAnalytics(bank, CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PASSWORD);
                        bank.cbWebView.loadUrl("javascript:" + bank.mJS.getString(getString(R.string.cb_pin)));
                    }
                }
            } catch (JSONException e) {
                if (null != e && null != e.getMessage())
                    CBUtil.logAnalytics(bank, CBAnalyticsConstant.CB_EXCEPTION, "faster_password_click" + e.getMessage());

            }
        }
    }

    @Override
    public void onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
        mClipDrawable.setLevel(mCurrentLevel);
        int MAX_LEVEL = 10000;
        if (this.mCurrentLevel < MAX_LEVEL) {
            if (null != bank)
                bank.BOTTOM_SHEET_STATUS = CBConstant.AUTO_SUBMIT;
            int LEVEL_INCREMENT = 25;
            this.mCurrentLevel = RangesKt.coerceAtMost(MAX_LEVEL, this.mCurrentLevel + LEVEL_INCREMENT);
        } else {
            if (null != mAnimator)
                mAnimator.cancel();
        }
    }

    private void submitOtpJs(String otp) {
        try {
            if (null != otp && otp.length() >= 6 && otp.length() <= 8) {
                isSubmitOtpApiInProgress = true;
                loading(getString(R.string.cb_confirming_your_payment));
                if (null != bank)
                    bank.cbWebView.loadUrl("javascript:" + bank.mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + otp + "\")");
            }
        } catch (JSONException e) {
            if (null != e && null != e.getMessage())
                CBUtil.logAnalytics(bank, CBAnalyticsConstant.CB_EXCEPTION, "submit_otp_click_" + e.getMessage());
        }
    }

    public void clearReferences(){
        bank = null;
        cbBottomSheetEventListener = null;
    }

    @Override
    public void onDismiss(@NonNull DialogInterface dialog) {
        clearReferences();
        super.onDismiss(dialog);
    }
}
