package com.payu.custombrowser;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.payu.commonui.utils.CommonUIViewUtils;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.cbinterface.OnBackButtonListener;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import org.json.JSONException;

public class CBFragment extends Fragment implements OnBackButtonListener {

    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    CBUtil cbUtil;
    protected static View cbConfigProgressDialogView;

    private RelativeLayout cbActionBar;

    private CBFragment() {

    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        // TODO: provide support for saveInstance as well
        // To avoid recreating activity using saveInstanceState
        View cbInflatedView = inflater.inflate(R.layout.cb_payments_fragment, container, false);

        return cbInflatedView;

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        payUCustomBrowser = new Bank();
        cbUtil = new CBUtil();
        cbActionBar = view.findViewById(R.id.cbActionBar);
        // reset payuId when transaction is initiated to avoid old payuID

        Bundle bundle = getArguments();
        if (bundle != null) {
            customBrowserConfig = bundle.getParcelable(CBConstant.CB_CONFIG);
            if(customBrowserConfig != null) {
                CommonUIViewUtils.updateLayoutSecurity(requireActivity(), customBrowserConfig.isProtectedScreen());
                customBrowserConfig.setProgressDialogCustomView(cbConfigProgressDialogView);
                if (!customBrowserConfig.isActionBarPresent())
                    cbActionBar.setVisibility(View.GONE);
                cbUtil.resetPayuID(customBrowserConfig);
            } else {
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()
                        .onCBErrorReceived(CBConstant.errorCodes.MISSING_PARAMETER_EXCEPTION,
                                getString(R.string.custombrowserconfig_is_null));
                return;
            }
        }
        payUCustomBrowser.setArguments(bundle);
        initDrawer();

        view.setFocusableInTouchMode(true);
        view.requestFocus();
        view.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_BACK) {
                    onBackButtonClicked();
                    return false;
                }
                return false;
            }
        });
        requireActivity().getSupportFragmentManager().beginTransaction().add(R.id.main_frame, payUCustomBrowser).commitAllowingStateLoss();
//        new Bank().show(getSupportFragmentManager(), "Dialog");
//        payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.CB_ACTIVITY, CBAnalyticsConstant.LAUNCHED.toLowerCase());
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        if (customBrowserConfig != null)
            CommonUIViewUtils.updateLayoutSecurity(requireActivity(), customBrowserConfig.isProtectedScreen());
    }

    @Override
    public void onDetach() {
        super.onDetach();
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false);
    }

    public static CBFragment newInstance(Bundle bundle) {
        CBFragment fragment = new CBFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onBackButtonClicked() {
        if (customBrowserConfig != null && customBrowserConfig.getDisableBackButtonDialog() != 1) {
            if (payUCustomBrowser.isCbBottomSheetExpanded) {
                if (null != payUCustomBrowser.cbBottomSheet && payUCustomBrowser.cbBottomSheet.isAdded()) {
                    payUCustomBrowser.cbBottomSheet.backButton();
                } else {
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());
                    payUCustomBrowser.showBackButtonDialog();
                }

            } else {
                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());
                payUCustomBrowser.showBackButtonDialog();
            }
        } else {
            payUCustomBrowser.dismissCollapsedUI();
            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.MERCHANT_BACK_BUTTON_CLICK);
            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(null);
            //  CBFragment.this.finish();
        }
    }

    ///  @Override
//    public void onDestroy() {
////        if (backButtonAlertDialog != null && backButtonAlertDialog.isShowing()) {
////            backButtonAlertDialog.dismiss();
////            backButtonAlertDialog.cancel();
////        }
//        if (snoozeDialog != null && snoozeDialog.isShowing()) {
//            snoozeDialog.dismiss();
//            snoozeDialog.cancel();
//        }
//        STATE = CBConstant.STATE_DESTROYED;
//        if (payUCustomBrowser != null && payUCustomBrowser.getSnoozeLoaderView() != null) {
//            payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
//            //Memory Leak fix.Reset the snooze loader
//            payUCustomBrowser.setSnoozeLoaderView(null);
//        }
//
//        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
//            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
//            CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(null);
//        }
//        cbConfigProgressDialogView = null;
//        cbConfigToolbarView = null;
//        // if any notification from snooze service lets clear it.
//        NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
//        if (null != mNotificationManager)
//            mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);
//
//        // Remove slow user warning notification
//        mNotificationManager.cancel(63);
//
//        super.onDestroy();
//    }

    // Will be called from snoozeService, notification click
    // No need to show the Transaction Resumed window, we can directly resume the transaction.
    protected void onNewIntent(Intent intent) {
        //(new CBUtil()).clearCookie();


        if (null != intent && intent.getStringExtra(CBConstant.SENDER).contentEquals(CBConstant.SNOOZE_SERVICE)) { // it is from snooze service
            if (null != payUCustomBrowser) {
//                payUCustomBrowser.killSnoozeService();
//                payUCustomBrowser.dismissSnoozeWindow();
                // User has clicked notification, clear the snoozeNotificationIntent
                // we are using this, because onResume of Bank.java is being called again. which will launch snooze window based on the flags.
                payUCustomBrowser.snoozeNotificationIntent = null;
                payUCustomBrowser.isSnoozeNotificationLaunched = false;

                if (null != intent.getExtras() && intent.getExtras().getBoolean(CBConstant.VERIFICATION_MSG_RECEIVED)) { // backward journey

                    try {
                        String verifyApiStatus = cbUtil.getValueOfJSONKey(intent.getExtras().getString(CBConstant.PAYU_RESPONSE), getString(R.string.cb_snooze_verify_api_status));
                        // success transaction api status 1 and failure api status 0
                        if (verifyApiStatus != null && verifyApiStatus.equalsIgnoreCase(CBConstant.TRANSACTION_STATUS_SUCCESS)) {
                            // Logging notification click
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.TRANSACTION_VERIFIED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                        } else {
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                        }
                    } catch (JSONException e) {
                        Log.d(getClass().getSimpleName(), "Exception " + e.getMessage());
                    }

                    payUCustomBrowser.showTransactionStatusDialog(intent.getExtras().getString(CBConstant.PAYU_RESPONSE), true);


                } else { // forward journey.
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.INTERNET_RESTORED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                    payUCustomBrowser.resumeTransaction(intent);
                }
            }

        }
    }


    private void initDrawer() {
//        if (cbDrawerAdapter != null && customBrowserConfig.getCbDrawerCustomMenu() != 0) {
//            DrawerLayout mDrawerLayout = (DrawerLayout) findViewById(R.id.drawer_layout);
//            // Merchant need to pass this
//            ListView v = (ListView) getLayoutInflater().inflate(customBrowserConfig.getCbDrawerCustomMenu(), null, false);
//            // LinearLayout.LayoutParams lp=new LinearLayout.LayoutParams(280,LinearLayout.LayoutParams.MATCH_PARENT);
//
//            DrawerLayout.LayoutParams lp = new DrawerLayout.LayoutParams(
//                    LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
//            lp.gravity = Gravity.START;
//            if (v.getParent() != null) {
//                ((ViewGroup) v.getParent()).removeView(v);
//            }
//            mDrawerLayout.addView(v);
//            // ll.addView(v);
//            v.setLayoutParams(lp);
//
//            // Merchant need to pass adapter and listener
//            v.setAdapter(cbDrawerAdapter);
//
//            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getNavigationDrawerObject(mDrawerLayout);
//            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.CB_ACTIVITY, CBAnalyticsConstant.INITDRAWER);
//        }
    }
}
