package com.payu.custombrowser;

import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import org.json.JSONException;

public class CBActivity extends AppCompatActivity {

    protected static ArrayAdapter cbDrawerAdapter;
    public static int STATE;
    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    private androidx.appcompat.app.AlertDialog snoozeDialog;
    private AlertDialog backButtonAlertDialog;
    CBUtil cbUtil;
    protected static View cbConfigToolbarView;
    protected static View cbConfigProgressDialogView;

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
        STATE = CBConstant.STATE_RESUMED;
        // if there is sure pay notification we need to cancel it and resume the txn.
    }

    @Override
    protected void onPause() {
        super.onPause();
        STATE = CBConstant.STATE_PAUSED;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO: provide support for saveInstance as well
        // To avoid recreating activity using saveInstanceState
        super.onCreate(null);
        setContentView(R.layout.cb_payments);
        payUCustomBrowser = new Bank();
        cbUtil = new CBUtil();

        // reset payuId when transaction is initiated to avoid old payuID

        Bundle bundle = new Bundle();
        customBrowserConfig = getIntent().getParcelableExtra(CBConstant.CB_CONFIG);
        if(customBrowserConfig != null) {
            customBrowserConfig.setProgressDialogCustomView(cbConfigProgressDialogView);
            cbUtil.resetPayuID(customBrowserConfig);
            bundle.putParcelable(CBConstant.CB_CONFIG, customBrowserConfig);
        } else {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()
                    .onCBErrorReceived(CBConstant.errorCodes.MISSING_PARAMETER_EXCEPTION,
                            getString(R.string.custombrowserconfig_is_null));
            return;
        }
        payUCustomBrowser.setArguments(bundle);
        cbSetToolBar(cbConfigToolbarView);
        initDrawer();
        getSupportFragmentManager().beginTransaction().add(R.id.main_frame, payUCustomBrowser).commitAllowingStateLoss();
//        new Bank().show(getSupportFragmentManager(), "Dialog");
        payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.CB_ACTIVITY, CBAnalyticsConstant.LAUNCHED.toLowerCase());
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState, @NonNull PersistableBundle outPersistentState) {
        // removed super to fixe bug regarding saved instance
    }

    @Override
    public void onBackPressed() {
        if (customBrowserConfig != null && customBrowserConfig.getDisableBackButtonDialog() != 1) {
            if (payUCustomBrowser.isCbBottomSheetExpanded) {
                if (null != payUCustomBrowser.cbBottomSheet && payUCustomBrowser.cbBottomSheet.isAdded()) {
                    payUCustomBrowser.cbBottomSheet.backButton();
                } else {
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());
                    payUCustomBrowser.showBackButtonDialog();
                }

            } else {
                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());
                payUCustomBrowser.showBackButtonDialog();
            }
        } else {
            payUCustomBrowser.dismissCollapsedUI();
            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.MERCHANT_BACK_BUTTON_CLICK);
            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(null);
            CBActivity.this.finish();
        }
    }

    /**
     * CallBack for magic retry
     */
//    public void showMagicRetry() {
//        payUCustomBrowser.showMagicRetry();
//    }

    /**
     * CallBack for magic retry
     */
//    public void hideMagicRetry() {
//        payUCustomBrowser.hideMagicRetry();
//    }
    @Override
    public void onDestroy() {
        if (backButtonAlertDialog != null && backButtonAlertDialog.isShowing()) {
            backButtonAlertDialog.dismiss();
            backButtonAlertDialog.cancel();
        }
        if (snoozeDialog != null && snoozeDialog.isShowing()) {
            snoozeDialog.dismiss();
            snoozeDialog.cancel();
        }
        STATE = CBConstant.STATE_DESTROYED;
        if (payUCustomBrowser != null && payUCustomBrowser.getSnoozeLoaderView() != null) {
            payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
            //Memory Leak fix.Reset the snooze loader
            payUCustomBrowser.setSnoozeLoaderView(null);
        }

        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
            CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(null);
        }
        cbConfigProgressDialogView = null;
        cbConfigToolbarView = null;
        // if any notification from snooze service lets clear it.
        NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        if (null != mNotificationManager)
            mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);

        // Remove slow user warning notification
        mNotificationManager.cancel(63);

        super.onDestroy();
    }

    // Will be called from snoozeService, notification click
    // No need to show the Transaction Resumed window, we can directly resume the transaction.
    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        //(new CBUtil()).clearCookie();


        if (null != intent && intent.getStringExtra(CBConstant.SENDER).contentEquals(CBConstant.SNOOZE_SERVICE)) { // it is from snooze service
            if (null != payUCustomBrowser) {
//                payUCustomBrowser.killSnoozeService();
//                payUCustomBrowser.dismissSnoozeWindow();
                // User has clicked notification, clear the snoozeNotificationIntent
                // we are using this, because onResume of Bank.java is being called again. which will launch snooze window based on the flags.
                payUCustomBrowser.snoozeNotificationIntent = null;
                payUCustomBrowser.isSnoozeNotificationLaunched = false;

                if (null != intent.getExtras() && intent.getExtras().getBoolean(CBConstant.VERIFICATION_MSG_RECEIVED)) { // backward journey

                    try {
                        String verifyApiStatus = cbUtil.getValueOfJSONKey(intent.getExtras().getString(CBConstant.PAYU_RESPONSE), getString(R.string.cb_snooze_verify_api_status));
                        // success transaction api status 1 and failure api status 0
                        if (verifyApiStatus != null && verifyApiStatus.equalsIgnoreCase(CBConstant.TRANSACTION_STATUS_SUCCESS)) {
                            // Logging notification click
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.TRANSACTION_VERIFIED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                        } else {
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                        }
                    } catch (JSONException e) {
                        Log.d(getClass().getSimpleName(), "Exception " + e.getMessage());
                    }

                    payUCustomBrowser.showTransactionStatusDialog(intent.getExtras().getString(CBConstant.PAYU_RESPONSE), true);


                } else { // forward journey.
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.INTERNET_RESTORED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                    payUCustomBrowser.resumeTransaction(intent);
                }
            }

        }
    }

    public void cbSetToolBar(View resView) {
        if (resView != null && null != getSupportActionBar()) {
            getSupportActionBar().setDisplayShowTitleEnabled(false);
            // View v = getLayoutInflater().inflate(resView, null);
            if (resView.getParent() != null) {
                ((ViewGroup) resView.getParent()).removeView(resView); // <- fix
            }
            getSupportActionBar().setCustomView(resView, new ActionBar.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
            getSupportActionBar().setDisplayShowCustomEnabled(true);
            // getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            // getSupportActionBar().setHomeButtonEnabled(true);
            Toolbar toolbar = (Toolbar) resView.getParent();
            toolbar.setContentInsetsAbsolute(0, 0);
        } else {
            if (null != getSupportActionBar()) {
                getSupportActionBar().hide();
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        for (Fragment fragment : getSupportFragmentManager().getFragments()) {
            fragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        for (Fragment fragment : getSupportFragmentManager().getFragments()) {
            fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private void initDrawer() {
        if (cbDrawerAdapter != null && customBrowserConfig.getCbDrawerCustomMenu() != 0) {
            DrawerLayout mDrawerLayout = (DrawerLayout) findViewById(R.id.drawer_layout);
            // Merchant need to pass this
            ListView v = (ListView) getLayoutInflater().inflate(customBrowserConfig.getCbDrawerCustomMenu(), null, false);
            // LinearLayout.LayoutParams lp=new LinearLayout.LayoutParams(280,LinearLayout.LayoutParams.MATCH_PARENT);

            DrawerLayout.LayoutParams lp = new DrawerLayout.LayoutParams(
                    LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
            lp.gravity = Gravity.START;
            if (v.getParent() != null) {
                ((ViewGroup) v.getParent()).removeView(v);
            }
            mDrawerLayout.addView(v);
            // ll.addView(v);
            v.setLayoutParams(lp);

            // Merchant need to pass adapter and listener
            v.setAdapter(cbDrawerAdapter);

            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getNavigationDrawerObject(mDrawerLayout);
            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.CB_ACTIVITY, CBAnalyticsConstant.INITDRAWER);
        }
    }
}
