// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import static com.payu.custombrowser.util.CBConstant.errorCodes.SSL_ERROR;

import android.Manifest;
import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;

import com.payu.commonui.view.customViews.UserCancellationFeedbackBottomSheet;
import com.payu.custombrowser.AnalyticsHandler.AnalyticsConstant;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.MissingParamException;
import com.payu.custombrowser.util.TLSSocketFactory;
import com.payu.custombrowser.widgets.SnoozeLoaderView;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HttpsURLConnection;


/**
 * Custom browser's Fragment.
 * Keeping it as abstract for providing call back function to implementing Activities.
 * Following functions needs to be overridden.
 * {@link Bank#registerBroadcast(BroadcastReceiver, IntentFilter)}}
 * {@link Bank#unregisterBroadcast(BroadcastReceiver)}
 * {@link Bank#onHelpAvailable()}
 * {@link Bank#onHelpUnavailable()}
 * {@link Bank#onBankError()}
 */

public class Bank extends PayUCBLifecycle {

    private final String TAG = this.getClass().getSimpleName();

    //CB version
    public static String Version = BuildConfig.VERSION_NAME;
    // making it public because cbConfig need to access this.
    public static String keyAnalytics;
    public static String transactionID;
    static String paymentMode;
    static String paymentType;
    static String bankcode;
    static String amount;
    static String screenType;
    static long time = 0;
    static String sdkVersion;
    private static final List<String> whiteListedUrls = new ArrayList<>();
    private android.app.AlertDialog alertDialog;

    static {
        Version = BuildConfig.VERSION_NAME;
    }

    // Time at snooze button clicked
    public long snoozeClickedTime;
    // Runnable for wait for OTP waitingOTPTimer
    Runnable enterOtpRunnable;
    // Current loading progress of the webview
    private int currentLoadingProgress;
    // Count down waitingOTPTimer to detect slow connection with the help of LOADING THRESHOLD and TIME INTERVAL
    private CountDownTimer mCountDownTimer = null;
    // Flag keeps track of snooze status.
    private boolean isSnoozeTimerRunning = false;
    // Flag tells page loading is stopped by clicking snooze window.
    private boolean isPageStoppedForcefully = false;
    /*    // Time at snooze window dismissed.
        private long snoozeWindowDismissTime;*/
    // Check for backward journey
    //private boolean backwardJourneyTransactionStarted;
    //snooze laoder(3- bar loader)
    private SnoozeLoaderView snoozeLoaderView;
    // false when onPageFinished  called second time
    private boolean firstFinish = true;
    //check for loading mJS only once
    private boolean mLoadingJS = false;
    //check for, should save user ID
    private boolean saveUserIDCheck = true;
    // make sure checkvisibility(dynamic CB) is called only once.
    private boolean visibilitychecked;
    // private boolean isBankFound;
    //check for HDFC bank as enterOTP is called twice
    //private int c_hdfc = 0;
    //Android M handling permission check
    //private String merchantHash;
    // MR integration
//    private boolean isMRDataSet = false;

    //check for first time finish call
    //private boolean firstFinish = true;
    // checkBox status for NB(checkbox - (enable or disable) save user ID)
    private boolean showToggleCheck;
    //input bundle
    // private Bundle bundle;
    // Timer to disable PayUChromeLoader after some threshold time has elapsed
    private CountDownTimer payUChromeLoaderDisableTimer;
    // @deprecated Timer to enable PayUChromeLoader after some threshold time has elapsed
    private CountDownTimer payUChromeLoaderEnableTimer;
    private boolean showSnoozeWindow = true;
    // check for first url loaded in webpagestart
    private boolean isFirstURLLoaded;
    // Flag to monitor page started and finished.
    private boolean pageStarted = false;
    private boolean webpageNotFoundError = false;
    private boolean stopOnlyOnce;
    private boolean cAJSVisibilityCalled = false;
    // Holds the value of sure pay resume url, if the url is not null onPageFinished, log analytics.
    private boolean isSurePayResumed = false;
    private android.app.AlertDialog dialog;
    private final boolean waitingOtpTimerExpired = false;
    private boolean mIsPaused;
    private String requestedToastMessage;


    // REQUIRED: Public no-argument constructor
    // Android needs this to recreate fragments when restoring state
    public Bank() {
        // Required empty constructor
        // Do not put initialization code here!
    }



    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // Initialize everything here instead of in the constructor
        this.activity = requireActivity(); // Get the activity

        showToggleCheck = false; // Checkbox status for netbanking
        backwardJourneyUrls = new HashSet<>();
        serialExecutor = Executors.newCachedThreadPool();
        retryUrls = new HashSet<>();
        returnJourneyPgResponseList = new HashSet<>();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        cbBottomSheet = new CbBottomSheet(this, this);
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Activity) {
            activity = (Activity) context;
            cbUtil = new CBUtil();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        mIsPaused = true;
    }

    @Override
    public void onStart() {
        super.onStart();
        mIsPaused = false;
        if (requestedToastMessage != null) {
            Toast.makeText(activity.getApplicationContext(), requestedToastMessage, Toast.LENGTH_SHORT).show();
            requestedToastMessage = null;
        }
    }

    /**
     * Check if currentUrl is a white listed url
     *
     * @param currentUrl
     * @return TRUE / FALSE
     */
    public static boolean isUrlWhiteListed(String currentUrl) {

        // Check if url contain (mobiltest.payu.in or payu.secure.in ) and response
        // payuresponse url support reposting so addin in whitelisted url
        if ((currentUrl.contains(CBConstant.PAYU_DOMAIN_PROD) || currentUrl.contains(CBConstant.PAYU_DOMAIN_TEST)) && currentUrl.contains(CBConstant.RESPONSE_BACKWARD)) {
            return true;
        }
        // TODO : isWhiteListed check needs to be implemented.
        for (String whiteListedUrl : whiteListedUrls) {
            if (currentUrl.contains(whiteListedUrl)) {
                return true;
            }
        }
        return false;
    }


    // getter for loader
    public SnoozeLoaderView getSnoozeLoaderView() {
        return snoozeLoaderView;
    }

    public void setSnoozeLoaderView(SnoozeLoaderView snoozeLoaderView) {
        this.snoozeLoaderView = snoozeLoaderView;
    }

    public String getPageType() {
        return pageType;
    }

    /**
     * if the currentUrl is not supported to be resumed, post the data to
     *
     * @param url        url to be loaded
     * @param postParams post data
     */
    public void reloadWebView(String url, String postParams) {
        // Reset PayUChromeLoader flags
        forwardJourneyForChromeLoaderIsComplete = false;
        backwardJourneyStarted = false;
        isWebviewReloading = true;

//        registerSMSBroadcast();
        backwardJourneyStarted = false;
//        if (null != snoozeService) {
//            snoozeService.killSnoozeService();
//        }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();
        }
        if (progressDialog != null) {
            progressDialog.dismiss();
        }
        if (isAdded() && null != flFullScreenLoader)
//        flFullScreenLoader.setVisibility(View.GONE);
            progressDialog = null;


        setSurePayResumeStatus(true);
        //addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, url);
        // reset value of auto select OTP to value set by merchant
        resetAutoSelectOTP();
        cbUtil.resetPayuID(customBrowserConfig);
        surePayS2SPayUId = null;
        if (url != null && postParams != null) {
            cbWebView.postUrl(url, postParams.getBytes());
        } else if (url != null) {
            cbWebView.loadUrl(url);
        }
    }

//    public void killSnoozeService() {
//        if (null != snoozeService) {
//            snoozeService.killSnoozeService();
//        }
//    }

    /**
     * reload webview
     */
    public void reloadWebView() {
//        if (null != snoozeService) {
//            snoozeService.killSnoozeService();
//        }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();
        }
//        registerSMSBroadcast();
        isWebviewReloading = true;
        // webview.reload does not invoke onPageStarted
        // lets initialize snoozecounter again.
        if (isSnoozeEnabled) {
            initializeSnoozeTimer();
        }
        if (cbWebView.getUrl() != null) {
            setSurePayResumeStatus(true);
            // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
            if (19 == Build.VERSION.SDK_INT) { // reload webview using js breaks in KITKAT
                cbWebView.reload();
            } else {
                reloadWVNative();
            }
        }
    }

    /**
     * @param resumeUrl Used only for analytics
     */
    public void reloadWebView(String resumeUrl) {
//        if (null != snoozeService) {
//            snoozeService.killSnoozeService();
//        }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();
        }
//        registerSMSBroadcast();
        isWebviewReloading = true;
        // webview.reload does not invoke onPageStarted
        // lets initialize snoozecounter again.
        if (isSnoozeEnabled) {
            initializeSnoozeTimer();
        }

        if (cbWebView.getUrl() != null) {
            setSurePayResumeStatus(true);
            // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, resumeUrl);
            if (19 == Build.VERSION.SDK_INT) { // reload webview using js breaks in KITKAT
                cbWebView.reload();
            } else {
                reloadWVUsingJS();
            }
        } else {// This case comes some times on _payment url. if this happen we post the data again to url.
            reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
        }
    }

    /***
     * Return the bank name received from JS
     *
     * @return Bank name recieved from JS
     */
    public String getBankName() {
        if (bankName == null)
            return "";
        return bankName;
    }

    /**
     * This method checks permission to read SMS for androidM and above
     */
    private void checkPermission() {//this method checks permission to read SMS for androidM and above
        //  if (!checkedPermission) { // this is to check if this method was called before.

        if (!checkedPermission && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && merchantSMSPermission) {
            checkedPermission = true;
            if (ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) != PackageManager.PERMISSION_GRANTED) {// this checks if we have permission to receive sms or not,
//                requestPermissions(new String[]{Manifest.permission.RECEIVE_SMS}, 1); // if we dont have permission we request permission
                checkPermissionVisibility = true;
            } else {
                permissionGranted = true;
                if (SMSOTPClicked) {
                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        if (null != e && null != e.getMessage())
                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "checkPermission_je_" + e.getMessage());
                    } catch (Exception e) {
                        if (null != e && null != e.getMessage())
                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "checkPermission_" + e.getMessage());
                    }
                }
            }
        } else {
            onHelpAvailable();
//            permissionGranted = ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) == PackageManager.PERMISSION_GRANTED;

            if (SMSOTPClicked) {
                try {
                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                } catch (JSONException e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "checkPermission_m_je_" + e.getMessage());
                } catch (Exception e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "checkPermission_m_" + e.getMessage());
                }
            }
        }

    }

    /**
     * Callback from custombrowser tells the bank.java to show or hide the custom browser.
     *
     * @param showCustomBrowser enable or disbale custom browser
     */
    @JavascriptInterface
    public void showCustomBrowser(final boolean showCustomBrowser) {
        showCB = showCustomBrowser;
        if (getActivity() != null && !getActivity().isFinishing()) {
            getActivity().runOnUiThread(() -> {
                if (!showCustomBrowser) {
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    try {
                        if (cbSlideBarView != null)
                            cbSlideBarView.setVisibility(View.GONE);
                        onHelpUnavailable();
                    } catch (Exception e) {
                        if (null != e && null != e.getMessage())
                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "showCustomBrowser_" + e.getMessage());
                    }
                }
            });
        }
    }

//    @JavascriptInterface
//    public void setMRData(String data) {
//        if (!isMRDataSet) {
//            // TODO MR.setMRData will eventually phase out, only CBUtil.updateRetryData will be used
//            // Store the Magic retry setting in shared preference
//            MagicRetryFragment.setMRData(data, getActivity().getApplicationContext());
//            updateWhitelistedRetryUrls(CBUtil.updateRetryData(data, getActivity().getApplicationContext()));
//
//            isMRDataSet = true;
//        }
//    }

    /**
     * Dismiss error page
     */
    public void onOverrideURL(String url) {
    }

    /**
     * Launch sure pay in FAIL MODE
     */
    private void snoozeOnReceivedError() {
        setIsPageStoppedForcefully(true);
        // Disable snooze if url is in snoozeConfigMap
        // if(null != snoozeConfigMap && !snoozeConfigMap.containsKey(webviewUrl)) {
        //    launchSnoozeWindow(CBConstant.FAIL_MODE);
        // }

        if (null != snoozeConfigMap) {
            // In some cases webview life cycle can be onPageStart -> onReceiveError -> onPageFinish
            // if there is a snoozeCountDownTimer running kill it.
            stopSnoozeCountDownTimer();
            surePayDisableStatus = cbUtil.getSurePayDisableStatus(snoozeConfigMap, webviewUrl);
            launchSnoozeWindow(FAIL_MODE);
        }
    }


    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String logMsg = (error == null ? "" : error) + "|" + (view.getUrl() == null ? "" : view.getUrl());
        addErrorData(CBAnalyticsConstant.SSL_ERROR, logMsg);
        Log.d("Bank", "communicationError onReceivedSslError" + logMsg);
        communicationError();
    }

    void confirmationDialogForSslError(SslErrorHandler handler, String errorReason) {
        android.app.AlertDialog alertDialog;
        DialogInterface.OnClickListener onClickListener = (dialogInterface, i) -> {
            if (i == -1) {
                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_CONFIRM_SSL_DIALOG);
                handler.proceed();
            } else if (i == -2) {
                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_CANCEL_SSL_DIALOG);
                dialogInterface.dismiss();
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onCBErrorReceived(SSL_ERROR, errorReason);

            }
        };
        if (isAdded()) {
            android.app.AlertDialog.Builder builder = CBUtil.getAlertDialog(getActivity(), onClickListener, getString(R.string.cb_dialog_continue), getString(R.string.cb_dialog_cancel), null, errorReason + " " + getString(R.string.cb_dialog_would_you_like_to_continue));
            alertDialog = builder.create();
            alertDialog.show();
        }
    }

    public boolean retryCancellationHandler() {
        postToPaytxn();
        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_CANCEL_RETRY_DIALOG);
        onBackApproved();
        HashMap<String, String> postParams = new CBUtil().getDataFromPostData(customBrowserConfig.getPayuPostData());
        Bank.amount = postParams.get(CBConstant.AMOUNT);
        Bank.transactionID = postParams.get(CBConstant.TXN_ID);
        if (customBrowserConfig.isActionBarPresent())
            activity.finish();
        return true;
    }


    //TODO: Shah: move this to Util
    public void internetErrorHandler(int errorCode, String errorDesc) {
        addEventAnalytics(CBAnalyticsConstant.NO_INTERNET_FOUND, errorCode + ":" + errorDesc);

        DialogInterface.OnClickListener onClickListener = (dialogInterface, i) -> {

            if (i == DialogInterface.BUTTON_POSITIVE) {
                if (CBUtil.isNetworkAvailable(activity)) {
                    dialogInterface.dismiss();
                    alertDialog = null;
                    if (errorCode != 0) {
                        //Error code 0 is sent from the code when user click on retry on already
                        // loaded page to not load it again
                        reloadWebViewUrl();
                    }
                } else {
                    dialogInterface.dismiss();
                    alertDialog = null;
                    internetErrorHandler(errorCode, errorDesc);
                }
            } else {
                dialogInterface.dismiss();
                alertDialog = null;
            }

        };

        if (alertDialog == null) {
            android.app.AlertDialog.Builder builder = CBUtil.getAlertDialog(
                    activity,
                    onClickListener,
                    getString(R.string.cb_retry_transaction),
                    getString(R.string.cb_dialog_dismiss),
                    null,
                    getString(R.string.payu_cb_no_internet_connection)
            );
            alertDialog = builder.create();
            alertDialog.setCancelable(false);
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        }
    }

    /**
     * Custom browser shows the error page.
     *
     * @param errorCode   error code received by dvm for the error
     * @param description description about the error
     */
    public void onReceivedErrorWebClient(int errorCode, String description) {
        String logMsg = errorCode + "|" + (description == null ? "" : description) + "|"
                + (cbWebView.getUrl() == null ? "" : cbWebView.getUrl());
        addErrorData(CBAnalyticsConstant.ERROR_RECEIVED, logMsg);
        Log.d("Bank", "communicationError onReceivedErrorWebClient " + logMsg);
        communicationError();

        if (cbWebPageProgressBar != null) {
            cbWebPageProgressBar.dismiss();
            //    cbWebPageProgressBar.setProgress(0);
        }

        webpageNotFoundError = true;
        try {
            if (getActivity() != null && !getActivity().isFinishing()) {

                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    /*if(backwardJourneyTransactionStarted && isTxnNBType){
                        launchSnoozeWindow();
                    }*/
                    if (!backwardJourneyStarted) {
                        snoozeOnReceivedError();
                    } else if (backwardJourneyStarted && isTxnNBType && snoozeCountBackwardJourney < customBrowserConfig.getEnableSurePay()) {
                        dismissSnoozeWindow();
                        snoozeOnReceivedError();

                    }
                    onHelpUnavailable();
                    cbBaseView.removeAllViews();
                    // maximize cb webview height, if calculated maximum WebView height is greater than 0
                    if (maxWebview != 0) {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                    }
                    hideCB();
                    dismissCb();
                    if (!cbOldFlow)
                        CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onCBErrorReceived(errorCode, description);

                    /* old progressBarVisibilityPayuChrome(View.GONE);*/
                }
            }
        } catch (Exception e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "onReceivedErrorWebClient_" + e.getMessage());
        }
    }

    // MR Integration
//    private void showMagicRetryCB() {
//        try {
//            cbWebView.loadUrl("javascript:" + mBankJS.getString("getMagicRetryUrls") + "('" + Bank.keyAnalytics + "')");
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }

    /**
     * update progress bar according to progress recieved
     *
     * @param progress percentage completion of loading url
     */

    public void onProgressChanged(int progress) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (cbWebPageProgressBar != null && this.isVisible()) {
                cbWebPageProgressBar.show();
                // progressBar.setProgress(progress);

                if (progress == 100) {
                    Handler handler = new Handler();
                    handler.postDelayed(() -> {
                        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded() && cbWebPageProgressBar != null && this.isVisible()) {
                            cbWebPageProgressBar.dismiss();
                            //     cbWebPageProgressBar.setProgress(0);
                            lastProgress = 0;
                        }
                    }, 100);
                } else {
                    startAnimation(progress);
                }
            }
        }
    }


    /**
     * Initialize snooze waitingOTPTimer,
     */
    private void initializeSnoozeTimer() {
        // if merchant opted for snooze
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null && customBrowserConfig != null) {
            if (cbUtil.getBooleanSharedPreferenceDefaultTrue(SNOOZE_ENABLED, activity.getApplicationContext()) && customBrowserConfig.getEnableSurePay() > snoozeCount) {
                // a page has been started, lets start snoozeCountDownTimer and stop snoozer if its running already.
                if (isSnoozeTimerRunning) {
                    stopSnoozeCountDownTimer();
                }
                startSnoozeCountDownTimer();
            }
        }
    }

    public void onPageStartedWebclient(String url) {
        CBUtil.currentUrl = url;
        CBUtil.currentUrlStatus = CBAnalyticsConstant.LOADING;
        if (isInBackWardJourney(url)) {
            hideCB();
            dismissCb();
        }

        pageStarted = true;
        // page is started setting forcefully stopped to false;
        isPageStoppedForcefully = false;

        // Special case for jelly bean where in case of onReceivedError the flow is onPageStarted->onReceivedError->OnPageStarted
        // here, if webpageNotFoundError = true then it means that it is coming from onReceivedError and hence
        // we can do custom things we needed to do for JELLYBEAN in case of onReceivedError and which get reset in onPageStarted

        // Setting flag, webpage not found error is no more
        webpageNotFoundError = false;

        // Dismiss slow user warning waitingOTPTimer, if any
        dismissSlowUserWarning();

        // check if PayU PG is used for making payment, as Backward journey for snooze will only work if PayU PG is used for making payment
        if (!payuPG && (url != null) &&
                (((DEBUG) ? url.equalsIgnoreCase(TEST_PAYMENT_URL) : url.equalsIgnoreCase(PRODUCTION_PAYMENT_URL))
                        || ((DEBUG) ? url.equalsIgnoreCase(TEST_PAYMENT_URL_SEAMLESS) : url.equalsIgnoreCase(PRODUCTION_PAYMENT_URL_SEAMLESS)))) {
            payuPG = true;
        }

        if (!isFirstURLLoaded) {
            // add post URL and post data to config of custom browser from callback
            if (customBrowserConfig != null && customBrowserConfig.getPayuPostData() == null && customBrowserConfig.getPostURL() == null && customBrowserConfig.getHtmlData() == null && customBrowserConfig.getSurepayS2Surl() == null) {
                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostData() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostURL() != null) {
                    customBrowserConfig.setPayuPostData(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostData());
                    customBrowserConfig.setPostURL(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostURL());

                    // deleting payment related details from callback class
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setPostURL(null);
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setPostData(null);

                } else {
                    // throw runtime exception if post data or post url is missing or (post url is not equal to first url loaded by merchant)
                    throw new MissingParamException("POST Data or POST URL Missing or wrong POST URL or HTML Data missing");
                }
            }
            //In case of S2S html support isTxnNBType is set by JS in surepayData
            if (customBrowserConfig != null && customBrowserConfig.getPayuPostData() != null && !isS2SHtmlSupport) {
                isTxnNBType = checkIfTransactionNBType(customBrowserConfig.getPayuPostData());
            }
            // set first load to true after first load
            isFirstURLLoaded = true;
        }

        showSnoozeWindow = true;

        if (pageType != null && !pageType.equalsIgnoreCase("")) {
            // timeOfDeparture = getSystemCurrentTime();
            addEventAnalytics(CBAnalyticsConstant.DEPARTURE, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
            pageType = "";
        }

        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            cbUtil.setStringSharedPreferenceLastURL(activity.getApplicationContext(), CBAnalyticsConstant.LAST_URL, "s:" + url);


            // DISMISS previous PayUChromeLoader Timer
            if (payUChromeLoaderDisableTimer != null) {
                payUChromeLoaderDisableTimer.cancel();
            }

            if (cbWebPageProgressBar != null && this.isVisible()) {
                cbWebPageProgressBar.show();
            }

            backwardJourneyStarted = isInBackWardJourney(url);

            // Only show payuChromeLoader in:
            // 1) Forward journey
            // 2) Backward journey
            // Note: Loader should not appear while user is interacting with the bank page
            if (!forwardJourneyForChromeLoaderIsComplete || backwardJourneyStarted) {
                progressBarVisibilityPayuChrome(View.VISIBLE, url);

            }

            // ################################################################################ //
            // Not using only url as it does not gives correct url in case browser history
            // is changed using JS. e.g. paytxn being inserted by PayU.
            // Using cbWebView.getUrl() instead to get correct url being loaded
            // webviewUrl = url;
            webviewUrl = (cbWebView.getUrl() == null || cbWebView.getUrl().equalsIgnoreCase("")) ? url : cbWebView.getUrl();
            // ################################################################################ //

            // check  from backward journer started
            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                // check for confirm transaction - to avoid looping again
                //   if (!backwardJourneyStarted) {
                // backwardJourneyUrls - list of backward journey url (backward journey PG url + backward journey PayU url)
                if (backwardJourneyStarted) {
                    //      backwardJourneyStarted = true;// check for backward journey
                    if (isTxnNBType) {
                        isSnoozeWindowVisible = false; // snooze dialog visiblility is set false so that backward journey snooze dialog can overrite forward one if it is appearing
                    } else {
                        dismissSnoozeWindow();
                    }
                    //bindService();
                }
                //  }

                // checkValue is retry URL of payu
                // dismiss payu dialog if retry screen loading
                /*if (checkValue != null && url.contains(checkValue)) {
                    update();
                }*/
                // Initialize snooze counter.

                // check the url loaded , dismiss snooze dialog if it is 'surl' and 'furl' -
                // 'frl' and 'surl' is from payment postdata
                // 'furl' and 'surl' loading means payment is either success or failure so no need to call verify API
                if (url.contains(Bank.DEBUG ? PAYMENT_OPTION_URL_DEV : PAYMENT_OPTION_URL_PROD)) {
                    mJS = null;
                    // we need the drawable for the new bank
                    drawable = null;
                }

                try {
                    if (null != customBrowserConfig) {
                        if (((customBrowserConfig.getPayuPostData() != null) && ((!cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.SURL).equals("") &&
                                url.contains(URLDecoder.decode(cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.SURL), "UTF-8"))) ||
                                (!cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.FURL).equals("") &&
                                        url.contains(URLDecoder.decode(cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.FURL), "UTF-8"))) ||
                                isRetryURL(url))) || (isS2SHtmlSupport && isRetryURL(url))) {

                            showSnoozeWindow = false;
                            dismissSnoozeWindow();
                            hideCB();
                            dismissCb();
                            if (isRetryURL(url)) {
                                // reset value of auto select OTP to value set by merchant
                                resetAutoSelectOTP();
                                //Reset value of previous txn otp
                                backupOfOTP = null;
                                mPassword = null;
                                backwardJourneyStarted = false;
                            }
                            stopSnoozeCountDownTimer();
                            //  backwardJourneyStarted = false;
//                            if (null != snoozeService) {
//                                // kill snooze service if it is running
//
//                                snoozeService.killSnoozeService();
//                            }
                            // initializeSnoozeTimer();

                        } else {
                            // in case of warn mode only we show the snooze window.
                            // in case of fail mode we launch snooze window at only on Error received.
                            if (isSnoozeEnabled && customBrowserConfig.getSurePayMode() == WARN_MODE) {
                                // TODO: move this isSnoozeEnabled flag to other place where we check other snozoe flags.
                                // TODO : here we re-assign the dynamic snooze config values based on the url
                                if (!backwardJourneyStarted) {
                                    snoozeLoadPercentageAndTimeOut = snoozeConfigMap.getPercentageAndTimeout(url);
                                    snoozeUrlLoadingPercentage = snoozeLoadPercentageAndTimeOut[0];
                                    snoozeUrlLoadingTimeout = snoozeLoadPercentageAndTimeOut[1];
                                    surePayDisableStatus = cbUtil.getSurePayDisableStatus(snoozeConfigMap, url);

                                    // snoozeUrlLoadingPercentage=100;
                                    // snoozeUrlLoadingTimeout=1;

                                    initializeSnoozeTimer();
                                }
                            }
                        }
                    }
                } catch (UnsupportedEncodingException e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "onPageStartedWebclient_" + e.getMessage());
                }
            }
        }
        // For testing backward journey sure pay
       /*if(!stopOnlyOnce && backwardJourneyStarted && isTxnNBType){
            stopOnlyOnce=true;
            stopWIFI();
       }*/
    }

    /*public void stopWIFI(){
      WifiManager wifiManager = (WifiManager)activity.getSystemService(Context.WIFI_SERVICE);
      wifiManager.setWifiEnabled(false);
    }*/

    /**
     * Special method for JellyBean onReceivedError,
     * anything to be done in case of onReceivedError
     * for Jellybean devices can be done here
     */
    private void jellyBeanOnReceivedError() {
        setIsPageStoppedForcefully(true);

        // taking care of jelly bean onReceive error in case of surepay file mode.
        if (null != snoozeConfigMap && !cbOldFlow) {
            // In some cases webview life cycle can be onPageStart -> onReceiveError -> onPageFinish
            // if there is a snoozeCountDownTimer running kill it.
            stopSnoozeCountDownTimer();
            surePayDisableStatus = cbUtil.getSurePayDisableStatus(snoozeConfigMap, webviewUrl);
            launchSnoozeWindow(FAIL_MODE);
        }
    }


    /**
     * If url is in backw
     * <p/>
     * ardJourneyUrls, mark as backward journey
     *
     * @param url
     * @return TRUE if url is in the list, FALSE otherwise
     */
    public boolean isInBackWardJourney(String url) {

        try {
            if (!backwardJourneyStarted) {
                if ((url.startsWith(CBConstant.PAYU_DOMAIN_PROD) || url.startsWith(CBConstant.PAYU_DOMAIN_TEST)) && isReturnJourneyPgResponse(url)) {
                    return true;
                }
                if (backwardJourneyUrls != null) {
                    for (String backwardJourneyUrl : backwardJourneyUrls) {
                        if (url.contains(backwardJourneyUrl)) {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return backwardJourneyStarted;
        } catch (Exception e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "isInBackWardJourney_" + e.getMessage());
            return backwardJourneyStarted;
        }
    }

    /**
     * Call back function from {@link PayUWebViewClient#onLoadResource(WebView, String)}
     *
     * @param view instance of cbWebView
     * @param url  resourse url which  is loading
     */
    public void onLoadResourse(WebView view, String url) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (url.equalsIgnoreCase(rupeeURL) || url.contains(rupeeURL1) || url.contains(rupeeURL2)) {
                /* old progressBarVisibilityPayuChrome(View.GONE); */
                //checkProgress = DURING_PAYMENT;
            }
        }
    }

    /**
     * Function which provides hidden input fields in json format from HTML received
     * via S2S flow.
     *
     * @param jsonData
     */
    @JavascriptInterface
    public void surePayData(String jsonData) {

        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            if (jsonObject.has(CBConstant.S2SPAYUID)) {
                surePayS2SPayUId = jsonObject.getString(CBConstant.S2SPAYUID);
            }
            if (jsonObject.has(CBConstant.S2SREPLAYURL) && jsonObject.has(CBConstant.SNOOZE_COUNT)
                    && jsonObject.has(CBConstant.TXN_TYPE)
                    && jsonObject.has(CBConstant.MERCHANTKEY)
                    && jsonObject.has(CBConstant.TXNID)
            ) {
                surePayS2Surl = jsonObject.getString(CBConstant.S2SREPLAYURL);
                merchantKey = jsonObject.getString(CBConstant.MERCHANTKEY);
                txnId = jsonObject.getString(CBConstant.TXNID);
                txnType = jsonObject.getString(CBConstant.TXN_TYPE);
                isTxnNBType = txnType.equalsIgnoreCase("NB");
                customBrowserConfig.setEnableSurePay(Integer.parseInt(jsonObject.getString(CBConstant.SNOOZE_COUNT)));
                isSurePayValueLoaded = true;
            }
        } catch (JSONException e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "surePayData_" + e.getMessage());
        }
    }


    /**
     * method is called from JS to dismiss review order screen nd horizontal bar
     */
    @JavascriptInterface
    public void dismissReviewOrder() {

    }


    /**
     * Call back function from {@link PayUWebViewClient#onPageFinished(WebView, String)}
     * It takes care keyboard open issue and dissmiss the payu dialog.
     *
     * @param url - finish url
     */
    public void onPageFinishWebclient(String url) {
        CBUtil.currentUrl = url;
        CBUtil.currentUrlStatus = CBAnalyticsConstant.LOADED;
        //  maximiseWebviewHeight();
        pageStarted = false;

        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {

            // We have successfully resumed an url from snooze - lets log it.
            if (isSurePayResumed) {
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, url);
                setSurePayResumeStatus(false);
            }

            cbUtil.setStringSharedPreferenceLastURL(activity.getApplicationContext(), CBAnalyticsConstant.LAST_URL, "f:" + url);
            // progressBarVisibilityPayuChrome(View.GONE, 1, url);
            // Start waitingOTPTimer of 5secs to dismiss PayuChromeLoader
            startPayUChromeLoaderDisbaleTimer();

            /*if (checkProgress == PRE_PAYMENT) {
                // progressBarVisibilityPayuChrome(View.GONE, 1);
                checkProgress = DURING_PAYMENT;
            }*/

            if (firstFinish && (getArguments() != null && getArguments().getInt(CBConstant.MAIN_LAYOUT, -1) != -1)) {
                try {
                    final View activityRootView = activity.findViewById(getArguments().getInt(CBConstant.MAIN_LAYOUT));
                    activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(
                            new ViewTreeObserver.OnGlobalLayoutListener() {
                                private final int DefaultKeyboardDP = 100;
                                private final int EstimatedKeyboardDP = DefaultKeyboardDP + (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP ? 48 : 0);
                                private final Rect r = new Rect();

                                @Override
                                public void onGlobalLayout() {
                                    if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
                                        // Convert the dp to pixels.
                                        int estimatedKeyboardHeight = (int) TypedValue
                                                .applyDimension(TypedValue.COMPLEX_UNIT_DIP, EstimatedKeyboardDP, activityRootView.getResources().getDisplayMetrics());
                                        // Conclude whether the keyboard is shown or not.
                                        activityRootView.getWindowVisibleDisplayFrame(r);
                                        int heightDiff = activityRootView.getRootView().getHeight() - (r.bottom - r.top);
                                        boolean isShown = heightDiff >= estimatedKeyboardHeight;
                                        if (isShown) {
                                            if (checkForInput == 0) {
                                                InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
                                                imm.toggleSoftInput(InputMethodManager.RESULT_HIDDEN, 0);
                                                checkForInput = 1;
                                            }
                                        }
                                    }
                                }
                            });
                    firstFinish = false;

                } catch (Exception e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "onPageFinishWebclient_" + e.getMessage());
                }
            }
        }


        if (!isPageStoppedForcefully) {
            stopSnoozeCountDownTimer();
        }

        // if a new page is not started in another 1 sec we are going to kill snooze window.
        new Handler().postDelayed(() -> {
            // isPageStoppedForcefully - user interacted with snoozewindow.
            // page started - new page started loading on webview
            // isSnoozeWindowVisible - snooze window is on the screen.
            // backwardJourneyTransactionStarted - backward journey started. (We will dismiss snooze only in forward journey)
            if (!isPageStoppedForcefully && !pageStarted && isSnoozeWindowVisible && !backwardJourneyStarted) {
                //snoozeCount--;
                if (isSnoozeWindowVisible) {
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                }

                dismissSnoozeWindow();
            }
        }, 1000);
    }

    @JavascriptInterface
    public void setSnoozeEnabled(boolean snoozeEnabled) {

        if (!snoozeEnabled) {

            // snooze is dynamically disabled,
            // override snooze count set by merchant
            customBrowserConfig.setEnableSurePay(0);
        }

        cbUtil.setBooleanSharedPreference(SNOOZE_ENABLED, snoozeEnabled, activity.getApplicationContext());

    }

    /**
     * Don't close the PayUChromeLoader abruptly on page
     * load finish call, instead wait for sometime - if it's
     * a redirect and another page loads then cancel dismiss
     * of loader and continue showing it
     */
    private void startPayUChromeLoaderDisbaleTimer() {

        // Cancel any previous timers
        if (payUChromeLoaderDisableTimer != null) {
            payUChromeLoaderDisableTimer.cancel();
        }

        if (payUChromeLoaderEnableTimer != null) {
            payUChromeLoaderEnableTimer.cancel();
        }

        payUChromeLoaderDisableTimer = new CountDownTimer(2000, 1000) {

            public void onTick(long millisUntilFinished) {
                // mTextField.setText("seconds remaining: " + millisUntilFinished / 1000);
            }

            public void onFinish() {
                dismissPayULoader();
            }
        }.start();
    }

    /**
     * After user has landed on bank page,
     * don't show PayUChromeLoader as soon as url starts loading.
     * Instead wait for sometime - if url loads in that 'some time',
     * no need to show PayUChromeLoader in that case
     *
     * @deprecated
     */

    private void startPayUChromeLoaderEnableTimer() {

        // This waitingOTPTimer is used after CB has been seen by user once
        if (payUChromeLoaderEnableTimer != null) {
            payUChromeLoaderEnableTimer.cancel();
        }

        payUChromeLoaderEnableTimer = new CountDownTimer(1000, 1000) {

            public void onTick(long millisUntilFinished) {
                // mTextField.setText("seconds remaining: " + millisUntilFinished / 1000);
            }

            public void onFinish() {
                // Show PayU Loader as 1 second has elapsed
                progressBarVisibilityPayuChrome(View.VISIBLE, "");
                forwardJourneyForChromeLoaderIsComplete = true;
            }
        }.start();
    }

    /**
     * Stores the user id on NetBanking.
     */
    @JavascriptInterface
    public void getUserId() {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            activity.runOnUiThread(() -> {
                try {
                    if (cbUtil.getStringSharedPreference(activity.getApplicationContext(), bankName) != null && !cbUtil.getStringSharedPreference(activity.getApplicationContext(), bankName).equals("")) {
                        // load javascript to get user ID which call setUserID(from JS)
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_populate_user_id)) + "(\"" + cbUtil.getStringSharedPreference(activity.getApplicationContext(), bankName) + "\")");
                    }
                } catch (Exception e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "getUserId_" + e.getMessage());
                }
            });
        }
    }

    /**
     * Stores the user id on Netbanking.
     *
     * @param params - JSON object from js
     */
    @JavascriptInterface
    public void setUserId(final String params) {
        // saveUserIDCheck to check if user given the permission to save USER ID
        if (saveUserIDCheck) {
            if (activity != null && !activity.isFinishing()) {
                //SH: Can we please make use of SP helper here? And every other place where SP is accessed?
                //APPLIED CHANGE
                cbUtil.storeInSharedPreferences(activity.getApplicationContext(), bankName, params);
            }

        } else {
            //APPLIED CHANGE
            String savedParam = cbUtil.getStringSharedPreference(activity.getApplicationContext(), bankName);
            //if (!savedParam.equals("") && savedParam.equals(params)) {
            if (!savedParam.equals("")) {
                //APPLIED CHANGE
                cbUtil.removeFromSharedPreferences(activity.getApplicationContext(), bankName);
            }
        }

    }

    /**
     * Adds remember username and password peak view for NB
     *
     * @param fields key for handling net banking custom browser
     * @param params JSON string for net banking custom browser key
     */
    @JavascriptInterface
    public void nativeHelperForNB(final String fields, final String params) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            activity.runOnUiThread((Runnable) () -> {
                try {
                    if (isSnoozeWindowVisible) {
                        dismissSnoozeWindow();
                       /* if (snoozeCount > 0 && !isPageStoppedForcefully) { // if custom browser dismisses the snooze window we dont consider that as snooze count.
                            snoozeCount--;
                        }*/
                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_WINDOW_DISMISSED_BY_CB);
                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);

                    }
                    pageType = CBAnalyticsConstant.NBLOGIN_PAGE;
                    //  timeOfArrival = getSystemCurrentTime();
                    addEventAnalytics(CBAnalyticsConstant.ARRIVAL, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                    onHelpAvailable();
                    addEventAnalytics(CBAnalyticsConstant.CB_STATUS, CBAnalyticsConstant.NB_CUSTOM_BROWSER);
                    if (fields != null && activity != null) {
                        dismissSnoozeWindow();
                        View nbView = activity.getLayoutInflater().inflate(R.layout.cb_nb_layout, null);
                        final Button bContinue = (Button) nbView.findViewById(R.id.b_continue);
                        final CheckBox checkBox = (CheckBox) (nbView.findViewById(R.id.checkbox));
                        JSONObject jsonObject = new JSONObject(params);
                        String bText = getString(R.string.cb_btn_text);
                        if (jsonObject.has(bText) && jsonObject.getString(bText) != null && !jsonObject.getString(bText).equalsIgnoreCase("")) {
                            if (fields.equals(getString(R.string.cb_button))) {
                                if (jsonObject.has(getString(R.string.cb_checkbox))) {
                                    if (jsonObject.getBoolean(getString(R.string.cb_checkbox))) {
                                        // check if user has given permission to save userID
                                        if (saveUserIDCheck) {
                                            addEventAnalytics(CBAnalyticsConstant.INITIAL_USER_NAME_CHECKBOX_STATUS, "y");
                                            CBUtil.logData(getActivity().getApplicationContext(), AnalyticsConstant.UI_CUSTOME_BROWSER_LOADED, paymentType, AnalyticsConstant.UI_CB_LOADED, amount, bankcode, paymentType, "L1", String.valueOf((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - time))));
                                            checkBox.setChecked(true);
                                        } else {
                                            addEventAnalytics(CBAnalyticsConstant.INITIAL_USER_NAME_CHECKBOX_STATUS, "n");
                                            CBUtil.logData(getActivity().getApplicationContext(), AnalyticsConstant.UI_CUSTOME_BROWSER_LOADED, paymentType, AnalyticsConstant.UI_CB_LOADED, amount, bankcode, paymentType, "L1", String.valueOf((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - time))));
                                            checkBox.setChecked(false);
                                        }


                                        checkBox.setOnClickListener(new View.OnClickListener() {
                                            @Override
                                            public void onClick(View v) {
                                                saveUserIDCheck = checkBox.isChecked();
                                                if (saveUserIDCheck) {
                                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_NAME_CHECKBOX_STATUS + "y");

                                                } else {
                                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_NAME_CHECKBOX_STATUS + "n");

                                                }
                                            }
                                        });
                                        checkBox.setVisibility(View.VISIBLE);
                                    } else {
                                        checkBox.setVisibility(View.GONE);
                                    }
                                } else {
                                    checkBox.setVisibility(View.GONE);
                                }
                                bContinue.setText(jsonObject.getString(bText));
                                bContinue.setTransformationMethod(null);
                                bContinue.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        try {
                                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.NB_BUTTON_CLICK + bContinue.getText());
                                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                        } catch (Exception e) {
                                            if (null != e && null != e.getMessage())
                                                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "nb_cb_btn_click_" + e.getMessage());

                                        }
                                    }
                                });
                                cbBaseView.removeAllViews();
                                cbBaseView.addView(nbView);
                                nbhelpVisible = true;
                            } else if (fields.equals(getString(R.string.cb_pwd_btn))) { // for pwd button flow
                                bContinue.setText(jsonObject.getString(bText));
                                if (showToggleCheck)
                                    checkBox.setChecked(true);
                                else
                                    checkBox.setChecked(false);
                                if (checkBox.isChecked()) {
                                    try {
                                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + true + "\")");
                                    } catch (Exception e) {
                                        if (null != e && null != e.getMessage())
                                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "nb_cb_pwd_btn_click_" + e.getMessage());

                                    }
                                }
                                checkBox.setText(getString(R.string.cb_show_password));
                                checkBox.setVisibility(View.VISIBLE);
                                checkBox.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        showToggleCheck = checkBox.isChecked();
                                        if (checkBox.isChecked()) {
                                            try {
                                                // mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + true + "\")");
                                            } catch (Exception e) {
                                                if (null != e && null != e.getMessage())
                                                    addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "nb_checkbox_unchecked_" + e.getMessage());

                                            }


                                        } else {
                                            try {
                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + false + "\")");
                                            } catch (Exception e) {
                                                if (null != e && null != e.getMessage())
                                                    addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "nb_checkbox_checked_" + e.getMessage());

                                            }
                                        }

                                    }
                                });
                                bContinue.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        try {
                                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                        } catch (Exception e) {
                                            if (null != e && null != e.getMessage())
                                                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "nb_cb_pwd_btn_click_" + e.getMessage());

                                        }

                                    }
                                });
                                nbhelpVisible = true;
                                cbBaseView.removeAllViews();
                                cbBaseView.addView(nbView);
                            }

                        } else {
                            onHelpUnavailable();
                            cbBaseView.removeAllViews();
                        }
                    }
                } catch (Exception e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "nativeHelperForNB_" + e.getMessage());

                }
            });
        }

        // CB should be visible, dismiss PayUChromeLoader
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            activity.runOnUiThread(() -> dismissPayULoader());
        }
    }

    /**
     * run initialize.js manually.
     */
    @JavascriptInterface
    public void reInit() {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(() -> onPageFinished());
        }
    }

    /**
     * We found the bank, call back from initialize.js with the bank name.
     *
     * @param bank name of bank recived by js
     */
    @JavascriptInterface
    public void bankFound(final String bank) {

        if (!visibilitychecked) {
            checkStatusFromJS(bank);
            visibilitychecked = true;
        }
        //isBankFound = true;
        cbSetBankDrawable(bank);
//        CBUtil.setVariableReflection(CBConstant.MAGIC_RETRY_PAKAGE, bank, CBConstant.BANKNAME);
        if (activity != null && !activity.isFinishing()) {
            // initialize loading
            activity.runOnUiThread(() -> calculateMaximumWebViewHeight());
        }

        // bank name
        bankName = bank;
        if (!mPageReady) {
            try {

                if (!isPageStoppedForcefully) {
                    if (loadingLayout == null) {
                        convertToNative(CBConstant.LOADING, "{}");
                    } else {

                        View view;
                        if (activity != null) {
                            view = ((ViewGroup) activity.findViewById(R.id.help_view)).getChildAt(0);
                            if (loadingLayout != view) {
                                convertToNative(CBConstant.LOADING, "{}");
                            }
                        }
                    }
                }
            } catch (Exception e) {
                if (null != e && null != e.getMessage())
                    addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "bankFound_loading_" + e.getMessage());

            }

        }

        if (!mLoadingJS && mJS == null) {
            // do we have the js file already?


            Runnable serialRunnable = () -> {
                mLoadingJS = true;
                File file;
                InputStream inputStream = null;
                try {
                    if (activity != null) {
                        String fileName = mBankJS.getString(bank);
                        file = new File(activity.getFilesDir(), fileName);
                        if (!file.exists()) {
                            // SH: Please move this to a HTTP downloader, may be a helper, at least a function
                            URL url = new URL(CB_URL + fileName + ".js");

                            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
                            conn.setRequestMethod("GET");
                            conn.setSSLSocketFactory(new TLSSocketFactory());
                            conn.setRequestProperty("Accept-Charset", "UTF-8");
                            if (conn.getResponseCode() == HttpsURLConnection.HTTP_OK) {
                                inputStream = conn.getInputStream();
                                cbUtil.writeFileOutputStream(inputStream, activity, fileName, Context.MODE_PRIVATE);
                            }

                        }
                    }
                } catch (Exception e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "bankFound_url_connection_" + e.getMessage());

                } finally {
                    try {
                        if (inputStream != null) {
                            CBUtil.safeClose(inputStream);
                        }
                        if (activity != null) {
                            String fileName = mBankJS.getString(bank);
                            mJS = new JSONObject(CBUtil.decodeContents(activity.openFileInput(fileName)));
                            if (activity != null && !activity.isFinishing()) {
                                activity.runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        onPageFinished();
                                    }
                                });
                            }
                            mLoadingJS = false;
                        }
                    } catch (JSONException | FileNotFoundException e) {
                        if (null != e && null != e.getMessage())
                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "bankFound_finally_je_" + e.getMessage());

                    } catch (Exception e) {
                        if (null != e && null != e.getMessage())
                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "bankFound_finally_" + e.getMessage());
                    }
                }
            };
            serialExecutor.execute(serialRunnable);
        }

    }

    @JavascriptInterface
    public void fillOTPCallback(final boolean otpFilled) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(() -> {
                isOTPFilled = otpFilled;
                if (isOTPFilled) {
                    otp = null;
                    if (otpTriggered) {
                        otpTriggered = false;

                        String msg = mBankJS.optString(getString(R.string.cb_catchAll_success_msg));
                        //Show toast only when app is in foreground
                        if (mIsPaused) {
                            requestedToastMessage = msg;
                        } else {
                            if (null != msg && !msg.isEmpty())
                                Toast.makeText(activity.getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
                        }

//                            } catch (JSONException e) {
//                                e.printStackTrace();
//                            }
                    }
                }
            });
        }
    }

    @JavascriptInterface
    public void enableCatchAllJS(final boolean enableCatchAllJS) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(() -> {
                catchAllJSEnabled = enableCatchAllJS;
                fillOTPOnBankPage(true);
            });
        }
    }


    @JavascriptInterface
    public void cacheAnalytics(final String event) {
        try {
            JSONObject analyticsObject = new JSONObject(event);
            String txtFld = analyticsObject.get("inputFields").toString();

            if (listOfTxtFld == null) {
                listOfTxtFld = txtFld;
            } else {
                listOfTxtFld = listOfTxtFld + txtFld;
            }

            hostName = analyticsObject.get("hostName").toString();

        } catch (Exception e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "cacheAnalytics_" + e.getMessage());
        }
    }

    @JavascriptInterface
    public void closeCbUi() {
        dismissCb();

    }

    public void dismissCb() {
        dismissCbbottomSheet();
        dismissCollapsedUI();
    }

    private void dismissCbbottomSheet() {
        if (null != cbBottomSheet && cbBottomSheet.isAdded()) {
            cbBottomSheet.finish();
        }
    }

    /**
     * Js interface from Bank specific javascript.
     * Convert to native shows the bank specific native ui on the cbWebView
     *
     * @param fields can be anyone of choose, retry, incorrectotp, enterotp.
     * @param params regen: true, pin: false, otp: true.
     */
    @JavascriptInterface
    public void convertToNative(final String fields, final String params) {
        // isPageStoppedForcefully check is added with is snoozeWindowVisible.
        // Because when user clicks on snooze(try later) button it calls webview.stopLoading();
        // Webview.stopLoading calls onPageFinished()
        // which calls converttonative.
        // and snooze count is reduced by one. which breaks the logic.
        /*cbAppeared = true;*/
//       if (!cbBottomSheet.isVisible()){

//       }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();

//            killSnoozeService();
            cancelTransactionNotification();

           /* if (snoozeCount > 0 && !isPageStoppedForcefully) { // if custom browser dismisses the snooze window we dont consider that as snooze count.
                snoozeCount--;
            }*/
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_WINDOW_DISMISSED_BY_CB);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);

        }

        // CB should be visible, dismiss PayUChromeLoader
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(() -> dismissPayULoader());
        }

        if (pageType != null && !pageType.equalsIgnoreCase("")) {
            addEventAnalytics(CBAnalyticsConstant.DEPARTURE, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
            pageType = "";
        }

        if (activity != null && showCB && !activity.isFinishing()) {
            activity.runOnUiThread(() -> {
              /*  if (loadingLayout != null)
                    customProgressBar.removeProgressDialog(loadingLayout.findViewById(R.id.progress));
                if (enterOTPView != null)
                    customProgressBar.removeProgressDialog(enterOTPView.findViewById(R.id.progress));
*/
                try {
                    if (waitingOTPTimer != null && enterOtpRunnable != null) {
                        cbUtil.cancelTimer(waitingOTPTimer);
                    }

                    if (fields.equals(getString(R.string.cb_error))) {  // Error
                        // fail the payment
                        // hide the view
                        if (null != cbBottomSheet && cbBottomSheet.isAdded()) {
                            cbBottomSheet.onBankError(fields);
                        }
                        onBankError();
                    } else if (fields.equals("parse error")) {
                        // hide the view
                        if (null != cbBottomSheet && cbBottomSheet.isAdded()) {
                            cbBottomSheet.onBankError(fields);
                        }
                        onBankError();
                    } else if (fields.contentEquals(CBConstant.LOADING) && !pin_selected_flag && checkLoading) { // Bank page is still loading
                        onHelpAvailable();

                        if (cbTransparentView != null)
                            cbTransparentView.setVisibility(View.VISIBLE);
//
//                            if (loadingLayout == null)
//                                loadingLayout = activity.getLayoutInflater().inflate(R.layout.cb_loading, null);

//                        if(!cbBottomSheet.isAdded())
//                        cbBottomSheet.showNow(getActivity().getSupportFragmentManager(), "CbBottomSheet");
//                        cbBottomSheet.loading(getString(R.string.cb_processing_your_payment));

                    } else if (fields.equals(getString(R.string.cb_choose))) {
                        // choose flow.
//                            cbAppeared = true;
                        addCustomBrowserEventAnalytics();
                        frameState = MAXIMISED;
                        checkLoading = true;
                        if (cbTransparentView != null)
                            cbTransparentView.setVisibility(View.VISIBLE);

                        if (null != cbBottomSheet) {
                            if (!cbBottomSheet.isAdded()) {
                                cbBottomSheet.showNow(getActivity().getSupportFragmentManager(), "CbBottomSheet");

                                cbBottomSheet.chooseFasterAction(params);
                            }
                        }

                    } else if (fields.equals(getString(R.string.cb_incorrect_OTP_2))) { // incorrect otp.
                        pageType = fields;
                        addCustomBrowserEventAnalytics();
                        checkLoading = true;
                        if (isCbBottomSheetExpanded) {
                            if (null != cbBottomSheet) {
                                if (!cbBottomSheet.isAdded())
                                    cbBottomSheet.showNow(getActivity().getSupportFragmentManager(), "CbBottomSheet");
                                cbBottomSheet.incorrectOtp(params);
                            }
                        } else {

                            BOTTOM_SHEET_STATUS = CBConstant.MANUAL_OTP;
                            openCollapsedUI();
                            timerValueRemaining = 0L;
                        }
//

                    } else if (fields.equals(getString(R.string.cb_retry_otp))) { // Retry flow.
                        checkLoading = true;
                        if (isCbBottomSheetExpanded) {
                            if (null != cbBottomSheet) {
                                if (!cbBottomSheet.isAdded())
                                    cbBottomSheet.showNow(getActivity().getSupportFragmentManager(), "CbBottomSheet");
                                cbBottomSheet.retryOtp(params);

                                CBUtil.logData(getActivity().getApplicationContext(), AnalyticsConstant.UI_CUSTOME_BROWSER_RESEND, paymentType, AnalyticsConstant.UI_CB_RESEND, amount, bankcode, paymentType, "", String.valueOf(((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - time)))));

                            }


                        } else {
                            BOTTOM_SHEET_STATUS = CBConstant.MANUAL_OTP;
                            openCollapsedUI();
                            timerValueRemaining = 0L;
                        }

                    } else if (fields.equals(getString(R.string.cb_enter_pin))) { // user has just selected pin flow.
                        //   backwardJourneyTransactionStarted = true;
                        pageType = CBAnalyticsConstant.PIN_PAGE;
                        addCustomBrowserEventAnalytics();

                        if (cbSlideBarView != null)
                            cbSlideBarView.setVisibility(View.GONE);
                        pin_selected_flag = true;
                        approve_flag = true;
                        dismissCb();
                    } else if (fields.equals(getString(R.string.cb_enter_otp))) { // user is waiting for otp
                        pageType = fields;
//                            SMSOTPClicked = false;
                        // launchSnoozeWindow();

                        checkLoading = true;
                        enterOtpParams = params;
                        if (!checkPermissionVisibility) {
                            addCustomBrowserEventAnalytics();
                            prepareSmsListener();

                            if (null != cbBottomSheet) {
                                if (!cbBottomSheet.isAdded()) {
                                    CBUtil.logData(getActivity().getApplicationContext(), AnalyticsConstant.UI_CUSTOME_BROWSER_LOADED, paymentType, AnalyticsConstant.UI_CB_LOADED, amount, bankcode, paymentType, screenType, String.valueOf((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()))));
                                    cbBottomSheet.showNow(getActivity().getSupportFragmentManager(), "CbBottomSheet");
                                }
                                cbBottomSheet.enterOtp(params);
                            }

                        }

                    } else if (fields.equals(getString(R.string.cb_incorrect_pin))) { // oops wrong pin attempt.
                        pageType = CBAnalyticsConstant.CHOOSE_SCREEN;
                        addCustomBrowserEventAnalytics();

                        final JSONObject jsonObject;
                        try {
                            jsonObject = new JSONObject(params);
                            if (jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                checkLoading = true;
                                if (null != cbBottomSheet) {
                                    if (!cbBottomSheet.isAdded()) {
                                        cbBottomSheet.showNow(getActivity().getSupportFragmentManager(), "CbBottomSheet");

                                        cbBottomSheet.chooseFasterAction(params);
                                    }
                                }

                            }
                        } catch (Exception e) {
                            if (null != e && null != e.getMessage())
                                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "cb_incorrect_pin_" + e.getMessage());
                        }
                    } else if (fields.equals(getString(R.string.cb_register_option))) { // Register new user.
                /*        pageType = CBAnalyticsConstant.REGISTER_PAGE;
                        addCustomBrowserEventAnalytics();
                        onHelpAvailable();
                        final View view = activity.getLayoutInflater().inflate(R.layout.register, null);
                        cbBaseView.removeAllViews();
                        cbBaseView.addView(view);
                        ImageView im = (ImageView) view.findViewById(R.id.bank_logo);
                        im.setOnClickListener(viewOnClickListener);
                        if (drawable != null)
                            im.setImageDrawable(drawable);

                        updateHeight(view);
                        if (cbBaseView.isShown()) {
                            frameState = MAXIMISED;
                        } else {
                            maximiseWebviewHeight();
                        }*/


                    } else {
                        addEventAnalytics(CBAnalyticsConstant.ARRIVAL, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
//                   if (null!= cbBottomSheet && cbBottomSheet.isAdded())
//                       cbBottomSheet.finish();
                    }


                } catch (Exception e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "convertToNative_" + e.getMessage());
                }
                if (pageType != null && !pageType.equalsIgnoreCase("")) {
                    addEventAnalytics(CBAnalyticsConstant.ARRIVAL, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                }
            });
        }
    }

    @JavascriptInterface
    public void showJSRequestedToast(final String message) {
        //Show toast only when app is in foreground.
        if (mIsPaused) {
            requestedToastMessage = message;
        } else {
            Toast.makeText(activity.getApplicationContext(), message, Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * add event 'custom-browser' to the array for Custom Browser payment flow
     */
    void addCustomBrowserEventAnalytics() {
        if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
            eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
            addEventAnalytics(CBAnalyticsConstant.CB_STATUS, eventRecorded);
        }
    }


    public void onPageFinished() {
        if (this.isAdded() && !this.isRemoving() && null != activity) {
            mPageReady = true;

            if (approve_flag) {
                onHelpUnavailable();
                approve_flag = false;
            }

            if (loadingLayout != null && loadingLayout.isShown()) {
                frameState = MINIMISED;
                maximiseWebviewHeight();
                onHelpUnavailable();
            }

            activity.getWindow().setSoftInputMode(WindowManager.
                    LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

            if (mJS != null && showCB && !isPageStoppedForcefully) { // we have cb and we have the bankspecific js, lets show cb.
                try {
                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_init)));
                } catch (JSONException e) {
                    if (null != e && null != e.getMessage())
                        addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "onPageFinished_" + e.getMessage());
                }
            }
            if (mBankJS != null) {// && mJS == null) {
                if (!cAJSVisibilityCalled) {
                    checkStatusFromJS("", CBConstant.CHECK_CATCH_ALL_JS_ENABLE_JS_STATUS);
                    cAJSVisibilityCalled = true;
                }
                if (cbTransparentView != null)
                    cbTransparentView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.

            }
            fillOTPOnBankPage(true);
        }

    }

    public void fillOTPOnBankPage(boolean isAutoFillOTP) {
        if (!TextUtils.isEmpty(otp) && catchAllJSEnabled && !backwardJourneyStarted && !isOTPFilled /*&& !cbAppeared*/) {
            //call JS method with OTP and URL
            try {
                JSONObject obj = new JSONObject();
                obj.put("otp", otp);
                obj.put("isAutoFillOTP", isAutoFillOTP);
                cbWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_fill_otp)) + "(" + obj + ")");
            } catch (JSONException e) {
                if (null != e && null != e.getMessage())
                    addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "fillOTPOnBankPage_" + e.getMessage());
            }
        }
    }

//    public void fillOTPFromCBScreen(final String otpText){
//        if (activity != null && !activity.isFinishing()){
//            activity.runOnUiThread(new Runnable() {
//                @Override
//                public void run() {
//                    if (isOTPFilled && backupOfOTP!=null && !otpText.contentEquals(backupOfOTP)){
//                        otp = otpText;
//                        backupOfOTP = otp;
//                        isOTPFilled = false;
//                        fillOTPOnBankPage(false);
//                    }
//                }
//            });
//        }
//    }

    public void onPageStarted() {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (nbhelpVisible) {
                onHelpUnavailable();
                nbhelpVisible = false;
            }
            if (this.isAdded() && !this.isRemoving() && this.isVisible()) {
                mPageReady = false;
                if (mBankJS != null) { // we have successfully downloaded initialize.js
                    try {
                        if (showCB) {
                            cbWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_detect_bank)));
//                            showMagicRetryCB();
                        }

                    } catch (JSONException e) {
                        if (null != e && null != e.getMessage())
                            addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "onPageStarted_" + e.getMessage());
                    }
                }
                if (cbTransparentView != null)
                    cbTransparentView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.
            }
        }
    }

    @Override
    void enter_otp(String params) {

    }

    /**
     * @param result json data of post param.
     *               call back function from furl - failure transaction.
     *               keep the value in {@link #merchantResponse}
     *               set result ok, and send the received data.
     * @param result json string
     */

    @JavascriptInterface
    public void onFailure(String result) {
        merchantResponse = result;
        onMerchantUrlFinished();
    }

    /**
     * Attempt to deprecate furl.
     * Javascript call from payu server.
     * Lets keep the data in local variable and pass it to calling activity.
     *
     * @param result json string result of failure transaction
     */
    @JavascriptInterface
    public void onPayuFailure(String result) {
        // This happens just before furlpost: Transaction should have been done: we can kill the service now.
//        if (null != snoozeService) {
//            snoozeService.killSnoozeService();
//        }

        if (activity != null) {
            eventRecorded = CBAnalyticsConstant.FAILURE_TRANSACTION;
            addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, eventRecorded);
            isSuccessTransaction = false;
            payuReponse = result;
        }

        cancelTransactionNotification();
        callTimer();
    }

    /**
     * Call back from surl - sucess transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onSuccess() {
        onSuccess("");
    }

    /**
     * Attempt to deprecate surl.
     * Javascript interface call from payu server.
     * Lets keep the data in local variable and pass it to main activity.
     *
     * @param result json data of post param.
     */

    @JavascriptInterface
    public void onPayuSuccess(final String result) {

        // This happens just before surlpost: Transaction should have been done: we can kill the service now.
//        if (null != snoozeService) {
//            snoozeService.killSnoozeService();
//        }

        isSuccessTransaction = true;

        // lets do the analytics.
        eventRecorded = CBAnalyticsConstant.SUCCESS_TRANSACTION;
        addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, eventRecorded);

        payuReponse = result;

        cancelTransactionNotification();
        callTimer();
    }

    /**
     * call back function from surl - success transaction.
     * keep the data in {@link #merchantResponse}
     * set result ok, and send the received data.
     *
     * @param result success result received from surl
     */
    @JavascriptInterface
    public void onSuccess(String result) {
        isSuccessTransaction = true;
        merchantResponse = result;
        onMerchantUrlFinished();
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel() {
        onCancel("");
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel(final String result) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(() -> {
                if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                    Intent intent = new Intent();
                    intent.putExtra(getString(R.string.cb_result), result);
                    activity.setResult(Activity.RESULT_CANCELED, intent);
                    activity.finish();
                }
            });
        }
    }

    /**
     * Mapping the string with integers to make sure it works on java 1.6 and below.
     *
     * @param str name
     * @return numnber
     */

    int getCode(String str) {
        if (str.equalsIgnoreCase(getString(R.string.cb_pin)))
            return PIN;
        else if (str.equalsIgnoreCase(getString(R.string.cb_password)))
            return PASSWORD;
        else if (str.equalsIgnoreCase(getString(R.string.cb_enter_manually)))
            return ENTER_MANUALLY;
        else if (str.equalsIgnoreCase(getString(R.string.cb_approve_otp)))
            return APPROVE;
        else if (str.equalsIgnoreCase(getString(R.string.cb_otp)) || str.equalsIgnoreCase(getString(R.string.cb_use_sms_otp)))
            return OTP;
        else if (str.equalsIgnoreCase(getString(R.string.cb_sms_otp)))
            return SMS_OTP;
        return DEFAULT;
    }

    /**
     * On page start of every url we keep monitor LOADING_THRESHOLD is loaded with in snoozeUrlLoadingTimeout
     * if the page is able to load LOADING_THRESHOLD in snoozeUrlLoadingTimeout then it is running on good internet speed,
     * else we consider it is running on slow connection and we launch snooze dialog.
     */
    private void startSnoozeCountDownTimer() {
        mCountDownTimer = new CountDownTimer(snoozeUrlLoadingTimeout, 500) {
            @Override
            public void onTick(long l) {
                isSnoozeTimerRunning = true;
            }

            @Override
            public void onFinish() {
                isSnoozeTimerRunning = false;
                if (cbWebView.getProgress() < snoozeUrlLoadingPercentage) {

                    if (!isSnoozeWindowVisible && showSnoozeWindow && !getTransactionStatusReceived()) { // we already have an snooze window! lets use the window which is available on screen.

                        //dismissSnoozeWindow(); // We dont need this
                        launchSnoozeWindow();
                    }
                }
                stopSnoozeCountDownTimer();
            }
        };
        mCountDownTimer.start();
    }

    /**
     * Method to kill existing snooze counter which
     * determines if snooze window has to be displayed or
     * not on this page
     */
    private void stopSnoozeCountDownTimer() {
        if (null != mCountDownTimer) {
            isSnoozeTimerRunning = false;
            mCountDownTimer.cancel();
            mCountDownTimer = null;
        }
    }

    /**
     * Launch snooze window in based on merchant's input.
     */
    public void launchSnoozeWindow() {
        launchSnoozeWindow(WARN_MODE);
    }

    /**
     * This function will be called once the web chrome client identifies the page is not loaded to THRESHOLD VALUE in the given TIME INTERVAL
     * progress webview loading progress in percentage.
     *
     * @param mode WARN_MODE, FAIL_MODE [MR replacement]
     */

    public void launchSnoozeWindow(final int mode) {

        // SurePay can be selectively disabled on per mode basis, possible combinations are:
        // 1. WARN ONLY, 2. FAIL ONLY, 3. BOTH FAIL AND WARN

        // #3
        if (surePayDisableStatus == CBConstant.DISABLE_WARN_AND_FAIL_MODE) return;
        // #2
        if (mode == FAIL_MODE && surePayDisableStatus == CBConstant.DISABLE_FAIL_MODE) return;
        // #1
        if (mode == WARN_MODE && surePayDisableStatus == CBConstant.DISABLE_WARN_MODE) return;

        // dismiss cb blank overlay
        showCbBlankOverlay(View.GONE);

        boolean showSnoozeWindow;

        // check for snooze count for backward and forward journey
        // return if snooze count are already consumed
        if (backwardJourneyStarted) {
            if (!(snoozeCountBackwardJourney < customBrowserConfig.getEnableSurePay())
                    //In case of S2S html support check for surePayS2SPayUId & surePayS2Surl
                    || (isS2SHtmlSupport && (TextUtils.isEmpty(surePayS2SPayUId) || TextUtils.isEmpty(surePayS2Surl)))) {
                return;
            }
        } else if (!(snoozeCount < customBrowserConfig.getEnableSurePay())
                //In case of S2S html support check for surepayS2Surl empty value
                || (isS2SHtmlSupport && (TextUtils.isEmpty(surePayS2Surl)))) {
            return;
        }

        // Setting Snooze Mode
        this.snoozeMode = mode;
        if (activity != null && !activity.isFinishing()) {
            // Dismiss slow user warning dialog, if any
            dismissSlowUserWarning();
            // Remove PayUChromeLoader
            progressBarVisibilityPayuChrome(View.GONE, "");
            // Flag, to know state of snooze window -- VISIBLE / NOT VISIBLE
            isSnoozeWindowVisible = true;
            // Event analytics
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_STATUS, CBAnalyticsConstant.SNOOZE_VISIBLE);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_APPEAR_URL, webviewUrl);

            String modeStr = ((mode == CBConstant.WARN_MODE) ? STR_SNOOZE_MODE_WARN : STR_SNOOZE_MODE_FAIL);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_LAUNCH_MODE, modeStr);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_APPEAR_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);

            // No matter what option user clicks we count as one more.
            // lets launch snooze window.
            LayoutInflater layoutInflater = activity.getLayoutInflater();
//            if (null == snoozeLayout) {
            View snoozeLayout = layoutInflater.inflate(R.layout.cb_layout_snooze, null);
//            }
            final TextView snoozeMessageTextView = (TextView) snoozeLayout.findViewById(R.id.text_view_snooze_message);
            final TextView transactionSnoozedMessageTextView1 = (TextView) snoozeLayout.findViewById(R.id.text_view_transaction_snoozed_message1);
            final TextView dismissSnoozeWindow = (TextView) snoozeLayout.findViewById(R.id.button_cancel_transaction);
            final Button snoozeTransactionButton = (Button) snoozeLayout.findViewById(R.id.button_snooze_transaction);
            final Button retryTransactionButton = (Button) snoozeLayout.findViewById(R.id.button_retry_transaction);
            final TextView cancelTxnSnooze = (TextView) snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window);
            final TextView tConfirm = (TextView) snoozeLayout.findViewById(R.id.t_confirm);
            final TextView tNConfirm = (TextView) snoozeLayout.findViewById(R.id.t_nconfirm);
            final TextView snoozeDialogHeaderText = (TextView) snoozeLayout.findViewById(R.id.snooze_header_txt);
            final TextView snoozeRetryDetailText = (TextView) snoozeLayout.findViewById(R.id.text_view_retry_message_detail);
            final Button retryAnywayButton = (Button) snoozeLayout.findViewById(R.id.button_retry_anyway);
            snoozeLoaderView = (SnoozeLoaderView) snoozeLayout.findViewById(R.id.snooze_loader_view);

            snoozeLoaderView.setVisibility(View.GONE);
            cancelTxnSnooze.setVisibility(View.VISIBLE);
            dismissSnoozeWindow.setVisibility(View.VISIBLE);
            snoozeTransactionButton.setVisibility(View.VISIBLE);
            retryTransactionButton.setVisibility(View.VISIBLE);
            snoozeMessageTextView.setVisibility(View.VISIBLE);
            transactionSnoozedMessageTextView1.setVisibility(View.GONE);
            snoozeRetryDetailText.setVisibility(View.VISIBLE);
            tConfirm.setVisibility(View.GONE);
            tNConfirm.setVisibility(View.GONE);
            retryAnywayButton.setVisibility(View.GONE);


            snoozeMessageTextView.setText(activity.getString(R.string.cb_slownetwork_status));
            snoozeDialogHeaderText.setText(activity.getString(R.string.cb_try_later));
            snoozeRetryDetailText.setText(activity.getString(R.string.cb_retry_restart));


            // show backward journey dialog only if backward journey started and payu PG is used
            if (backwardJourneyStarted && payuPG) {
                //addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_STATUS, CBAnalyticsConstant.SNOOZE_WITH_CONFIRM_DEDUCTION_VISIBLE);
                snoozeMessageTextView.setText(activity.getResources().getString(R.string.cb_slow_internet_confirmation));
                transactionSnoozedMessageTextView1.setText(activity.getResources().getString(R.string.cb_receive_sms));
                snoozeDialogHeaderText.setText(activity.getResources().getString(R.string.cb_confirm_transaction));
                snoozeTransactionButton.setVisibility(View.GONE);
                snoozeRetryDetailText.setVisibility(View.GONE);
                retryTransactionButton.setVisibility(View.GONE);
                dismissSnoozeWindow.setVisibility(View.GONE);
                snoozeMessageTextView.setVisibility(View.VISIBLE);
                transactionSnoozedMessageTextView1.setVisibility(View.VISIBLE);
                tConfirm.setVisibility(View.VISIBLE);
                tNConfirm.setVisibility(View.VISIBLE);
                retryAnywayButton.setVisibility(View.GONE);

                snoozeVisibleCountBackwdJourney++;
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_APPEAR_TIME, );
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_VISIBLE, "Y");

            } else {
                snoozeVisibleCountFwdJourney++;
            }

            // if user confirm amount deducted
            tConfirm.setOnClickListener(v -> {

                addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CONFIRM_DEDUCTION_Y);

                if (waitingOTPTimer != null) {
                    waitingOTPTimer.cancel();
                    waitingOTPTimer.purge();
                }
                snoozeCountBackwardJourney++;

//                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_USER_INTERACTION_TIME, getSystemCurrentTime());

                snoozeDialog.setCanceledOnTouchOutside(false);
                snoozeDialogHeaderText.setText(activity.getResources().getString(R.string.cb_confirm_transaction));
                snoozeMessageTextView.setText(activity.getString(R.string.cb_transaction_status));
                snoozeLoaderView.setVisibility(View.VISIBLE);
                snoozeLoaderView.startAnimation();
                snoozeTransactionButton.setVisibility(View.GONE);
                transactionSnoozedMessageTextView1.setVisibility(View.GONE);
                tConfirm.setVisibility(View.GONE);
                tNConfirm.setVisibility(View.GONE);
//                if (verificationMsgReceived) {
//                    startSnoozeServiceVerifyPayment(activity.getResources().getString(R.string.cb_verify_message_received));
//                } else {
//                    startSnoozeServiceVerifyPayment(activity.getResources().getString(R.string.cb_user_input_confirm_transaction));
//                }
            });

            // if user confirm amount not deducted
            tNConfirm.setOnClickListener(v -> {
                snoozeCountBackwardJourney++;

//                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_USER_INTERACTION_TIME, getSystemCurrentTime());
                dismissSnoozeWindow();
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CONFIRM_DEDUCTION_N);

            });
            cancelTxnSnooze.setOnClickListener(view -> {
                if (backwardJourneyStarted) {
                    snoozeCountBackwardJourney++;
                } else {
                    snoozeCount++;
                }

                // Dismiss snooze window.
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                if (backwardJourneyStarted) {
                    // This doest not require.
//                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_WINDOW_CLICK);
                } else {
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_WINDOW_CLICK);
                }
                //Kill snooze service SurePay- Auto Resume Feature
//                if (mode == FAIL_MODE) {
//                    killSnoozeService();
//                }
                dismissSnoozeWindow();
            });

            retryTransactionButton.setOnClickListener(view -> {
                //Close CB if transaction is restart
                hideCB();
                dismissCb();
                retryPayment(view);

                /*snoozeCount++;
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, getSystemCurrentTime());
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_RETRY_CLICK);
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
               // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RETRY_NOW_URL, cbWebView.getUrl());
                isTransactionStatusReceived = false;
                // check -  loading url is from magic retry list
                // CBConstant.PAYMENT_URL does not allow to call webview.reload();
                if (CBUtil.isNetworkAvailable(activity.getApplicationContext())) {
                    if (cbWebView.getUrl() != null && !cbWebView.getUrl().contentEquals(CBConstant.PAYMENT_URL) && Bank.isUrlWhiteListed(cbWebView.getUrl())) {
                        *//*cbWebView.reload();*//*
                        reloadWVUsingJS();
                    } else {
                        if(customBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL)){
                            // mark the previous txn as sure pay canceled.
                            markPreviousTxnAsUserCanceled(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.SURE_PAY_CANCELLED, customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, customBrowserConfig.getTransactionID(), ""));
                        }

                        reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                        //cbWebView.postUrl(CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getPostURL(), CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getPayuPostData().getBytes());
                    }

                    dismissSnoozeWindow();

                    // Setting slow user warning waitingOTPTimer to null, so that it can be resumed
                    slowUserCountDownTimer = null;

                } else {

                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, CBConstant.MSG_NO_INTERNET);
                    Toast.makeText(activity.getApplicationContext(), CBConstant.MSG_NO_INTERNET, Toast.LENGTH_SHORT).show();
                }*/
            });


//            snoozeTransactionButton.setOnClickListener(view -> {
//
//                isRetryNowPressed = true;
//                snoozeCount++;
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
//                maximiseWebviewHeight();
//                frameState = MINIMISED;
//                if (cbSlideBarView != null)
//                    cbSlideBarView.setVisibility(View.GONE);
//
//                onHelpUnavailable();
//                // Store snooze Clicked Time
//                snoozeClickedTime = System.currentTimeMillis();
//
//                // Register broadcast
//                isSnoozeBroadCastReceiverRegistered = true;
//                //LocalBroadcastManager.getInstance(activity.getApplicationContext()).registerReceiver(snoozeBroadCastReceiver, new IntentFilter(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION));
//                // set pageForcefullyStopped to true
//                isPageStoppedForcefully = true;
//                // we need to stop the current loading page.
//                cbWebView.stopLoading();
////                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
////                    hasToStart = true;
////                    bindService();
////                }
//                // reset the password as transaction is snoozed
//                mPassword = null;
//                // unregister sms receiver as transaction is snoozed, so no sms receiver required
////                    unregisterBroadcast(mBroadcastReceiver);
//
//
//                //snoozeHeaderTextView.setText("Transaction snoozed");
//                cancelTxnSnooze.setVisibility(View.GONE);
//                dismissSnoozeWindow.setVisibility(View.GONE);
//                snoozeTransactionButton.setVisibility(View.GONE);
//                retryTransactionButton.setVisibility(View.GONE);
//                snoozeMessageTextView.setText(getString(R.string.cb_we_have_paused_your_transaction_because_the_network_was_unable_to_process_it_now));
//                //snoozeMessageTextView.setVisibility(View.GONE);
//                snoozeRetryDetailText.setVisibility(View.GONE);
//                snoozeDialogHeaderText.setText(activity.getResources().getString(R.string.cb_transaction_paused));
//                transactionSnoozedMessageTextView1.setVisibility(View.VISIBLE);
//                retryAnywayButton.setVisibility(View.VISIBLE);
//
//                // killing payu loader (there are situations payu loader may be visible.)
//                progressBarVisibilityPayuChrome(View.GONE, "");
//
//                // snooze Event Analytics
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CLICK);
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_LOAD_URL, null == cbWebView.getUrl() ? webviewUrl : cbWebView.getUrl());
//
//                // Setting slow user warning waitingOTPTimer to null, so that it can be resumed
//                slowUserCountDownTimer = null;
//                // show blank overlay.
//                showCbBlankOverlay(View.VISIBLE);
//
//
//            });
//
//            dismissSnoozeWindow.setOnClickListener(view -> {
//                if (backwardJourneyStarted) {
//                    snoozeCountBackwardJourney++;
//                } else {
//                    snoozeCount++;
//                }
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_TRANSACTION_CLICK);
//                showBackButtonDialog();
//            });

            retryAnywayButton.setOnClickListener(view -> {
                // hide Custom browser if transaction is restart
                hideCB();
                dismissCb();
                retryPayment(view);
            });


            if (null == snoozeDialog || !snoozeDialog.isShowing()) {
                snoozeDialog = new AlertDialog.Builder(activity).create();

                snoozeDialog.setView(snoozeLayout);
                snoozeDialog.setCanceledOnTouchOutside(false);
                snoozeDialog.setOnDismissListener(dialogInterface -> showCbBlankOverlay(View.GONE));
                snoozeDialog.setOnKeyListener((arg0, keyCode, event) -> {
                    // TODO Auto-generated method stub
                    if (keyCode == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) {
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());
                        showBackButtonDialog();
                        /*finish();
                        dialog.dismiss();*/
                    }
                    return true;
                });


            }

            snoozeDialog.show();
//            if (mode == CBConstant.FAIL_MODE && !backwardJourneyStarted) {
//                hasToStart = false;
//                bindService();
//            }
        }
    }

    /**
     * Start broadcast receiver for Handshake (to know if CB is alive or not)
     * Also, start snooze service to detect good network and launch notification
     * to resume transactions
     */
//    public void bindService() {
//        LocalBroadcastManager.getInstance(activity).unregisterReceiver(snoozeBroadCastReceiver); // TODO: remove unregister, and register broadcast receiver only if it is not registered yet.
//        LocalBroadcastManager.getInstance(activity.getApplicationContext()).registerReceiver(snoozeBroadCastReceiver, new IntentFilter(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION));
//        Intent intent = new Intent(activity, SnoozeService.class);
//        // This intent will have all the post data.
//        // should have the checkout page's class name.
//        intent.putExtra(CB_CONFIG, customBrowserConfig);
//        //intent.putExtra(POST_DATA, customBrowserConfig.getPayuPostData());
//        intent.putExtra(CURRENT_URL, webviewUrl);
//        //intent.putExtra(POST_URL, customBrowserConfig.getPostURL());
//        intent.putExtra(MERCHANT_CHECKOUT_ACTIVITY, customBrowserConfig.getMerchantCheckoutActivityPath());
//        if (!TextUtils.isEmpty(surePayS2Surl))
//            intent.putExtra(S2S_RETRY_URL, surePayS2Surl);
//        // Binding the service.
//        isSnoozeServiceBounded = true;
//        activity.bindService(intent, snoozeServiceConnection, Context.BIND_AUTO_CREATE);
//
//        // starting the service.
//        activity.startService(intent);
//    }

    /**
     * Start snooze service to verify payment
     */
//    public void startSnoozeServiceVerifyPayment(String verifyParam) {
//        LocalBroadcastManager.getInstance(activity).unregisterReceiver(snoozeBroadCastReceiver); // TODO remove unregister, and register it only if it is not registered yet.
//        LocalBroadcastManager.getInstance(activity.getApplicationContext()).registerReceiver(snoozeBroadCastReceiver, new IntentFilter(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION));
//        Intent intent = new Intent(activity, SnoozeService.class);
//        // This intent will have all the post data.
//        intent.putExtra(CB_CONFIG, customBrowserConfig);
//        intent.putExtra(VERIFICATION_MSG_RECEIVED, true);
//        intent.putExtra(MERCHANT_CHECKOUT_ACTIVITY, customBrowserConfig.getMerchantCheckoutActivityPath());
//        intent.putExtra(VERIFY_ADDON_PARAMS, verifyParam);
//        if (!TextUtils.isEmpty(surePayS2SPayUId))
//            intent.putExtra(CBConstant.PAYUID, surePayS2SPayUId);
////        if(!TextUtils.isEmpty(phpSessionId))
////            intent.putExtra(CBConstant.PHP_SESSION_ID, phpSessionId);
//        if (!TextUtils.isEmpty(merchantKey))
//            intent.putExtra(CBConstant.MERCHANTKEY, merchantKey);
//        if (!TextUtils.isEmpty(txnId))
//            intent.putExtra(CBConstant.TXN_ID, txnId);
//        // Binding the service.
//        isSnoozeServiceBounded = true;
//        activity.bindService(intent, snoozeServiceConnection, Context.BIND_AUTO_CREATE);
//        isSnoozeBroadCastReceiverRegistered = true;
//        //  intent.putExtra(POST_DATA, customBrowserConfig.getPayuPostData());
//        // intent.putExtra(POST_URL,customBrowserConfig.getPostURL());
//        // starting the service.
//        activity.startService(intent);
//    }


    /**
     * Method to dismiss snooze window.
     */
    public void dismissSnoozeWindow() {
        isSnoozeWindowVisible = false;
        //snoozeWindowDismissTime = System.currentTimeMillis();

        if (null != snoozeDialog) {
            snoozeDialog.dismiss();
            snoozeDialog.cancel();

            // dismiss cb blank overlay
            showCbBlankOverlay(View.GONE);
        }
    }

    /**
     * Commenting below code as Magic Retry is deprecated and hence removed from CB.
     * set the whtelisted url of magic etry
     * <p>
     * <p>
     * public void setMagicRetry(Map<String, String> urlList) {
     * if (magicRetryFragment != null) {
     * magicRetryFragment.setUrlListWithPostData(urlList);
     * }
     * }
     * <p>
     * initialize magic retry
     * <p>
     * public void initMagicRetry() {
     * FragmentManager fragmentManager = getActivity().getSupportFragmentManager();
     * magicRetryFragment = new MagicRetryFragment();
     * Bundle newInformationBundle = new Bundle();
     * if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
     * <p>
     * newInformationBundle.putString(MagicRetryFragment.KEY_TXNID, customBrowserConfig.getTransactionID());
     * }
     * magicRetryFragment.setArguments(newInformationBundle);
     * fragmentManager.beginTransaction().add(R.id.magic_retry_container, magicRetryFragment, "magicRetry").commit();
     * toggleFragmentVisibility(Util.HIDE_FRAGMENT);
     * magicRetryFragment.isWhiteListingEnabled(true);
     * magicRetryFragment.setWebView(cbWebView);
     * magicRetryFragment.initMRSettingsFromSharedPreference(activity);
     * <p>
     * if (customBrowserConfig.getEnableSurePay() > 0) {
     * // snooze is enabled use SnoozeWebViewClient
     * cbWebView.setWebViewClient(new PayUSurePayWebViewClient(this, Bank.keyAnalytics));
     * } else {
     * // snooze is disabled use PayUwebViewClient which has MagicRetry
     * cbWebView.setWebViewClient(new PayUWebViewClient(this, magicRetryFragment, Bank.keyAnalytics));
     * }
     * }
     * <p>
     * /** * Change the visibility of magic retry
     * <p>
     * public void toggleFragmentVisibility(int flag) {
     * if (getActivity() != null && !getActivity().isFinishing() && isAdded() && !isRemoving()) {
     * FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
     * if (magicRetryFragment != null && flag == Util.SHOW_FRAGMENT) {
     * // Show fragment
     * ft.show(magicRetryFragment).commitAllowingStateLoss();
     * } else if (magicRetryFragment != null && flag == Util.HIDE_FRAGMENT) {
     * // Hide fragment
     * ft.hide(magicRetryFragment).commitAllowingStateLoss();
     * // ft.hide(magicRetryFragment);}
     * <p>
     * }
     * }
     * }
     * <p>
     * <p>
     * set MR visibility true
     * <p>
     * public void showMagicRetry() {
     * <p>
     * dismissSnoozeWindow();
     * toggleFragmentVisibility(Util.SHOW_FRAGMENT);
     * }
     * <p>
     * /**
     * set MR visibility false
     * <p>
     * public void hideMagicRetry() {
     * toggleFragmentVisibility(Util.HIDE_FRAGMENT);
     * }
     */

    @FunctionalInterface
    interface OnSubmitClick {
        void onSubmit(String input);
    }

    public void showBackButtonDialog() {
        if (activity != null && !activity.isFinishing() && !activity.isDestroyed()) {
            android.app.AlertDialog.Builder backButtonClickAlertDialog = new android.app.AlertDialog.Builder(activity, R.style.cb_dialog);
            backButtonClickAlertDialog.setCancelable(false);
            backButtonClickAlertDialog.setMessage(activity.getString(R.string.payu_cancel_transaction_confirmation));
            backButtonClickAlertDialog.setPositiveButton(activity.getString(R.string.payu_ok),
                    (dialog, which) -> {
                        if (isAdded() && !isRemoving() && !isDetached()) {
                            if (paymentType != null && paymentType.equals(CBConstant.NETBANKING)) {
                                UserCancellationFeedbackBottomSheet.Builder bottomSheet = new UserCancellationFeedbackBottomSheet.Builder(getContext(), getChildFragmentManager(), TAG);
                                bottomSheet.setDefaultFeedbacksList(null, true);
                                bottomSheet.setFeedbackListener(reason -> {
                                    positiveBackButton();
                                    if (!reason.isEmpty()) {
                                        CBUtil.logUserCancellation(activity, AnalyticsConstant.PAYU_CB, paymentType, CBAnalyticsConstant.BACK_BUTTON, amount, bankcode, paymentType, screenType, String.valueOf((TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()))), reason);
                                    }
                                });
                                bottomSheet.setPrimaryColor(customBrowserConfig.getPrimaryColor());
                                bottomSheet.setBaseTextColor(customBrowserConfig.getBaseTextColor());
                                bottomSheet.build().show();
                            } else {
                                positiveBackButton();
                            }
                        }
                    }
            );
            backButtonClickAlertDialog.setNegativeButton(activity.getString(R.string.cb_b_cancel), (dialog, which) -> {
                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK);
                //  onBackCancelled();
                dialog.dismiss();
                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                }
            });
            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(backButtonClickAlertDialog);
            }
            dialog = backButtonClickAlertDialog.create();

            WindowManager.LayoutParams wmlp = dialog.getWindow().getAttributes();
            wmlp.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
            //wmlp.setType();
            // wmlp.flags = WindowManager.LayoutParams.TYPE_SYSTEM_DIALOG;
            dialog = backButtonClickAlertDialog.show();
        }
    }

    private void positiveBackButton() {
        postToPaytxn();
        if (snoozeDialog != null && snoozeDialog.isShowing()) {
            snoozeDialog.cancel();
        }

        cancelTransactionNotification();

        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK);
        dismissSnoozeWindow();

        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
        }

        if (activity != null && activity instanceof CBActivity) {
            activity.finish();
        }
    }

    /**
     * Helper to set flag isPageStoppedForcefully,
     * call this when user interacts with Snooze
     * action buttons
     *
     * @param isPageStoppedForcefully
     */
    public void setIsPageStoppedForcefully(boolean isPageStoppedForcefully) {
        this.isPageStoppedForcefully = isPageStoppedForcefully;
    }

    /**
     * List of whitelisted urls where retry works from
     * same hop
     *
     * @param urls
     */
//    private void updateWhitelistedRetryUrls(List<String> urls) {
//
//        whiteListedUrls.clear();
//        L.v("#### PAYU", "MR Cleared whitelisted urls, length: " + whiteListedUrls.size());
//        whiteListedUrls.addAll(urls);
//        L.v("#### PAYU", "MR Updated whitelisted urls, length: " + whiteListedUrls.size());
//    }

    /**
     * Javascript interface to get the snooze config from initialize.js
     * This method will be called from getInitializeJS
     * <p/>
     * 1. Collect the object from javascript {@param snoozeConfig}
     * 2. Set the default snoozeLoadPercentage in sharedpref.
     * 3. Set the default snoozeLoadTime in sharedpref.
     * 4. Collect all the merchant specific urls and its loadPercentage, loadTime and put them in sharedpref.
     * 5. Get the default {@link PayUCBLifecycle#snoozeUrlLoadingTimeout} and {@link PayUCBLifecycle#snoozeUrlLoadingPercentage} from shared pref on {@link PayUCBLifecycle#onCreate(Bundle)}
     * 6. On every new page load   get the url from shard pref, initialize the waitingOTPTimer with new load percentage and load time,
     * <p/>
     * Shared pref storing format.
     * <p/>
     * key - url
     * value - percentage||timeout
     * <p/>
     * sample value of snoozeConfig {"default":[{"url":"default_payment_urls","time_out":"5","progress_percent":"20"}],"0MQaQP":[{"url":"url21||url22","time_out":"5","progress_percent":"50"},{"url":"url23","time_out":"5","progress_percent":"20"}]}
     * <p/>
     * TODO : probably need to used another shard pref. should not conflict with existing urls collections.
     * TODO : Js should not return * in case of all url instead it should return default_payment_urls. {@link CBConstant#DEFAULT_PAYMENT_URLS}
     *
     * @param snoozeConfig is the configuration for given bank code and the default values.
     */
    @JavascriptInterface
    public void setSnoozeConfig(String snoozeConfig) {
        snoozeConfigMap = cbUtil.storeSnoozeConfigInSharedPref(activity.getApplicationContext(), snoozeConfig);
    }

    /**
     * Use this method to disable PayUChromeLoader along with marking
     * forward journey complete
     * <p/>
     * IMPORTANT: To decide better on closing PayUChromeLoader, also see
     * {@link #progressBarVisibilityPayuChrome(int, String)}
     */
    @JavascriptInterface
    public void dismissPayULoader() {
        // payuChromeLoaderDisabled = true;
        if (activity != null && !activity.isFinishing() && progressDialog != null) {
            progressDialog.dismiss();
            progressDialog.cancel();
//            if (isAdded() &&null!=flFullScreenLoader)
//                flFullScreenLoader.setVisibility(View.GONE);
            // If dismissing payu loader after webpage not found there can be still more pages waiting to load
            // which might be recovered from retry option, so don't update forwardJourneyForChromeLoaderIsComplete
            // to true. Also, in case of webpageNoFound - don't start slow user warning
            if (!webpageNotFoundError) {
                // Ideally a dismiss call to PayUChromeLoader should mean that forward journey is complete
                // But it can also happen that PayUChromeLoader got dismissed due to loader waitingOTPTimer getting
                // finished even before redirect is complete, so this is more or less a calculated guess
                forwardJourneyForChromeLoaderIsComplete = true;
                L.v("Setting forwardJourneyForChromeLoaderIsComplete = true");
                // Assuming final bank page has loaded, start waitingOTPTimer to understand user interaction
                // if no activity is found in next 2 minutes, show slow user warning
                startSlowUserWarningTimer();


            }
        }
    }

    /**
     * After bank page is loaded start waitingOTPTimer which displays
     * slow user warning in case no interaction is detected within
     * 2 minutes
     */
    protected void startSlowUserWarningTimer() {

        L.v("Attempting to start slowUserCountDownTimer");

        if (slowUserCountDownTimer == null) {
            L.v("Starting slowUserCountDownTimer");
            /* DISABLING
            slowUserCountDownTimer = new CountDownTimer(10000, 1000) {
                @Override
                public void onTick(long l) {
                    // Just wait!
                    L.v( "Tik Tok: next 10secs elapsed" + l);
                }

                @Override
                public void onFinish() {
                    L.v( "Times UP!");
                    showSlowUserWarning();
                    dismissSlowUserWarningTimer();
                }
            };
            slowUserCountDownTimer.start();*/
        }

    }

    /**
     * Method to dismiss the slow user warning waitingOTPTimer
     */
    protected void dismissSlowUserWarningTimer() {
        if (slowUserCountDownTimer != null) {
            L.v("Shutting down slowUserCountDownTimer");
            slowUserCountDownTimer.cancel();
        }
    }


    public void otpClicked() {
        SMSOTPClicked = true;
        checkPermission();
        eventRecorded = CBAnalyticsConstant.OTP;
        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            mPassword = null;
            prepareSmsListener();
        }
    }

    /**
     * Custom onClick listener for cb's buttons.
     */
    public class ButtonOnclickListener implements View.OnClickListener {
        public void setView(View view_ed) {
        }

        @Override
        public void onClick(View v) {
            String str = "";
            if (v instanceof Button) // we have buttons.
                str = (((Button) v).getText()).toString();
            else if (v instanceof TextView) // we have textviews too!.
                str = (((TextView) v).getText()).toString();
            int code = getCode(str.toLowerCase());
            switch (code) {
                case REGENERATE_OTP:
                    try {
                        eventRecorded = CBAnalyticsConstant.REGENERATE;
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                        mPassword = null;
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_regen_otp)));
                        isListenerAttached = false;//Reattach listener to again ask for permission
                        permissionGranted = true;//Reset so that user knows that consent is working
                        prepareSmsListener();
                    } catch (JSONException e) {
                        L.e(e.getMessage());
                    }
                    break;
                case SMS_OTP:
                case OTP:
                    //backwardJourneyTransactionStarted = true;
                    SMSOTPClicked = true;
                    checkPermission();
                    eventRecorded = CBAnalyticsConstant.OTP;
                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                        mPassword = null;
                        prepareSmsListener();
                    }
                    break;
                case APPROVE:
               /*     try {
                        hideKeyboardForcefully();
                        mPassword = null;
                        checkLoading = false;
                        approve_flag = true;
                        onHelpUnavailable();
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        prepareSmsListener();
                   *//*     if (((EditText) view_edit.findViewById(R.id.otp_sms)).getText().toString().length() > 5) {
                            eventRecorded = CBAnalyticsConstant.APPROVED_OTP;
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                            addEventAnalytics(CBAnalyticsConstant.APPROVE_BTN_CLICK_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + ((TextView) view_edit.findViewById(R.id.otp_sms)).getText().toString() + "\")");
                            ((EditText) view_edit.findViewById(R.id.otp_sms)).setText("");
                        }*//*
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }*/
                    break;
                case ENTER_MANUALLY: {

                }
                break;

                case PASSWORD:
                case PIN:
                    //   backwardJourneyTransactionStarted = true;
                    pin_selected_flag = true;
                    approve_flag = true;
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    onHelpUnavailable();

                    if (cbSlideBarView != null)
                        cbSlideBarView.setVisibility(View.GONE);

                    if (cbTransparentView != null)
                        cbTransparentView.setVisibility(View.GONE);

                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                        eventRecorded = CBAnalyticsConstant.PASSWORD;
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                    } catch (JSONException e) {
                        L.e(e.getMessage());
                    }
                    break;

                case DEFAULT:
                    if (DEBUG)
                        Toast.makeText(activity.getApplicationContext(), "button text not matching any click listener option", Toast.LENGTH_SHORT).show();
                    break;
            }
        }
    }

    /**
     * Helper method to reload webview using JS reload, from server
     */
    public void reloadWVUsingJS() {
        cbWebView.loadUrl("javascript:window.location.reload(true)");
    }

    /**
     * Helper method to reload webview using WebView's native reload
     */
    public void reloadWVNative() {
        cbWebView.reload();
    }

    /**
     * Helper method to reload webview using JS reload, from cache
     */
    public void reloadWVUsingJSFromCache() {
        cbWebView.loadUrl("javascript:window.location.reload()");
    }


    private void retryPayment(View view) {

        if (view.getId() == R.id.button_retry_transaction) {
            snoozeCount++;
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_RETRY_CLICK);
            // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
        } else if (view.getId() == R.id.button_retry_anyway) {
            snoozeCount++;
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_TXN_PAUSED_USER_INTERACTION_TIME, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_TXN_PAUSED_WINDOW_ACTION, CBAnalyticsConstant.RETRY_ANYWAY_CLICK);
            // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
        }


        setTransactionStatusReceived(false);

        if (CBUtil.isNetworkAvailable(activity.getApplicationContext())) { // internet available.
            if (cbWebView.getUrl() != null && !(cbWebView.getUrl().contentEquals(CBConstant.PAYMENT_URL) || cbWebView.getUrl().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS)) && Bank.isUrlWhiteListed(cbWebView.getUrl())) {
                reloadWebView();
            } else {

                cbUtil.clearCookie(customBrowserConfig);
                if ((customBrowserConfig.getPostURL() != null && (customBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || customBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL))
                ) || (isS2SHtmlSupport && !TextUtils.isEmpty(surePayS2Surl) && !TextUtils.isEmpty(surePayS2SPayUId))) {
                    // mark the previous txn as sure pay canceled.
                    markPreviousTxnAsUserCanceled(cbUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.SURE_PAY_CANCELLED, customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, customBrowserConfig.getTransactionID(), ""));
                }
                if (customBrowserConfig.getPostURL() != null && customBrowserConfig.getPayuPostData() != null && surePayS2Surl == null) {
                    reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                } else if (surePayS2Surl != null) {
                    reloadWebView(surePayS2Surl, null);
                }
            }

            dismissSnoozeWindow();

            // Setting slow user warning waitingOTPTimer to null, so that it can be resumed
            slowUserCountDownTimer = null;

            if (view.getId() == R.id.button_retry_anyway) { // if it is retry anyway kill service and remove notification.
                // Kill snooze service and remove if any notification launched.
//                killSnoozeService();
                // if any notification from snooze service lets clear it.
                NotificationManager mNotificationManager = (NotificationManager) activity.getSystemService(Context.NOTIFICATION_SERVICE);
                if (null != mNotificationManager)
                    mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);

            }

        } else { // no internet found.
            // setSurePayResumeStatus(); // no need to since the url does not rusumed successfully.
            // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, CBConstant.MSG_NO_INTERNET);
            Toast.makeText(activity.getApplicationContext(), CBConstant.MSG_NO_INTERNET, Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * Javascript interface to set the sure pay internet restored window time ttl in Milli seconds.
     * Sample JS code:
     * var surePayInternetRestoredTTL = function(merchantkey){
     * // default TTL value
     * // var defaultTTLValue = 5000; // 5 sec.
     * var merchantSpecificTTLValues = {};
     * merchantSpecificTTLValues['0MQaQP'] = 10000;
     * merchantSpecificTTLValues['merchantKey2'] = 4000;
     * <p>
     * var ttl = merchantSpecificTTLValues[merchantkey];
     * if(ttl){
     * ttl = ttl.toString();
     * PayU.spResumedWindowTTL(ttl);
     * }
     * }
     * javascript interface has the highest priority, meaning it will override the default/merchant configured values.
     *
     * @param ttl time in milli
     */
    @JavascriptInterface
    public void spResumedWindowTTL(String ttl) {
        try {
            mInternetRestoredWindowTTL = Integer.parseInt(ttl);
        } catch (Exception e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "spResumedWindowTTL_" + e.getMessage());
        }
    }

    /**
     * Method to keep the resume url status.
     * We should log CBAnalyticsConstant.SNOOZE_RESUME_URL event only after successful resume.
     * ie, If the url get started resuming and failed to complete, then dont log
     */
    private void setSurePayResumeStatus(boolean status) {
        isSurePayResumed = status;
    }


    public void reloadWebViewUrl() {
        if (CBUtil.isNetworkAvailable(activity.getApplicationContext())) { // internet available.
            if (cbWebView.getUrl() != null && !(cbWebView.getUrl().contentEquals(CBConstant.PAYMENT_URL)
                    || cbWebView.getUrl().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS))
                    && Bank.isUrlWhiteListed(cbWebView.getUrl())) {
                reloadWebView();
            }
        } else {
            // no handling for network retry failure from sdk, left for merchant to cancel the transaction
            addEventAnalytics(CBAnalyticsConstant.NO_INTERNET_FOUND, "reloadWebViewUrl : Internet not available");
        }
    }

    /**
     * Method to log analytics form javascript.
     * Created with the intention of logging webview 53 54 updates events.
     * However this method should be used, to all the analytics explicit event logs.
     * Future enhancement: This method should be used, to log all the js exception to detect
     * if any bank page changed, or any exception happened on click of any event.
     *
     * @param event, expecting a json object
     */
    @JavascriptInterface
    public void logPayUAnalytics(String event) {
        try {
            JSONObject analyticsObject = new JSONObject(event);
            Iterator<String> keysIterator = analyticsObject.keys();
            while (keysIterator.hasNext()) {
                String key = keysIterator.next();
                //
                if (null == mAnalyticsMap.get(key) || !mAnalyticsMap.get(key).contentEquals(analyticsObject.get(key).toString())) {
                    mAnalyticsMap.put(key, analyticsObject.get(key).toString());
                    addEventAnalytics(key, analyticsObject.get(key).toString());
                }
            }
        } catch (JSONException e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "logPayUAnalytics_" + e.getMessage());
        }
    }


    private void addErrorData(String key, String logMsg) {
        try {
            int i = 0;
            while (logMsg.length() > 0) {
                i++;
                String value = "";
                if (logMsg.length() > 128) {
                    value = logMsg.substring(0, 128);
                    logMsg = logMsg.substring(128);
                } else {
                    value = logMsg;
                    logMsg = "";
                }
                addEventAnalytics(key + "_" + i, value);
            }
        } catch (Exception e) {
            if (null != e && null != e.getMessage())
                addEventAnalytics(CBAnalyticsConstant.CB_EXCEPTION, "addErrorData_" + e.getMessage());
        }
    }

    @Override
    void hideBackButtonDialog() {
        if (dialog != null) {
            dialog.dismiss();
            dialog = null;
        }
    }

    /**
     * Function to check if OTP field is numeric or alphanumeric
     *
     * @param isOTPKeyboardNumeric true if field is numeric else false
     */
    @JavascriptInterface
    public void isOTPKeyboardNumeric(boolean isOTPKeyboardNumeric) {
    }

    /***
     * Save the key/value pair in Shared Preference by JS
     *
     * @param key Value of Key
     * @param value Value to be stored corresponding to key
     * @param isPersistent If key is stored in persistent storage
     */
    @JavascriptInterface
    public void setJSData(String key, String value, boolean isPersistent) {
        if (isPersistent) {
            cbUtil.setStringSharedPreference(activity, key, value);
        } else {
            cbUtil.setJSStringSharedPreference(activity, key, value);
        }
    }

    /**
     * Set Key in SharedPreference
     *
     * @param key   value of Key
     * @param value Value to be stored corresponding to key
     */
    @JavascriptInterface
    public void setJSData(String key, String value) {
        setJSData(key, value, false);
    }

    /***
     * Get the value for key stored by JS in Shared Preference
     *
     * @param key Value of key
     * @return Value corresponding to key else returns {@link com.payu.custombrowser.util.CBConstant#UNDEFINED}
     */
    @JavascriptInterface
    public String getJSData(String key) {
        return getJSData(key, false);
    }

    /**
     * Get value for key present in SharedPreference
     *
     * @param key          Key to search for
     * @param isPersistent If key is stored in persistent storage
     * @return Value of Key.
     */
    @JavascriptInterface
    public String getJSData(String key, boolean isPersistent) {
        return cbUtil.getJSStringSharedPreference(activity, key, isPersistent);
    }

    /**
     * Function to remove JS data from Shared Preference
     *
     * @param key          to be removed
     * @param isPersistent If key is in persistent storage or not
     */
    @JavascriptInterface
    public void removeJSData(String key, boolean isPersistent) {
        if (isPersistent) {
            cbUtil.removeFromSharedPreferences(activity, key);
        } else {
            cbUtil.removeJSStringSharedPreference(activity, key);
        }
    }

    /**
     * Function to remove key from CB JS preference
     *
     * @param key to be removed from CB JS preference
     */
    @JavascriptInterface
    public void removeJSData(String key) {
        removeJSData(key, false);
    }

    public void logCBAnalytics(Context context, String ctaName, String eventName, String time) {
        CBUtil.logData(context, ctaName, paymentType, eventName, amount, bankcode, paymentType, "", time);
    }
}