package com.payu.checkoutpro.utils

import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.india.Payu.PayuConstants

object DataConstant {

    fun supportedNBPaymentState(): Array<String> {
        return arrayOf(PaymentState.Default.name, PaymentState.BankDetails.name)
    }

    fun supportedWalletPaymentState(): Array<String> {
        return arrayOf(
            PaymentState.Default.name,
            PaymentState.MobileEligibility.name,
            PaymentState.Mobile.name,
            PaymentState.OLW.name
        )
    }

    fun supportedUPIPaymentState(): Array<String> {
        return arrayOf(
            PaymentState.Default.name,
            PaymentState.INTENT.name,
            PaymentState.VPAEligibility.name
        )
    }

    fun supportedDcEmiPaymentState(): Array<String> {
        return arrayOf(
            PaymentState.CardnumMobileTenureEligibility.name,
            PaymentState.CardMobileTenureEligibility.name
        )
    }

    fun supportedCCEmiPaymentState(): Array<String> {
        return arrayOf(PaymentState.CardTenureEligibility.name)
    }

    fun supportedCardLessEmiPaymentState(): Array<String> {
        return arrayOf(
            PaymentState.CardnumTenureEligibility.name,
            PaymentState.MobileEligibility.name,
            PaymentState.MobilePanTenureEligibility.name
        )
    }

    fun supportedCardPaymentState(): Array<String> {
        return arrayOf(PaymentState.Default.name)
    }

    fun supportedMealCardPaymentState(): Array<String> {
        return arrayOf(PaymentState.FullCard.name)
    }

    fun supportedBnplPaymentState(): Array<String> {
        return arrayOf(
            PaymentState.MobileEligibility.name
        )
    }

    fun supportedRedirectionPaymentState(): Array<String> {
        return arrayOf(
            PaymentState.Default.name,
            PaymentState.INTENT.name,
            PaymentState.FullCard.name
        )
    }

    fun supportedUpiSiIntentAppList(): ArrayList<String> {
        return arrayListOf(
            PayUCheckoutProConstants.CP_PAYTM,
            PayUCheckoutProConstants.CP_BHIM,
            PayUCheckoutProConstants.CP_PHONEPE
        )
    }

    fun upihandles(): ArrayList<String> {
        return arrayListOf<String>(
            "@okicici",
            "@okhdfcbank",
            "@oksbi",
            "@okaxis",
            "@paytm",
            "@ybl",
            "@ibl",
            "@axl",
            "@upi",
            "@icici",
            "@waicici",
            "@waaxis",
            "@wahdfcbank",
            "@wasbi",
            "@apl",
            "@yapl"
        )
    }

    fun supportedPaymentTypesForOtpAssist(): Set<PaymentType> {
        return setOf(
            PaymentType.CARD,
            PaymentType.BNPL
        )
    }

    fun supportedBankCodesForOtpAssist(): Array<String> {
        return arrayOf("HDFCCL", "ICICIC", "ZESTMON")
    }
    fun supportedClosedLoopWalletPaymentState(): Array<String> {
        return arrayOf(PaymentState.Default.name)
    }

    fun upiTopAppsDescending(upiAppOrder: String = "") : MutableList<String> {
        var upiTopAppsList = mutableListOf<String>()

        if (!upiAppOrder.isNullOrEmpty()) {
            upiTopAppsList = getMerchantPreferredUpiAppList(upiAppOrder)
        }

        upiTopAppsList.add(PayUCheckoutProConstants.GPAY.lowercase())
        upiTopAppsList.add(PayUCheckoutProConstants.PAYTM.lowercase())
        upiTopAppsList.add(PayUCheckoutProConstants.PHONE_PE.lowercase())
        upiTopAppsList.add(PayUCheckoutProConstants.AMAZON.lowercase())
        upiTopAppsList.add(PayUCheckoutProConstants.CRED.lowercase())

        return  upiTopAppsList.distinct().reversed().toMutableList()
    }

    private fun getMerchantPreferredUpiAppList(upiAppsString: String) : MutableList<String> {
        val upiList = upiAppsString.split('|').map { it.trim() }
        return upiList.toMutableList()
    }

    fun offerNotSupportedList(): Array<String> {
        return arrayOf(PayuConstants.NEFT_RTGS.lowercase(), PayuConstants.MC)
    }

    internal fun supportedUpiSiApps(): ArrayList<String> {
        return arrayListOf(
            "Paytm",
            "Bhim",
            "Phonepe",
            "Gpay",
            "Amazonpay",
            "BHIM BOI",
            " BHIM Canara",
            " BHIM AxisPay",
            " Dak Pay",
            " Mobikwik",
            "Slice",
            "DBS",
            "BHIM Indus Pay",
            "ICICI iMobile",
            "BHIM DLB",
            "Payzapp",
            "Groww"
        )
    }

    internal fun supportedUpiHandles(): ArrayList<String> {
        return arrayListOf(
            "@upi",
            "@ybl",
            "@ibl",
            "@axl",
            "@okhdfcbank",
            "@okicici",
            "@apl",
            "@okaxis",
            "@boi",
            " @cnrb",
            " @axisbank",
            "@postbank",
            "@ikwik",
            "@sliceaxis",
            "@dbs",
            "@indus",
            "@icici",
            "@dlb",
            "@pz",
            "@yesg",
            "@yapl",
            "@oksbi",
            "@equitas",
            "@niyoicici",
            "@naviaxis",
            "@waicici",
            "@centralbank",
            "@pingpay",
            "@iob",
            "@yespay",
            "@kotak",
            "@kotak811",
            "@shriramhdfcbank",
            "@axisb",
            "@abcdicici",
            "@sbipa",
            "@payu",
            "@timecosmos",
            "@sib",
            "@ptaxis",
            "@ptyes",
            "@ptsbi",
            "@freoicici",
            "@pthdfc",
            "@mboi",
            "@superyes",
            "@seyes",
            "@fkaxis",
            "@yesfam",
            "@jkb",
            "@hsbc",
            "@slicepay",
            "@yespop",
            "@oneyes",
            "@bpunity",
            "@kphdfc",
            "@gwaxis",
            "@mvhdfc",
            "@paulpay",
            "@yestp",
            "@sib"
        )
    }

}