package com.payu.checkoutpro.utils

import com.payu.base.models.FetchOfferDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.PayUApiResponse
import com.payu.base.models.PaymentMode
import com.payu.base.models.QuickOptionsModel

object ApiResponseRepo {
    var payuApiFetchOffer: PayUApiResponse<FetchOfferDetails>? = null
    var moreOptionsResponse: PayUApiResponse<ArrayList<PaymentMode>>? = null
    var gvOptionsResponse: PayUApiResponse<QuickOptionsModel>? = null
    var payuFetchOfferListener: ((FetchOfferDetails?) -> Unit?)? = null
    var moreOptionsListener: ((ArrayList<PaymentMode>?) -> Unit?)? = null
    var gvQuickOptionsListener: ((QuickOptionsModel?) -> Unit?)? = null


    fun setPayUFetchOfferResponse(fetchOfferDetails: FetchOfferDetails?) {
        payuApiFetchOffer?.inProgress = false
        this.payuFetchOfferListener = payuApiFetchOffer?.listener
        payuApiFetchOffer?.response = fetchOfferDetails
        payuFetchOfferListener?.invoke(payuApiFetchOffer?.response)
        payuFetchOfferListener = null
    }

    fun getPayUApiResponse(offerListener: (FetchOfferDetails?) -> Unit?) {
        this.payuFetchOfferListener = offerListener
        payuFetchOfferListener?.invoke(payuApiFetchOffer?.response)
        payuFetchOfferListener = null
    }

    fun setL1MoreOptionsResponse(moreOptionList: ArrayList<PaymentMode>?) {
        moreOptionsResponse?.response = moreOptionList
        this.moreOptionsListener = moreOptionsResponse?.listener
        moreOptionsResponse?.inProgress = false
        if (InternalConfig.userAccountInfoList.isNullOrEmpty() && InternalConfig.isQuickPayEnabled && InternalConfig.isQuickPayBottomSheetEnabled) {
            gvOptionsResponse?.let {
                updateGvResponse(it)
            }
        } else {
            moreOptionsListener?.invoke(moreOptionsResponse?.response)
            moreOptionsListener = null
        }
    }

    fun getMoreOptionsResponse(l1MoreOptionsListener: (ArrayList<PaymentMode>?) -> Unit?) {
        this.moreOptionsListener = l1MoreOptionsListener
        moreOptionsListener?.invoke(moreOptionsResponse?.response)
        moreOptionsListener = null
    }

    fun setGvResponse(gvResponse: PayUApiResponse<QuickOptionsModel>) {
        this.gvOptionsResponse = gvResponse
        this.gvQuickOptionsListener = gvResponse.listener
        moreOptionsResponse?.let {
            updateGvResponse(gvResponse)
        }

    }

    fun setGvResponseForClwAndSodexo(gvResponse: PayUApiResponse<QuickOptionsModel>) {
        this.gvOptionsResponse = gvResponse
        this.gvQuickOptionsListener = gvResponse.listener
        gvQuickOptionsListener?.invoke(gvResponse.response)
        gvQuickOptionsListener = null
    }

    fun getGvResponse(gvReOptionsListener: (QuickOptionsModel?) -> Unit?) {
        this.gvQuickOptionsListener = gvReOptionsListener
        gvQuickOptionsListener?.invoke(this.gvOptionsResponse?.response)
        gvQuickOptionsListener = null
    }

    private fun updateGvResponse(gvResponse: PayUApiResponse<QuickOptionsModel>) {
        gvQuickOptionsListener?.invoke(gvResponse.response)
        moreOptionsListener?.invoke(this.moreOptionsResponse?.response)
        gvQuickOptionsListener = null
        moreOptionsListener = null
    }

}