package com.payu.checkoutpro.reConverter

import android.content.Context
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.WalletOption
import com.payu.checkoutpro.utils.AndroidUtils
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.india.Model.QuickPay.QuickPaySavedOption
import com.payu.india.Model.QuickPay.RecommendedOptions
import com.payu.india.Payu.PayuConstants

object WalletPaymentModeConverter {

    fun getSavedWalletPaymentMode(
        context: Context,
        quickPaySavedOption: QuickPaySavedOption
    ): ArrayList<PaymentOption> {
        val savedPaymentOption = WalletOption()
        val optionDetail: ArrayList<PaymentOption> = ArrayList()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.WALLET]
        val paymentOption: WalletOption? =
            paymentModeMap?.get(quickPaySavedOption.ibiboCode) as? WalletOption
        if (paymentOption != null) {
            savedPaymentOption.bankName = quickPaySavedOption.pgTitle
            savedPaymentOption.otherParams = CommonUtils.getOtherParamsMap(
                PayuConstants.PAYU_CASH_CARD,
                quickPaySavedOption.ibiboCode
            )
            savedPaymentOption.isBankDown = !quickPaySavedOption.isPgUP
            savedPaymentOption.paymentType = PaymentType.WALLET
            savedPaymentOption.subText = quickPaySavedOption.pgDetails
            savedPaymentOption.phoneNumber = quickPaySavedOption.phoneNumber
            PaymentModeConverter.updateTaxValue(savedPaymentOption, PaymentType.WALLET)
            val pgAppVersion = AndroidUtils.doesPhonePeAppExist(context)
            if (quickPaySavedOption.ibiboCode.equals(
                    PayUCheckoutProConstants.CP_PPSDKLES,
                    ignoreCase = true
                )
            ) {
                if (!pgAppVersion.isNullOrEmpty()) {
                    savedPaymentOption.pgAppVersion = pgAppVersion
                    optionDetail.add(savedPaymentOption)
                }
            } else {
                optionDetail.add(savedPaymentOption)
            }
        }
        return optionDetail
    }

    fun getREWalletPaymentOption(recommendedOptions: RecommendedOptions): ArrayList<PaymentOption> {
        val optionDetails = ArrayList<PaymentOption>()
        val paymentModeMap = ParserUtils.paymentOptionMap[PaymentType.WALLET]
        val paymentOption: WalletOption? =
            paymentModeMap?.get(recommendedOptions.ibiboCode) as? WalletOption
        if (paymentOption != null) {
            val othersParamMap =
                paymentOption?.otherParams as? HashMap<String, String>
            if (othersParamMap?.get(PayUCheckoutProConstants.CP_BANK_CODE)
                    ?.isNotEmpty() == true
            )
                optionDetails.add(paymentOption)
        }
        return optionDetails
    }

    internal fun getDeleteApiSavedPaymentMode(paymentOption: WalletOption): QuickPaySavedOption {
        val quickPaySavedOption = QuickPaySavedOption()
        quickPaySavedOption.paymentType = PayUCheckoutProConstants.CP_CASH_CARD
        quickPaySavedOption.pgTitle = paymentOption.bankName
        quickPaySavedOption.ibiboCode = CommonUtils.getValueFromPaymentOption(
            PayUCheckoutProConstants.CP_BANK_CODE,
            paymentOption.otherParams as? java.util.HashMap<String, Any?>
        )
        return quickPaySavedOption
    }
}