package com.payu.checkoutpro.parser

import android.util.Log
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.parser.constants.PayUHybridKeys
import com.payu.checkoutpro.parser.utils.PaymentParamParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants

object PaymentParamParser {

    internal fun convertHashMapToPaymentParams(map: HashMap<String, Any>): PayUPaymentParams {
        val params = PayUPaymentParams.Builder()
        params.setAmount(map[PayUHybridKeys.PaymentParam.amount].toString())
        params.setTransactionId(map[PayUHybridKeys.PaymentParam.transactionId].toString())
        params.setKey(map[PayUHybridKeys.PaymentParam.key].toString())
        params.setProductInfo(map[PayUHybridKeys.PaymentParam.productInfo].toString())
        params.setSurl(map[PayUHybridKeys.PaymentParam.surl].toString())
        params.setFurl(map[PayUHybridKeys.PaymentParam.furl].toString())


        try {
            params.setIsProduction(
                map[PayUHybridKeys.PaymentParam.environment].toString().toInt() == 0
            )
        } catch (e: NumberFormatException) {
            Log.d(this.javaClass.simpleName, "Exception caught: "+e.message)
        }

        (map[PayUHybridKeys.PaymentParam.additionalParam] as? HashMap<String, Any?>)?.let { additionalParamMap ->
            val paymentSource =
                additionalParamMap.remove(PayUHybridKeys.PaymentParam.AdditionalParam.payment)
            additionalParamMap[PayUHybridKeys.PaymentParam.AdditionalParam.paymentSource] =
                paymentSource
            val sourceId = additionalParamMap[PayUHybridKeys.PaymentParam.AdditionalParam.sourceId]
            additionalParamMap.remove(PayUHybridKeys.PaymentParam.AdditionalParam.sourceId)
            additionalParamMap[PayUCheckoutProConstants.SODEXO_SOURCE_ID] = sourceId
            params.setAdditionalParams(additionalParamMap)
        }

        if (map.containsKey(PayUHybridKeys.PaymentParam.payUSIParams))
            params.setPayUSIParams(PaymentParamParserUtils.getSIParams(map[PayUHybridKeys.PaymentParam.payUSIParams] as HashMap<String, Any?>))

        params.setEmail(map[PayUHybridKeys.PaymentParam.email].toString())
        params.setPhone(map[PayUHybridKeys.PaymentParam.phone].toString())
        params.setFirstName(map[PayUHybridKeys.PaymentParam.firstName].toString())
        (map[PayUHybridKeys.PaymentParam.userCredential] as? String)?.let { it ->
            params.setUserCredential(it)
        }

        if (map.containsKey(PayUHybridKeys.PaymentParam.splitPaymentDetails))
            params.setSplitPaymentDetails(map[PayUHybridKeys.PaymentParam.splitPaymentDetails].toString())

        if (map.containsKey(PayUHybridKeys.PaymentParam.userToken))
            params.setUserToken(map[PayUHybridKeys.PaymentParam.userToken].toString())
        if (map.containsKey(PayUHybridKeys.PaymentParam.skuDetails)) {
            val skuDetails =
                map[PayUHybridKeys.PaymentParam.skuDetails] as HashMap<String, Any>
            if (skuDetails.containsKey(PayUHybridKeys.PaymentParam.skus)) {
                params.setSkuDetails(
                    PaymentParamParserUtils.getSkuDetails(
                        skuDetails[PayUHybridKeys.PaymentParam.skus] as List<HashMap<String, Any>>
                    )
                )
            }
        }
        if (map.containsKey(PayUHybridKeys.PaymentParam.payUBeneficiaryDetail)) {
            val beneficiaryDetailsMap =
                map[PayUHybridKeys.PaymentParam.payUBeneficiaryDetail] as? List<HashMap<String, Any>>
            params.setBeneficiaryDetailsList(
                PaymentParamParserUtils.getPayuBeneficiaryDetails(
                    beneficiaryDetailsMap ?: arrayListOf()
                )
            )
        }
        if (map.containsKey(PayUHybridKeys.PaymentParam.additionalCharges)) {
            params.setAdditionalCharges(
                map[PayUHybridKeys.PaymentParam.additionalCharges].toString()
            )
        }
        if (map.containsKey(PayUHybridKeys.PaymentParam.percentageAdditionalCharges)) {
            params.setPercentageAdditionalCharges(
                map[PayUHybridKeys.PaymentParam.percentageAdditionalCharges].toString()
            )
        }
        if (map.containsKey(PayUHybridKeys.PaymentParam.enforcementOfferKeys)) {
            val enforcementKeys =
                map[PayUHybridKeys.PaymentParam.enforcementOfferKeys] as? List<String>?
            enforcementKeys?.let {
                params.setEnforcementOfferKeys(
                    it
                )
            }
        }

        if (map.containsKey(PayUHybridKeys.PaymentParam.addressDetails))
            params.setAddressDetails(PaymentParamParserUtils.getAddressDetails(map[PayUHybridKeys.PaymentParam.addressDetails] as HashMap<String, Any?>))

        if (map.containsKey(PayUHybridKeys.PaymentParam.PAYU_PRODUCT))
            (map[PayUHybridKeys.PaymentParam.PAYU_PRODUCT] as? List<HashMap<String, Any>>)?.let {
                PaymentParamParserUtils.getWealthTechDetails(
                    it
                )
            }?.let { params.setPayUWealthProducts(it) }
        (map[PayUHybridKeys.PaymentParam.enableNativeOTP] as? Boolean)
            ?.let(params::setEnableNativeOtp)
        return params.build()
    }
}