package com.payu.checkoutpro.models

import com.payu.base.listeners.OnIFSCDetailsListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.PayUPaymentParams
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.india.Interfaces.FetchIFSCDetailsListener
import com.payu.india.Model.PayuResponse
import com.payu.india.Payu.PayuConstants
import com.payu.india.Payu.PayuErrors
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams

class FetchIFSCDetailsApiObject(
    payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val ifscCode: String,
    private val onIFSCDetailsListener: OnIFSCDetailsListener
) : V2BaseApiObject(payUPaymentParams, payuBizParams), FetchIFSCDetailsListener {


    override fun getHashName(): String = "fetch_IFSC"

    override fun callApi() {
        onIFSCDetailsListener.showProgressDialog(true)
        try {
            startTime = System.currentTimeMillis()
            val ifscDetailsTask = V2ApiTask(payuBizparams.key, payuConfig)
            ifscDetailsTask.fetchIfscDetails(ifscCode, this, this)
        } catch (e: Exception) {
            sendErrorResponse(e.message)
        }
    }

    private fun sendErrorResponse(errorMessage: String?, errorCode: Int? = null) {
        val errorResponse = ErrorResponse()
        errorResponse.errorMessage = errorMessage
        errorResponse.errorCode = errorCode
        onIFSCDetailsListener.showProgressDialog(false)
        onIFSCDetailsListener.onError(errorResponse)
    }

    override fun onIFSCDetailsReceived(payuResponse: PayuResponse?) {
        val timeTaken = System.currentTimeMillis() - startTime
        if (payuResponse?.responseStatus?.status.equals(PayuConstants.SUCCESS, ignoreCase = true)) {
            onIFSCDetailsListener.showProgressDialog(false)
            val ifscDetails = CommonUtils.getIFSCDetails(payuResponse)
            if (ifscDetails != null) {
                CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
                onIFSCDetailsListener.onIFSCDetailsReceived(ifscDetails)
            } else {
                CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, PayuErrors.ERROR_INVALID_IFSC_DETAILS, payuResponse?.responseStatus?.code)
                sendErrorResponse(PayuErrors.ERROR_INVALID_IFSC_DETAILS)
            }
        } else {
            CPAnalyticsUtils.logApiResponseFailure(getHashName(), timeTaken, payuResponse?.responseStatus?.result, payuResponse?.responseStatus?.code)
            sendErrorResponse(
                payuResponse?.responseStatus?.result,
                payuResponse?.responseStatus?.code
            )
        }
    }
}