package com.payu.checkoutpro.handlers

import com.payu.checkoutpro.utils.DataConstant
import com.payu.checkoutpro.utils.DataConstant.supportedUPIPaymentState
import com.payu.india.Model.PaymentProductDetails
import com.payu.india.Model.PayuResponse
import com.payu.india.Model.Upi

object CategoryHandler {

    fun filterDataOnBasisOfCategory(payuResponse: PayuResponse?) {
        if (payuResponse != null) {
            if (payuResponse.isCCEmiAvailable) {
                isCategoryHandled(
                    payuResponse.ccemi,
                    DataConstant.supportedCCEmiPaymentState()
                )
            }
            if (payuResponse.isDCEmiAvailable) {
                isCategoryHandled(
                    payuResponse.dcemi,
                    DataConstant.supportedDcEmiPaymentState()
                )
            }
            if (payuResponse.isCardLessEmiAvailable) {
                isCategoryHandled(
                    payuResponse.cardlessemi,
                    DataConstant.supportedCardLessEmiPaymentState()
                )
            }
            if (payuResponse.isCashCardAvailable) {
                isCategoryHandled(payuResponse.cashCard, DataConstant.supportedWalletPaymentState())
            }
            if (payuResponse.isSodexoAvailable) {
                isCategoryHandled(
                    payuResponse.mealCard,
                    DataConstant.supportedMealCardPaymentState()
                )
            }
            if (payuResponse.isSIBankListAvailable) {
                isCategoryHandled(payuResponse.siBankList, DataConstant.supportedNBPaymentState())
            }
            if (payuResponse.isUPIAvailableFoSI) isCategoryHandled(
                payuResponse.standingInstructions,
                supportedUPIPaymentState()
            )
            if (payuResponse.isGenericIntentAvailable && !isCategoryHandledForUpiPayments(
                    payuResponse.genericIntent
                )
            ) {
                payuResponse.genericIntent = null
            }
            if (payuResponse.isUpiAvailable && !isCategoryHandledForUpiPayments(payuResponse.upi)) {
                payuResponse.upi = null
            }
            if (payuResponse.isGoogleTezOmniAvailable && !isCategoryHandledForUpiPayments(
                    payuResponse.googleTezOmni
                )
            ) {
                payuResponse.googleTezOmni = null
            }
            if (payuResponse.isBnplAvailable) {
                isCategoryHandled(
                    payuResponse.bnpl,
                    DataConstant.supportedBnplPaymentState()
                )
            }
            if (payuResponse.isClosedLoopWalletPayAvailable) {
                isCategoryHandled(
                    payuResponse.closedLoopWallet,
                    DataConstant.supportedClosedLoopWalletPaymentState()
                )
            }
        }

    }

    private fun isCategoryHandled(
        paymentDetailsList: java.util.ArrayList<*>,
        paymentState: Array<String>
    ) {
        if (paymentDetailsList.size > 0) {
            val iterator = paymentDetailsList.iterator()
            while (iterator.hasNext()) {
                val value = iterator.next() as PaymentProductDetails
                if (value != null && paymentState.any { it.equals(value.category, ignoreCase = true) }) continue
                else iterator.remove()
            }
        }
    }

    private fun isCategoryHandledForUpiPayments(upi: Upi): Boolean {
        return supportedUPIPaymentState().contains(upi.category)
    }
}