package com.payu.checkoutpro.models

import com.payu.base.models.PayUPaymentParams
import com.payu.base.models.SetMPinResponse
import com.payu.checkoutpro.utils.AndroidUtils
import com.payu.checkoutpro.utils.CPAnalyticsUtils
import com.payu.checkoutpro.utils.OlwApiResponseParser
import com.payu.checkoutpro.utils.V2ApiHelper
import com.payu.india.Interfaces.V2ApiResponseListener
import com.payu.india.Model.ApiResponse
import com.payu.india.Model.Olw.SendOtpRequest
import com.payu.india.Model.Olw.SetMPinRequest
import com.payu.india.Payu.PayuConstants
import com.payu.india.Tasks.V2ApiTask
import com.payu.paymentparamhelper.PaymentParams
import org.json.JSONObject

class SetMPinApiObject(
    private val otp: String,
    private val deviceId: String,
    private val mPin: String,
    private val mobile: String,
    private val action: String,
    private val walletIdentifier: String,
    private val bankCode: String,
    internal val payuBizParams: PaymentParams,
    payUPaymentParams: PayUPaymentParams,
    private val v2ApiResponseListener: (SetMPinResponse?) -> Unit?
) : V2BaseApiObject(payUPaymentParams, payuBizParams),
    V2ApiResponseListener<ApiResponse<JSONObject>> {

    override fun callApi() {
        startTime = System.currentTimeMillis()
        val sendOTpRequest =
            SendOtpRequest.Builder().setRequestDateTime(AndroidUtils.getRequestDateTimeFormat())
                .setClientTxnId(System.currentTimeMillis().toString()).setCustomerMobile("91$mobile")
                .build()
        val setMPinRequest = SetMPinRequest.Builder().setSendOtpRequest(sendOTpRequest).setOtp(otp)
            .setDeviceId(deviceId).setNewMpin(mPin).setAction(action).build()
        val v2ApiTask = V2ApiTask(payuBizparams.key, payuConfig)
        v2ApiTask.v2ApiCall(
            setMPinRequest.json,
            getHashName(),
            V2ApiHelper.getHeaderHashMap(walletIdentifier, bankCode),
            this,
            this
        )
    }

    override fun getHashName() = PayuConstants.PAYU_SET_MPIN

    override fun onApiResponse(apiResponse: ApiResponse<JSONObject>?) {
        //todo: uncomment on actual api integration
        val timeTaken = System.currentTimeMillis() - startTime
        if (apiResponse?.status == 200) {
            CPAnalyticsUtils.logApiResponseSuccess(getHashName(), timeTaken, payuConfig.data)
        } else {
            CPAnalyticsUtils.logApiResponseFailure(
                getHashName(),
                timeTaken,
                apiResponse?.payuResponse.toString(),
                apiResponse?.status
            )
        }
        if (apiResponse?.payuResponse != null)
            v2ApiResponseListener.invoke(
                OlwApiResponseParser.getSetMPinResponse(
                    apiResponse.payuResponse,
                    apiResponse.status
                )
            )
        else v2ApiResponseListener.invoke(null)
    }
}