package com.payu.checkoutpro.models

import android.app.Activity
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.webkit.WebView
import androidx.fragment.app.Fragment
import com.payu.base.listeners.BaseTransactionListener
import com.payu.base.models.*
import com.payu.base.models.CardOption
import com.payu.base.models.EMIOption
import com.payu.base.models.ErrorResponse
import com.payu.base.models.InternalConfig
import com.payu.base.models.PayUSIParams
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.PayuToolbar
import com.payu.base.models.SavedCardOption
import com.payu.base.models.SodexoCardOption
import com.payu.base.models.UPIOption
import com.payu.base.models.WalletOption
import com.payu.checkoutpro.layers.PayUbizApiLayer
import com.payu.checkoutpro.utils.CommonUtils
import com.payu.checkoutpro.utils.DataConstant
import com.payu.checkoutpro.utils.ParserUtils
import com.payu.checkoutpro.utils.PayUCheckoutProConstants
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_BANK_CODE
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_OLAM
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_PPINTENT
import com.payu.checkoutpro.utils.PayUCheckoutProConstants.CP_PPSDKLES
import com.payu.checkoutpro.utils.PaymentHelper
import com.payu.checkoutpro.utils.SharedPrefsUtils
import com.payu.india.Payu.PayuConstants
import com.payu.india.Payu.PayuErrors
import com.payu.india.PostParams.PaymentPostParams
import com.payu.olamoney.utils.PayUOlaMoneyPaymentParams
import com.payu.paymentparamhelper.OlwParams
import com.payu.paymentparamhelper.PaymentParams
import com.payu.paymentparamhelper.PostData
import com.payu.paymentparamhelper.siparams.BeneficiaryDetails
import com.payu.paymentparamhelper.siparams.SIParams
import com.payu.paymentparamhelper.siparams.SIParamsDetails
import com.payu.ui.model.listeners.PayUCheckoutProListener

class MakePaymentApiObject(
    payuBizparams: PaymentParams,
    listener: Any?,
    private val payUbizApiLayer: PayUbizApiLayer,
    private val checkoutListener: PayUCheckoutProListener
) : PaymentRenderer(payuBizparams) {

    private val TAG = PayUCheckoutProConstants.MAKEPAYMENTAPIOBJECT

    internal var paymentType: PaymentType? = null
    internal var context: Activity? = null
    private var baseTransactionListener: BaseTransactionListener? = null
    private var uiBaseTransactionListener: BaseTransactionListener? = null

    internal var toolbar: PayuToolbar? = null
    internal var paymentOption: PaymentOption? = null
        set(value) {
            field = value
            updateBizParams(value)
        }

    private fun updateBizParams(value: PaymentOption?) {

        if (value?.ifscCode.isNullOrEmpty().not()) payuBizparams.ifscCode = value?.ifscCode
        if (value?.accountNumber.isNullOrEmpty().not()) payuBizparams.beneficiaryAccountNumber =
            value?.accountNumber


        if(InternalConfig.selectedOfferInfo == null && InternalConfig.userSelectedOfferInfo == null){
            payuBizparams.offerKey = null
        }
        value?.let {
            if (((it is EMIOption) || (it is UPIOption)) && !it.phoneNumber.isNullOrEmpty())
                payuBizparams.phone = it.phoneNumber

            // TODO need to optimize, temp fix
            if (it.paymentType == PaymentType.UPI_INTENT) {
                val phoneNumber = context?.applicationContext?.let { it1 ->
                    SharedPrefsUtils.getLoggedInPhoneNumber(
                        it1
                    )
                }
                if (!phoneNumber.isNullOrEmpty()) {
                    payuBizparams.phone = phoneNumber
                }
            }
        }
        if (InternalConfig.selectedOfferInfo == null || InternalConfig.selectedOfferInfo?.isSkuOffer == false) payuBizparams.skuCartDetails =
            null
        else if (InternalConfig.userSelectedOfferInfo?.isSkuOffer == true) {
            val (sku, isAutoApplied) = ParserUtils.getSkuJson(payUbizApiLayer.payUPaymentParams, false)
            val skuJsonDetails = CommonUtils.getSKUPaymentJson(payUbizApiLayer.payUPaymentParams)
            sku?.put(PayuConstants.AMOUNT, payUbizApiLayer.payUPaymentParams.amount)
            sku?.put(PayuConstants.P_ITEMS, skuJsonDetails?.first)
            payuBizparams.skuCartDetails = sku?.toString()
            payuBizparams.offerKey = null
        }

        InternalConfig.outletId?.let {
            payuBizparams.outletId = it.toString()
        }
        if (InternalConfig.selectedOfferInfo?.isValid == false) payuBizparams.offerKey = null

        payuBizparams.storeCard = if (value?.shouldSaveCard!!) {
            1
        } else 0
        if (!value.shouldSaveCard) {
            payuBizparams.deviceDetails = null
        }
        InternalConfig.isPricingCFCall?.let {
            if (it) appendPricingResponseIds(value)
        }
        if (value.paymentType == PaymentType.OPEN_LOOP_WALLET) {
            (value as? OlwPaymentOption)?.let { setOlwParams(it) }
        }
    }

    init {
        val handler = Handler(Looper.getMainLooper())
        this.uiBaseTransactionListener = listener as BaseTransactionListener?
        this.baseTransactionListener = object : BaseTransactionListener {
            override fun onError(errorResponse: ErrorResponse) {
                handler.post { uiBaseTransactionListener?.onError(errorResponse) }
            }

            override fun onPaymentSuccess(response: Any) {
                handler.post { uiBaseTransactionListener?.onPaymentSuccess(response) }
            }

            override fun onPaymentFailure(response: Any) {
                handler.post { uiBaseTransactionListener?.onPaymentFailure(response) }
            }

            override fun onPaymentCancel() {
                handler.post { uiBaseTransactionListener?.onPaymentCancel() }
            }

            override fun loadNextState(paymentModel: PaymentModel) {
                handler.post { uiBaseTransactionListener?.loadNextState(paymentModel) }
            }

            override fun loadNextState(fragment: Fragment?) {
                handler.post { uiBaseTransactionListener?.loadNextState(fragment) }
            }

            override fun setWebViewProperties(webView: WebView?, bank: Any?) {
                handler.post { uiBaseTransactionListener?.setWebViewProperties(webView, bank) }
            }

            override fun loadRetryPaymentOption() {
                handler.post { uiBaseTransactionListener?.loadRetryPaymentOption() }
            }

            override fun showLoaderScreen(showLoader: Boolean) {
                handler.post { uiBaseTransactionListener?.showLoaderScreen(showLoader) }
            }

            override fun showProgressDialog(showDialog: Boolean) {
                handler.post { uiBaseTransactionListener?.showProgressDialog(showDialog) }
            }
        }
    }


    override fun render(map: HashMap<String, String?>): Fragment? {
        if (!payUbizApiLayer.payUPaymentParams.splitPaymentDetails.isNullOrEmpty()) {
            payuBizparams.splitPaymentDetails =
                payUbizApiLayer.payUPaymentParams.splitPaymentDetails
        }

        val hash = map[getHashName()]

        Log.d(TAG, "PaymentType =" + paymentType)
        return when (paymentType) {

            PaymentType.NB, PaymentType.UPI_INTENT, PaymentType.NEFTRTGS -> makeNetbankingPayment(
                paymentOption as PaymentOption,
                map[getHashName()]
            )

            PaymentType.WALLET -> makeWalletPayment(
                paymentOption as WalletOption,
                map[getHashName()]
            )

            PaymentType.CARD -> {

                if (paymentOption is SavedCardOption)
                    makeSavedCardPayment(paymentOption as SavedCardOption, hash)
                else
                    makeCardPayment(paymentOption as CardOption, hash)
            }

            PaymentType.UPI -> makeUpiCollectFlowPayment(paymentOption as UPIOption, hash)
            PaymentType.EMI -> {
                val hashMap = paymentOption?.otherParams as? HashMap<String, Any?>

                if (hashMap != null
                    && hashMap.containsKey(CP_BANK_CODE)
                    && (hashMap[CP_BANK_CODE] as? String) != null
                ) {
                    val bankCode = hashMap[CP_BANK_CODE].toString()
                    if (PayUCheckoutProConstants.CP_LAZYPAY.equals(bankCode, ignoreCase = true)) {
                        payuBizparams.bankCode = hashMap[CP_BANK_CODE] as? String
                        payuBizparams.hash = hash
                        makePayment(paymentOption!!)
                    } else {
                        makeEMIPayment(paymentOption as EMIOption, hash)
                    }
                } else {
                    null
                }
            }

            PaymentType.SODEXO -> makeSodexoPayment(paymentOption as SodexoCardOption, hash)
            PaymentType.CLOSED_LOOP_WALLET -> makeClosedLoopWalletPayment(
                paymentOption as SodexoCardOption,
                hash
            )

            PaymentType.BNPL -> paymentOption?.let { makeBnplPayment(it, hash) }
            PaymentType.OPEN_LOOP_WALLET -> paymentOption?.let {
                payuBizparams.loadAmount = (it as? OlwPaymentOption)?.loadAmount
                makeNetbankingPayment(it, hash)
            }
            else -> makeCardPayment(paymentOption as CardOption, hash)
        }
    }

    private fun makeUpiCollectFlowPayment(upiOption: UPIOption, hash: String?): Fragment? {
        val bankCode = CommonUtils.getValueFromPaymentOption<String>(
            CP_BANK_CODE,
            upiOption.otherParams as? HashMap<String, Any?>
        )
        if (bankCode != null) {
            payuBizparams.bankCode = bankCode
            payuBizparams.hash = hash

            if (bankCode != PayuConstants.TEZOMNI) {
                payuBizparams.vpa = upiOption.vpa
            }
            val payuSIParams = payUbizApiLayer.payUPaymentParams.payUSIParams

            if (payuSIParams != null) {
                payuBizparams.siParams = setSIDetails(payuSIParams)
            }

            return makePayment(upiOption)
        }
        return null
    }

    private fun makeSodexoPayment(sodexoCardOption: SodexoCardOption, hash: String?): Fragment? {
        val bankCode = CommonUtils.getValueFromPaymentOption<String>(
            CP_BANK_CODE,
            sodexoCardOption.otherParams as? HashMap<String, Any?>
        )
//        if ( bankCode != null ) {
        if (sodexoCardOption.isNewCard) {
            payuBizparams.saveSodexoCard = if (sodexoCardOption.shouldSaveCard) 1 else 0
            payuBizparams.cardNumber = sodexoCardOption.cardNumber
            payuBizparams.expiryMonth = sodexoCardOption.expiryMonth
            payuBizparams.expiryYear = sodexoCardOption.expiryYear
            payuBizparams.cvv = sodexoCardOption.cvv
            payuBizparams.cardName = sodexoCardOption.nameOnCard
            payuBizparams.hash = hash
        }
        payuBizparams.bankCode = bankCode
        payuBizparams.hash = hash
        if (sodexoCardOption.isNewCard) {
            payuBizparams.sodexoSourceId = ""
        }
        return makePayment(sodexoCardOption)
//        }
    }

    private fun makeClosedLoopWalletPayment(
        sodexoCardOption: SodexoCardOption,
        hash: String?
    ): Fragment? {
        val bankCode = CommonUtils.getValueFromPaymentOption<String>(
            CP_BANK_CODE,
            sodexoCardOption.otherParams as? HashMap<String, Any?>
        )
        payuBizparams.bankCode = bankCode
        payuBizparams.hash = hash

        payuBizparams.walletUrn = sodexoCardOption.walletUrn
        payuBizparams.loadAmount = sodexoCardOption.loadAmount

        return makePayment(sodexoCardOption)
    }

    private fun makeWalletPayment(walletOption: WalletOption, hash: String?): Fragment? {
        val bankCode = CommonUtils.getValueFromPaymentOption<String>(
            CP_BANK_CODE,
            walletOption.otherParams as? HashMap<String, Any?>
        )
        if (bankCode != null) {
            payuBizparams.bankCode = bankCode
            payuBizparams.pgAppVersion = walletOption.pgAppVersion
            payuBizparams.hash = hash
            if (walletOption.phoneNumber.isNotEmpty()) payuBizparams.phone =
                walletOption.phoneNumber
            return makePayment(walletOption)
        }
        return null
    }

    /**
     * Function to make BNPL payment
     */
    private fun makeBnplPayment(bnplOption: PaymentOption, hash: String?): Fragment? {
        val bankCode = CommonUtils.getValueFromPaymentOption<String>(
            CP_BANK_CODE,
            bnplOption.otherParams as? HashMap<String, Any?>
        )
        if (bankCode != null) {
            payuBizparams.bankCode = bankCode
            payuBizparams.hash = hash
            if (bnplOption.phoneNumber.isNotEmpty()) payuBizparams.phone = bnplOption.phoneNumber
            return makePayment(bnplOption)
        }
        return null
    }

    private fun makeCardPayment(
        cardOption: CardOption,
        hash: String?
    ): Fragment? {
        payuBizparams.storeCard = if (cardOption.shouldSaveCard) 1 else 0
        payuBizparams.cardNumber = cardOption.cardNumber
        payuBizparams.nameOnCard = cardOption.nameOnCard
        payuBizparams.expiryMonth = cardOption.expiryMonth
        payuBizparams.expiryYear = cardOption.expiryYear
        payuBizparams.cvv = cardOption.cvv
        payuBizparams.cardName = cardOption.cardAlias
        payuBizparams.lookupId = cardOption.lookupId
        payuBizparams.bankCode = cardOption.bankCode
        if (!(cardOption as? EMIOption)?.panNumber.isNullOrEmpty())
            payuBizparams.panNumber = (cardOption as? EMIOption)?.panNumber
        payuBizparams.hash = hash

        val payuSIParams = payUbizApiLayer.payUPaymentParams.payUSIParams

        if (payuSIParams != null) {
            val siParams = setSIDetails(payuSIParams)
            siParams.ccCardType = payuSIParams.ccCardType
            siParams.ccCategory = payuSIParams.ccCategory
            payuBizparams.siParams = siParams
        }

        return makePayment(cardOption)
    }

    private fun makeSavedCardPayment(
        savedCardOption: SavedCardOption,
        hash: String?
    ): Fragment? {
        payuBizparams.cardToken = savedCardOption.cardToken
        payuBizparams.cardName = savedCardOption.cardAlias
        payuBizparams.expiryYear = savedCardOption.expiryYear
        payuBizparams.expiryMonth = savedCardOption.expiryMonth
        payuBizparams.cvv = savedCardOption.cvv
        payuBizparams.lookupId = savedCardOption.lookupId
        payuBizparams.hash = hash

        val payuSIParams = payUbizApiLayer.payUPaymentParams.payUSIParams

        if (payuSIParams != null) {
            val siParams = setSIDetails(payuSIParams)
            siParams.ccCategory = savedCardOption.cardBinInfo?.cardType?.name
            if (savedCardOption.cardBinInfo?.cardCategory != null)
                siParams.ccCardType = savedCardOption.cardBinInfo?.cardCategory
            else
                siParams.ccCardType =
                    CommonUtils.getCardCategoryFromScheme(savedCardOption.cardBinInfo?.cardScheme!!)

            payuBizparams.siParams = siParams
        }
        payuBizparams.cardBin = null
        if (savedCardOption.networkToken.isNotEmpty()) {
            payuBizparams.networkToken = savedCardOption.networkToken
        }

        return makePayment(savedCardOption)
    }

    private fun makeNetbankingPayment(
        paymentOption: PaymentOption,
        hash: String?
    ): Fragment? {
        val hashMap = paymentOption.otherParams as? HashMap<String, Any?>

        if (hashMap != null
            && hashMap.containsKey(CP_BANK_CODE)
            && (hashMap[CP_BANK_CODE] as? String) != null
        ) {

            payuBizparams.bankCode = hashMap[CP_BANK_CODE] as? String
            payuBizparams.hash = hash

            val payuSIParams = payUbizApiLayer.payUPaymentParams.payUSIParams

            if (payuSIParams != null) {
                val siParams = setSIDetails(payuSIParams)

                val beneficiaryDetails = BeneficiaryDetails(
                    payuSIParams.beneficiaryDetail?.beneficiaryName,
                    payuSIParams.beneficiaryDetail?.beneficiaryAccountNumber,
                    payuSIParams.beneficiaryDetail?.beneficiaryIfsc,
                    CommonUtils.getBeneficiaryAccountTypeMapping(payuSIParams.beneficiaryDetail?.beneficiaryAccountType)
                )
                payuSIParams.beneficiaryDetail?.verificationMode?.let {
                    beneficiaryDetails.verificationMode = it.paymentApiParam
                }
                siParams.beneficiarydetail = beneficiaryDetails
                payuBizparams.siParams = siParams
            }
            return makePayment(paymentOption)
        }
        return null
    }

    private fun setSIDetails(payuSIParams: PayUSIParams?): SIParams {
        val siParams = SIParams()
        siParams.isFree_trial = payuSIParams?.isFreeTrial!!

        val siParamsDetails = SIParamsDetails()
        siParamsDetails.billingAmount = payuSIParams.billingAmount
        siParamsDetails.billingCurrency = payuSIParams.billingCurrency
        siParamsDetails.billingCycle = CommonUtils.getBillingCycleMapping(payuSIParams.billingCycle)
        siParamsDetails.billingInterval = payuSIParams.billingInterval
        siParamsDetails.paymentStartDate = payuSIParams.paymentStartDate
        siParamsDetails.paymentEndDate = payuSIParams.paymentEndDate
        siParamsDetails.remarks = payuSIParams.remarks
        siParamsDetails.billingLimit = CommonUtils.getBillingLimitMapping(payuSIParams.billingLimit)
        siParamsDetails.billingRule = CommonUtils.getBillingRuleMapping(payuSIParams.billingRule)
        siParamsDetails.isPreAuthorize = payuSIParams.isPreAuthTxn
        siParamsDetails.billingDate = payuSIParams.billingDate

        siParams.si_details = siParamsDetails
        return siParams
    }

    private fun makeEMIPayment(
        emiOption: EMIOption,
        hash: String?
    ): Fragment? {
        val hashMap = emiOption.otherParams as? HashMap<String, Any?>

        if (hashMap != null
            && hashMap.containsKey(CP_BANK_CODE)
            && (hashMap[CP_BANK_CODE] as? String) != null
        ) {

            payuBizparams.bankCode = hashMap[CP_BANK_CODE] as? String
            emiOption.bankCode = payuBizparams.bankCode
            return makeCardPayment(emiOption, hash)
        }
        return null
    }

    private fun makePayment(paymentOption: PaymentOption): Fragment? {

        if (paymentOption.paymentType != PaymentType.UPI_INTENT
            && !payuBizparams.bankCode.equals(PayuConstants.TEZ, ignoreCase = true)
            && !payuBizparams.bankCode.equals(CP_PPINTENT, ignoreCase = true)
        )
            baseTransactionListener?.showLoaderScreen(true)

        Log.d(TAG, "PaymentType =" + this.paymentType)

        val postData: PostData? = when (this.paymentType) {

            PaymentType.NB -> PaymentPostParams(payuBizparams, PayuConstants.NB).paymentPostParams
            PaymentType.CARD -> PaymentPostParams(payuBizparams, PayuConstants.CC).paymentPostParams
            PaymentType.UPI -> {
                if (payuBizparams.bankCode.equals(
                        PayuConstants.TEZ,
                        ignoreCase = true
                    )
                ) PaymentPostParams(payuBizparams, PayuConstants.TEZ).paymentPostParams
                else if (payuBizparams.bankCode.equals(
                        PayuConstants.TEZOMNI,
                        ignoreCase = true
                    ) && payuBizparams.vpa.isNullOrBlank() && CommonUtils.isValidPhone(payuBizparams.phone)
                ) PaymentPostParams(payuBizparams, PayuConstants.TEZOMNI).paymentPostParams
                else PaymentPostParams(payuBizparams, PayuConstants.UPI).paymentPostParams
            }

            PaymentType.UPI_INTENT -> {
                updateUpiIntentParams()
                PaymentPostParams(
                    payuBizparams,
                    PayuConstants.UPI_INTENT
                ).paymentPostParams
            }

            PaymentType.WALLET ->
                if (payuBizparams.bankCode.equals(CP_OLAM, true) && CommonUtils.isSdkAvailable(
                        PayuSdk.OLAMONEY.getClassName()
                    )
                ) {
                    PayUOlaMoneyPaymentParams().getPaymentPostData(payuBizparams)
                } else {
                    PaymentPostParams(payuBizparams, PayuConstants.CASH).paymentPostParams
                }

            PaymentType.BNPL ->
                PaymentPostParams(payuBizparams, PayuConstants.BNPL).paymentPostParams

            PaymentType.EMI -> {
                if (payuBizparams.bankCode.equals(
                        PayUCheckoutProConstants.CP_LAZYPAY,
                        ignoreCase = true
                    )
                ) {
                    PaymentPostParams(payuBizparams, PayuConstants.LAZYPAY).paymentPostParams
                } else {
                    PaymentPostParams(payuBizparams, PayuConstants.EMI).paymentPostParams
                }
            }

            PaymentType.NEFTRTGS -> PaymentPostParams(
                payuBizparams,
                PayuConstants.NEFT_RTGS
            ).paymentPostParams

            PaymentType.SODEXO -> PaymentPostParams(
                payuBizparams,
                PayuConstants.SODEXO
            ).paymentPostParams

            PaymentType.CLOSED_LOOP_WALLET -> PaymentPostParams(
                payuBizparams,
                PayuConstants.CLW
            ).paymentPostParams

            PaymentType.OPEN_LOOP_WALLET -> PaymentPostParams(
                payuBizparams,
                PayuConstants.OLW
            ).paymentPostParams

            else -> PaymentPostParams(payuBizparams, PayuConstants.CC).paymentPostParams
        }

        if ((postData != null) && (postData.code == PayuErrors.NO_ERROR)) {
            payuConfig.data = postData.result
            baseTransactionListener?.showLoaderScreen(false)
            if (payuBizparams.bankCode.equals(CP_PPINTENT, ignoreCase = true))
                return PaymentHelper().callPhonePeSDK(
                    context!!,
                    baseTransactionListener,
                    payuConfig.data
                )
//            else if (paymentType == PaymentType.CARD && InternalConfig.enable3dsSDK &&
//                InternalConfig.enableInternal3DSS && InternalConfig.threeDSSupportedBankList?.contains(
//                    paymentOption?.cardBinInfo?.issuingBank
//                ) == true && paymentOption.cardBinInfo?.isDomestic == true && !paymentOption.isQuickPayTxn
//            ) {
//                return invoke3DS(paymentOption)
//            } else if (paymentType == PaymentType.CARD && InternalConfig.enable3dsSDK &&
//                InternalConfig.enableInternal3DSS && InternalConfig.internationalOn3DSS
//                && paymentOption.cardBinInfo?.isDomestic == false
//            ) {
//                return invoke3DS(paymentOption)
//            }
            else if (payuBizparams.bankCode.equals(CP_PPSDKLES, ignoreCase = false)  || paymentOption.isSecureWebview || ((paymentOption.cardBinInfo?.isDomestic == true) && payUbizApiLayer.payUPaymentParams.enableNativeOTP && (DataConstant.supportedPaymentTypesForOtpAssist()
                    .contains(paymentType) || isBankCodeSupportedForOTPAssist(payuBizparams.bankCode)) && payuBizparams.siParams == null && !paymentOption.isQuickPayTxn && payuBizparams.lookupId.isNullOrEmpty() && CommonUtils.isSdkAvailable(
                    PayuSdk.OTP_ASSIST.getClassName()
                ))
            ) {
                return PaymentHelper().callOtpAssist(
                    context!!,
                    paymentOption,
                    baseTransactionListener,
                    checkoutListener,
                    payuConfig,
                    toolbar,
                    payUbizApiLayer.payUCheckoutProConfig,
                    payuBizparams
                )
            } else
                return PaymentHelper().callCB(
                    context!!,
                    paymentOption,
                    baseTransactionListener,
                    payuConfig,
                    toolbar,
                    payUbizApiLayer.payUCheckoutProConfig,
                    payuBizparams
                )

        } else {
            val errorResponse = ErrorResponse()
            errorResponse.errorMessage = postData?.result
            baseTransactionListener?.showLoaderScreen(false)
            baseTransactionListener?.onError(errorResponse)
        }
        return null
    }

//    private fun invoke3DS(paymentOption: PaymentOption): Fragment? {
//        if (context != null && context?.isFinishing == false && context?.isDestroyed == false)
//            PaymentHelper(
//            ).call3dsSDK(
//                paymentOption,
//                payuConfig, payUbizApiLayer.payUCheckoutProConfig,
//                toolbar,
//                context as AppCompatActivity,
//                payuBizparams,
//                checkoutListener,
//                baseTransactionListener
//            )
//        return null
//    }

    override fun getHashName(): String {
        val payuSIParams = payUbizApiLayer.payUPaymentParams.payUSIParams
        return if (payUbizApiLayer.payUPaymentParams.payUWealthProducts.isNullOrEmpty()
                .not()
        ) PayuConstants.PAYU_WEALTH_TECH_PAYMENT_SOURCE
        else if (payuSIParams != null)
            PayuConstants.SI_PAYMENT_SOURCE
        else if (InternalConfig.userAccountInfoList.isNullOrEmpty()
                .not()
        ) PayuConstants.TPV_PAYMENT_SOURCE
        else
            PayuConstants.PAYMENT_SOURCE
    }

//    override fun onHashGenerated(map: HashMap<String, String?>) {
//        if (!TextUtils.isEmpty(map[getHashName()]))
//            NavigationHandler(object : NavigationHandlerListener<Fragment?> {
//                override fun onResultReceived(result: Fragment?) {
//                    baseTransactionListener?.loadNextState(result)
//                }
//            }).executeTask { render(map[getHashName()]) }
//    }

    private fun isBankCodeSupportedForOTPAssist(bankCode : String): Boolean {
        for (bkCode in DataConstant.supportedBankCodesForOtpAssist()){
            if (bankCode.startsWith(bkCode)) return true
        }
        return false
    }

    /**
     * Function to update upi intent payuBizparams
     */
    private fun updateUpiIntentParams() {
        if (!paymentOption?.bankName.isNullOrEmpty()) {
            payuBizparams.userAgent = paymentOption?.userAgent

            val upiOption = paymentOption as? UPIOption
            payuBizparams.appName = upiOption?.appName
        }
    }

    private fun appendPricingResponseIds(paymentOption: PaymentOption) {
            val convFeeChargeForPayment: ArrayList<String> = ArrayList()
            paymentOption.feeCombinations?.convenienceFeeCharges?.forEach { convenienceFeeCharge ->
                convFeeChargeForPayment.add(convenienceFeeCharge.chargeUuid)
            }

            payuBizparams.requestUUID = paymentOption.feeCombinations?.requestUuid
            payuBizparams.combinationUUID = paymentOption.feeCombinations?.combinationUUID

            if (convFeeChargeForPayment.isNotEmpty()) payuBizparams.chargeUUIDs =
                convFeeChargeForPayment
        }

    private fun setOlwParams(olwPaymentOption: OlwPaymentOption){
        val olwParams = OlwParams()
        olwParams.otp = olwPaymentOption.otp
        olwParams.token = olwPaymentOption.token
        olwParams.mPin = olwPaymentOption.mPin
        olwParams.deviceId = InternalConfig.deviceId
        payuBizparams.olwParams = olwParams
    }

}